/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.gef;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.amp.agf.gef.GEFUtils;
import org.eclipse.amp.agf.gef.GenericEditPart;
import org.eclipse.amp.agf.gef.ScapeGraphEditPart;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.space.ILocation;
import org.eclipse.amp.axf.space.ILocation2D;
import org.eclipse.amp.axf.space.ILocationProvider;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.viewers.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScapeEditPart
extends GenericEditPart
implements PropertyChangeListener,
NodeEditPart {
    ICompositionProvider memberProvider;
    ILocationProvider locationProvider;
    private IFilter filter;
    boolean updating;

    public ScapeEditPart(ICompositionProvider memberProvider, ILocationProvider locationProvider, IFilter filter) {
        this.memberProvider = memberProvider;
        this.locationProvider = locationProvider;
        this.setFilter(filter);
    }

    @Override
    protected IFigure createFigure() {
        FreeformLayer f = null;
        Dimension calculateDimension = this.calculateDimension();
        if (calculateDimension != null) {
            ScalableFreeformLayeredPane scalableFreeformLayeredPane = new ScalableFreeformLayeredPane();
            f = scalableFreeformLayeredPane;
            f.setBounds(new Rectangle(new Point(0, 0), calculateDimension));
        } else {
            f = new FreeformLayer();
            ScapeEditPart rootScapeEditPart = this.getRootScapeEditPart();
            if (rootScapeEditPart != this) {
                f.setBounds(rootScapeEditPart.getFigure().getBounds());
            }
        }
        f.setLayoutManager((LayoutManager)new XYLayout());
        f.setOpaque(false);
        return f;
    }

    public synchronized void refresh() {
        if (this.getFilter() == null || this.getFilter().select(this.getModel())) {
            this.refreshVisuals();
            this.refreshChildren();
            if (this.memberProvider.isMutable(this.getModel())) {
                for (Object child : this.getChildren()) {
                    ((EditPart)child).refresh();
                    this.calculateConstraints((GraphicalEditPart)child);
                }
            } else {
                for (Object child : this.getChildren()) {
                    ((GenericEditPart)child).refreshVisuals();
                }
            }
            if (this instanceof ScapeGraphEditPart) {
                super.refreshSourceConnections();
                super.refreshTargetConnections();
            }
        }
    }

    public Dimension calculateDimension() {
        ILocation extent = this.locationProvider.getExtent(this.getModel());
        if (extent instanceof ILocation2D) {
            return GEFUtils.toScaledDimension((ILocation2D)extent);
        }
        return null;
    }

    protected void calculateConstraints(GraphicalEditPart editPart) {
        Object agent = editPart.getModel();
        ILocation2D location = (ILocation2D)this.locationProvider.getLocation(agent);
        if (location != null) {
            IFigure childFigure = editPart.getFigure();
            Rectangle bounds = new Rectangle(GEFUtils.toScaledPoint(location), childFigure.getSize());
            this.getFigure().setConstraint(childFigure, (Object)bounds);
        }
    }

    protected synchronized void refreshChildren() {
        block6: {
            block5: {
                EditPart editPart;
                if (this.getRootScapeEditPart() == this) break block5;
                if (!this.memberProvider.isMutable(this.getModel())) break block6;
                HashMap<Object, EditPart> modelToEditPart = new HashMap<Object, EditPart>();
                for (Object object : this.getChildren()) {
                    editPart = (EditPart)object;
                    modelToEditPart.put(editPart.getModel(), editPart);
                }
                for (Object agent : this.memberProvider.getIteratable(this.getModel())) {
                    editPart = (EditPart)modelToEditPart.remove(agent);
                    if (editPart != null) continue;
                    editPart = this.createChild(agent);
                    this.addChild(editPart, -1);
                }
                for (EditPart part : modelToEditPart.values()) {
                    this.removeChild(part);
                }
                break block6;
            }
            for (Object agent : this.memberProvider.getIteratable(this.getModel())) {
                boolean hasChild = false;
                for (Object child : this.getChildren()) {
                    EditPart part = (EditPart)child;
                    if (agent != part.getModel()) continue;
                    hasChild = true;
                    break;
                }
                if (hasChild) continue;
                EditPart editPart = this.createChild(agent);
                this.addChild(editPart, -1);
            }
        }
    }

    public synchronized List<ScapeGraphEditPart> getGraphParts() {
        if (this.memberProvider.isChildrenComposition(this.getModel())) {
            ArrayList<ScapeGraphEditPart> parts = new ArrayList<ScapeGraphEditPart>();
            for (Object editPart : this.getChildren()) {
                if (editPart instanceof ScapeGraphEditPart) {
                    parts.add((ScapeGraphEditPart)editPart);
                    continue;
                }
                if (!(editPart instanceof ScapeEditPart)) continue;
                parts.addAll(((ScapeEditPart)editPart).getGraphParts());
            }
            return parts;
        }
        return Collections.emptyList();
    }

    public ScapeEditPart getRootScapeEditPart() {
        if (this.memberProvider.getParent(this.getModel()) == null || !(this.getParent() instanceof ScapeEditPart)) {
            return this;
        }
        return ((ScapeEditPart)this.getParent()).getRootScapeEditPart();
    }

    public List getSourceConnections() {
        return Collections.EMPTY_LIST;
    }

    public List getTargetConnections() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void createEditPolicies() {
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public ICompositionProvider getMemberProvider() {
        return this.memberProvider;
    }

    public void setMemberProvider(ICompositionProvider memberProvider) {
        this.memberProvider = memberProvider;
    }

    public ILocationProvider getLocationProvider() {
        return this.locationProvider;
    }

    public void setLocationProvider(ILocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    public Object getModelRoot() {
        Object model = this.getModel();
        if (model instanceof IModel) {
            return ((IModel)this.getModel()).getRoot();
        }
        return model;
    }
}

