/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Matrix3f;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.graphics.GraphicsState;
import org.eclipse.draw3d.graphics.StatefulGraphics;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFont;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFontManager;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglLinePattern;
import org.eclipse.draw3d.util.ArcHelper;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.draw3d.util.ImageConverter;
import org.eclipse.draw3d.util.converter.ColorBufferInfo;
import org.eclipse.draw3d.util.converter.ImageConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;
import org.lwjgl.opengl.GL11;

public class LwjglGraphics
extends StatefulGraphics {
    private static final float ARC_LENGTH_FACTOR = 39.47842f;
    private static final float ARC_PRECISION = 0.5f;
    private static final float ARC_SEGMENTS_FACTOR = (float)Math.PI * 5;
    private static final double CLIP_BASE = 1000000.0;
    private static final int LINE_STYLES = 7;
    private static final Logger log = Logger.getLogger(LwjglGraphics.class.getName());
    private static final float[] TMP_F4 = new float[4];
    private boolean m_clippingEnabled = true;
    private Rectangle m_currentClip;
    private LwjglLinePattern m_currentLinePattern;
    private DisplayListManager m_displayListManager;
    private boolean m_disposed = false;
    private LwjglFontManager m_fontManager;
    private int m_height;
    private Map<Image, Integer> m_images = new HashMap<Image, Integer>();
    private LastColor m_lastColor = LastColor.UNKNOWN;
    private RasterOffset m_lastOffset;
    private Map<Object, LwjglLinePattern> m_linePatterns = new HashMap<Object, LwjglLinePattern>();
    private Boolean m_overrideTextAntialias;
    private int m_width;

    public LwjglGraphics(int i_width, int i_height, DisplayListManager i_displayListManager, LwjglFontManager i_fontManager) {
        if (i_displayListManager == null) {
            throw new NullPointerException("i_displayListManager must not be null");
        }
        if (i_fontManager == null) {
            throw new NullPointerException("i_fontManager must not be null");
        }
        this.m_width = i_width;
        this.m_height = i_height;
        this.glSetClip();
        this.glSetLineWidth();
        this.glSetLineStyle();
        this.glSetXORMode();
        this.m_fontManager = i_fontManager;
    }

    public void clipRect(Rectangle i_clipRect) {
        this.checkDisposed();
        super.clipRect(i_clipRect);
        this.glSetClip();
    }

    public void disableClipping() {
        if (this.m_clippingEnabled) {
            GL11.glDisable((int)12288);
            GL11.glDisable((int)12289);
            GL11.glDisable((int)12290);
            GL11.glDisable((int)12291);
            this.m_clippingEnabled = false;
        }
    }

    public void dispose() {
        this.checkDisposed();
        if (log.isLoggable(Level.FINE)) {
            log.fine("disposing graphics " + (Object)((Object)this));
        }
        this.m_fontManager = null;
        this.m_linePatterns = null;
        this.m_images = null;
        this.m_disposed = true;
    }

    public void drawArc(int i_x, int i_y, int i_w, int i_h, int i_offset, int i_length) {
        block7: {
            this.checkDisposed();
            this.glSetForegroundColor();
            this.glSetRasterOffset(RasterOffset.LINE);
            try {
                if (this.getState().getLineStyle() == 6) {
                    this.m_currentLinePattern.activate();
                    try {
                        GL11.glBegin((int)3);
                        this.glDrawTexturedArc(i_x, i_y, i_w, i_h, i_offset, i_length);
                        GL11.glEnd();
                        break block7;
                    }
                    finally {
                        this.m_currentLinePattern.deactivate();
                    }
                }
                GL11.glBegin((int)3);
                this.glDrawArc(i_x, i_y, i_w, i_h, i_offset, i_length);
                GL11.glEnd();
            }
            finally {
                this.glResetRasterOffset();
            }
        }
    }

    public void drawFocus(int i_x, int i_y, int i_w, int i_h) {
        this.checkDisposed();
        this.pushState();
        try {
            Display dev = Display.getCurrent();
            Color c = dev.getSystemColor(26);
            this.setForegroundColor(c);
            this.setLineStyle(1);
            this.setLineWidth(2);
            this.drawRectangle(i_x, i_y, i_w, i_h);
        }
        finally {
            this.popState();
        }
    }

    public void drawImage(Image i_srcImage, int i_x, int i_y) {
        this.checkDisposed();
        org.eclipse.swt.graphics.Rectangle bounds = i_srcImage.getBounds();
        int x1 = bounds.x;
        int y1 = bounds.y;
        int x2 = i_x;
        int y2 = i_y;
        int w = bounds.width;
        int h = bounds.height;
        this.drawImage(i_srcImage, x1, y1, w, h, x2, y2, w, h);
    }

    public void drawImage(Image i_srcImage, int i_x1, int i_y1, int i_w1, int i_h1, int i_x2, int i_y2, int i_w2, int i_h2) {
        this.checkDisposed();
        this.glSetRasterOffset(RasterOffset.POLYGON);
        try {
            GL11.glPushAttrib((int)262144);
            try {
                Integer textureId = this.m_images.get(i_srcImage);
                if (textureId == null) {
                    ImageConverter.ConversionSpecs specs = new ImageConverter.ConversionSpecs();
                    specs.foregroundAlpha = 255;
                    specs.textureWidth = i_w1;
                    specs.textureHeight = i_h1;
                    specs.clip = new org.eclipse.swt.graphics.Rectangle(i_x1, i_y1, i_w1, i_h1);
                    ColorBufferInfo info = new ColorBufferInfo(i_w1, i_h1, 6408, 5121, 1);
                    ByteBuffer buffer = Draw3DCache.getByteBuffer((int)info.getSize());
                    IntBuffer nameBuffer = Draw3DCache.getIntBuffer((int)1);
                    try {
                        ImageConverter converter = ImageConverter.getInstance();
                        buffer.rewind();
                        buffer = converter.imageToBuffer(i_srcImage, info, buffer, false);
                        nameBuffer.rewind();
                        GL11.glGenTextures((IntBuffer)nameBuffer);
                        textureId = nameBuffer.get(0);
                        GL11.glBindTexture((int)3553, (int)textureId);
                        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)i_w1, (int)i_h1, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
                        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
                        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                    }
                    catch (Throwable throwable) {
                        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{nameBuffer});
                        Draw3DCache.returnByteBuffer((ByteBuffer[])new ByteBuffer[]{buffer});
                        throw throwable;
                    }
                    Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{nameBuffer});
                    Draw3DCache.returnByteBuffer((ByteBuffer[])new ByteBuffer[]{buffer});
                } else {
                    GL11.glBindTexture((int)3553, (int)textureId);
                }
                GL11.glBegin((int)7);
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glVertex2i((int)i_x2, (int)i_y2);
                GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                GL11.glVertex2i((int)(i_x2 + i_w2), (int)i_y2);
                GL11.glTexCoord2f((float)1.0f, (float)1.0f);
                GL11.glVertex2i((int)(i_x2 + i_w2), (int)(i_y2 + i_h2));
                GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                GL11.glVertex2i((int)i_x2, (int)(i_y2 + i_h2));
                GL11.glEnd();
            }
            finally {
                GL11.glPopAttrib();
            }
        }
        finally {
            this.glResetRasterOffset();
        }
    }

    public void drawLine(int i_x1, int i_y1, int i_x2, int i_y2) {
        block7: {
            this.checkDisposed();
            this.glSetForegroundColor();
            this.glSetRasterOffset(RasterOffset.LINE);
            try {
                if (this.getState().getLineStyle() == 6) {
                    this.m_currentLinePattern.activate();
                    try {
                        float s = this.m_currentLinePattern.getS(i_x1, i_y1, i_x2, i_y2);
                        GL11.glBegin((int)1);
                        GL11.glTexCoord1f((float)0.0f);
                        GL11.glVertex2i((int)i_x1, (int)i_y1);
                        GL11.glTexCoord1d((double)s);
                        GL11.glVertex2i((int)i_x2, (int)i_y2);
                        GL11.glEnd();
                        break block7;
                    }
                    finally {
                        this.m_currentLinePattern.deactivate();
                    }
                }
                GL11.glBegin((int)1);
                GL11.glVertex2i((int)i_x1, (int)i_y1);
                GL11.glVertex2i((int)i_x2, (int)i_y2);
                GL11.glEnd();
            }
            finally {
                this.glResetRasterOffset();
            }
        }
    }

    public void drawOval(int i_x, int i_y, int i_w, int i_h) {
        this.drawArc(i_x, i_y, i_w, i_h, 0, 360);
    }

    public void drawPolygon(PointList i_points) {
        block7: {
            this.checkDisposed();
            this.glSetForegroundColor();
            this.glSetRasterOffset(RasterOffset.LINE);
            try {
                GL11.glPolygonMode((int)1032, (int)6913);
                if (this.getState().getLineStyle() == 6) {
                    this.m_currentLinePattern.activate();
                    try {
                        GL11.glBegin((int)2);
                        this.glDrawTexturedPointList(i_points);
                        GL11.glEnd();
                        break block7;
                    }
                    finally {
                        this.m_currentLinePattern.deactivate();
                    }
                }
                GL11.glBegin((int)2);
                this.glDrawPointList(i_points);
                GL11.glEnd();
            }
            finally {
                this.glResetRasterOffset();
            }
        }
    }

    public void drawPolyline(PointList i_points) {
        block8: {
            this.checkDisposed();
            if (i_points.size() < 2) {
                return;
            }
            this.glSetForegroundColor();
            this.glSetRasterOffset(RasterOffset.LINE);
            try {
                if (this.getState().getLineStyle() == 6) {
                    this.m_currentLinePattern.activate();
                    try {
                        GL11.glBegin((int)3);
                        this.glDrawTexturedPointList(i_points);
                        GL11.glEnd();
                        break block8;
                    }
                    finally {
                        this.m_currentLinePattern.deactivate();
                    }
                }
                GL11.glBegin((int)3);
                this.glDrawPointList(i_points);
                GL11.glEnd();
            }
            finally {
                this.glResetRasterOffset();
            }
        }
    }

    public void drawRectangle(int i_x, int i_y, int i_width, int i_height) {
        block7: {
            this.checkDisposed();
            this.glSetForegroundColor();
            this.glSetRasterOffset(RasterOffset.LINE);
            try {
                GL11.glPolygonMode((int)1032, (int)6913);
                if (this.getState().getLineStyle() == 6) {
                    this.m_currentLinePattern.activate();
                    try {
                        GL11.glBegin((int)2);
                        this.glDrawTexturedRectangle(i_x, i_y, i_width, i_height);
                        GL11.glEnd();
                        break block7;
                    }
                    finally {
                        this.m_currentLinePattern.deactivate();
                    }
                }
                GL11.glBegin((int)2);
                this.glDrawRectangle(i_x, i_y, i_width, i_height);
                GL11.glEnd();
            }
            finally {
                this.glResetRasterOffset();
            }
        }
    }

    public void drawRoundRectangle(Rectangle i_r, int i_arcWidth, int i_arcHeight) {
        block7: {
            this.checkDisposed();
            this.glSetForegroundColor();
            this.glSetRasterOffset(RasterOffset.LINE);
            try {
                GL11.glPolygonMode((int)1032, (int)6913);
                if (this.getState().getLineStyle() == 6) {
                    this.m_currentLinePattern.activate();
                    try {
                        GL11.glBegin((int)2);
                        this.glDrawTexturedRoundRectangle(i_r, i_arcWidth, i_arcHeight);
                        GL11.glEnd();
                        break block7;
                    }
                    finally {
                        this.m_currentLinePattern.deactivate();
                    }
                }
                GL11.glBegin((int)2);
                this.glDrawRoundRectangle(i_r, i_arcWidth, i_arcHeight);
                GL11.glEnd();
            }
            finally {
                this.glResetRasterOffset();
            }
        }
    }

    public void drawString(String i_s, int i_x, int i_y) {
        this.checkDisposed();
        this.glSetForegroundColor();
        this.glSetRasterOffset(RasterOffset.POLYGON);
        try {
            LwjglFont glFont = this.glGetFont();
            glFont.renderString(i_s, i_x, i_y, false);
        }
        finally {
            this.glResetRasterOffset();
        }
    }

    public void drawText(String i_s, int i_x, int i_y) {
        this.checkDisposed();
        this.glSetForegroundColor();
        this.glSetRasterOffset(RasterOffset.POLYGON);
        try {
            LwjglFont glFont = this.glGetFont();
            glFont.renderString(i_s, i_x, i_y, true);
        }
        finally {
            this.glResetRasterOffset();
        }
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.drawText(layout.getText(), x, y);
    }

    public void enableClipping() {
        if (!this.m_clippingEnabled) {
            this.m_clippingEnabled = true;
            this.glSetClip();
        }
    }

    private boolean equals(Object i_o1, Object i_o2) {
        if (i_o1 != null) {
            return i_o1.equals(i_o2);
        }
        if (i_o2 != null) {
            return i_o2.equals(i_o1);
        }
        return true;
    }

    public void fillArc(int i_x, int i_y, int i_w, int i_h, int i_offset, int i_length) {
        this.checkDisposed();
        this.glSetBackgroundColor();
        this.glSetRasterOffset(RasterOffset.POLYGON);
        try {
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glBegin((int)9);
            GL11.glVertex2f((float)((float)i_x + (float)i_w / 2.0f), (float)((float)i_y + (float)i_h / 2.0f));
            this.glDrawArc(i_x, i_y, i_w, i_h, i_offset, i_length);
            GL11.glEnd();
        }
        finally {
            this.glResetRasterOffset();
        }
    }

    public void fillGradient(int i_x, int i_y, int i_width, int i_height, boolean i_vertical) {
        this.checkDisposed();
        this.glSetRasterOffset(RasterOffset.POLYGON);
        GL11.glPushAttrib((int)64);
        try {
            GL11.glShadeModel((int)7425);
            int x1 = i_x;
            int y1 = i_y;
            int x2 = i_x + i_width;
            int y2 = i_y + i_height;
            GL11.glBegin((int)7);
            this.glSetForegroundColor();
            if (i_vertical) {
                GL11.glVertex2i((int)x1, (int)y1);
                GL11.glVertex2i((int)x2, (int)y1);
            } else {
                GL11.glVertex2i((int)x1, (int)y2);
                GL11.glVertex2i((int)x1, (int)y1);
            }
            this.glSetBackgroundColor();
            if (i_vertical) {
                GL11.glVertex2i((int)x2, (int)y2);
                GL11.glVertex2i((int)x1, (int)y2);
            } else {
                GL11.glVertex2i((int)x2, (int)y1);
                GL11.glVertex2i((int)x2, (int)y2);
            }
            GL11.glEnd();
        }
        finally {
            this.glResetRasterOffset();
            GL11.glPopAttrib();
        }
    }

    public void fillOval(int i_x, int i_y, int i_w, int i_h) {
        this.fillArc(i_x, i_y, i_w, i_h, 0, 360);
    }

    public void fillPolygon(PointList i_points) {
        this.checkDisposed();
        this.glSetBackgroundColor();
        this.glSetRasterOffset(RasterOffset.POLYGON);
        try {
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glBegin((int)9);
            this.glDrawPointList(i_points);
            GL11.glEnd();
        }
        finally {
            this.glResetRasterOffset();
        }
    }

    public void fillRectangle(int i_x, int i_y, int i_width, int i_height) {
        this.checkDisposed();
        this.glSetBackgroundColor();
        this.glSetRasterOffset(RasterOffset.POLYGON);
        try {
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glBegin((int)7);
            this.glDrawRectangle(i_x, i_y, i_width, i_height);
            GL11.glEnd();
        }
        finally {
            this.glResetRasterOffset();
        }
    }

    public void fillRoundRectangle(Rectangle i_r, int i_arcWidth, int i_arcHeight) {
        this.checkDisposed();
        this.glSetBackgroundColor();
        this.glSetRasterOffset(RasterOffset.POLYGON);
        try {
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glBegin((int)9);
            this.glDrawRoundRectangle(i_r, i_arcWidth, i_arcHeight);
            GL11.glEnd();
        }
        finally {
            this.glResetRasterOffset();
        }
    }

    public void fillString(String i_s, int i_x, int i_y) {
        this.checkDisposed();
        LwjglFont glFont = this.glGetFont();
        Point extent = glFont.getExtent(i_s, false);
        this.fillRectangle(i_x, i_y, extent.x, extent.y);
        this.drawString(i_s, i_x, i_y);
    }

    public void fillText(String i_s, int i_x, int i_y) {
        this.checkDisposed();
        LwjglFont glFont = this.glGetFont();
        Point extent = glFont.getExtent(i_s, true);
        this.fillRectangle(i_x, i_y, extent.x, extent.y);
        this.drawText(i_s, i_x, i_y);
    }

    public double getAbsoluteScale() {
        return super.getAbsoluteScale();
    }

    private void glDrawArc(int i_x, int i_y, int i_w, int i_h, int i_offset, int i_length) {
        float rOffset = (float)Math.toRadians(i_offset);
        float rLength = (float)Math.toRadians(i_length);
        ArcHelper helper = new ArcHelper(0.5f, (float)i_x, (float)i_y, (float)i_w, (float)i_h, rOffset + rLength, -rLength, false);
        for (IVector2f v : helper) {
            GL11.glVertex2f((float)v.getX(), (float)v.getY());
        }
    }

    private void glDrawPointList(PointList i_points) {
        int[] vertices = i_points.toIntArray();
        int i = 0;
        while (i < vertices.length) {
            int x = vertices[i];
            int y = vertices[i + 1];
            GL11.glVertex2i((int)x, (int)y);
            i += 2;
        }
    }

    private void glDrawRectangle(int i_x, int i_y, int i_width, int i_height) {
        int x1 = i_x;
        int y1 = i_y + i_height;
        int x2 = i_x + i_width;
        int y2 = i_y;
        GL11.glVertex2i((int)x1, (int)y1);
        GL11.glVertex2i((int)x1, (int)y2);
        GL11.glVertex2i((int)x2, (int)y2);
        GL11.glVertex2i((int)x2, (int)y1);
    }

    private void glDrawRoundRectangle(Rectangle i_r, int i_arcWidth, int i_arcHeight) {
        int x1 = i_r.x;
        int y1 = i_r.y;
        int x2 = x1 + i_r.width;
        int y2 = y1 + i_r.height;
        int w = i_arcWidth;
        int h = i_arcHeight;
        this.glDrawArc(x1, y2 - h, w, h, 180, 90);
        this.glDrawArc(x2 - w, y2 - h, w, h, 270, 90);
        this.glDrawArc(x2 - w, y1, w, h, 0, 90);
        this.glDrawArc(x1, y1, w, h, 90, 90);
    }

    private void glDrawTexturedArc(int i_x, int i_y, int i_w, int i_h, int i_offset, int i_length) {
        this.glDrawTexturedArc(i_x, i_y, i_w, i_h, i_offset, i_length, 0.0f);
    }

    private float glDrawTexturedArc(int i_x, int i_y, int i_w, int i_h, int i_offset, int i_length, float i_s) {
        float start = (float)Math.toRadians(i_offset);
        float length = (float)Math.toRadians(i_length);
        float xFactor = i_w / 2;
        float yFactor = i_h / 2;
        float avgRadius = (xFactor + yFactor) / 2.0f;
        float arcLength = 39.47842f * avgRadius / length;
        float inc = (float)Math.PI * 5 / arcLength;
        float xOffset = i_x + i_w / 2;
        float yOffset = i_y + i_h / 2;
        float lastX = xOffset + (float)Math.cos(start) * xFactor;
        float lastY = yOffset - (float)Math.sin(start) * yFactor;
        float s = i_s;
        GL11.glTexCoord1d((double)s);
        GL11.glVertex2d((double)lastX, (double)lastY);
        float a = start + inc;
        while (a < start + length) {
            float x = xOffset + (float)Math.cos(a) * xFactor;
            float y = yOffset - (float)Math.sin(a) * yFactor;
            GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS(lastX, lastY, x, y)));
            GL11.glVertex2d((double)x, (double)y);
            lastX = x;
            lastY = y;
            a += inc;
        }
        float x = xOffset + (float)Math.cos(start + length) * xFactor;
        float y = yOffset - (float)Math.sin(start + length) * yFactor;
        GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS(lastX, lastY, x, y)));
        GL11.glVertex2d((double)x, (double)y);
        return s;
    }

    private void glDrawTexturedPointList(PointList i_points) {
        int[] vertices = i_points.toIntArray();
        if (vertices.length > 1) {
            int lastX = vertices[0];
            int lastY = vertices[1];
            float s = 0.0f;
            GL11.glTexCoord1d((double)s);
            GL11.glVertex2i((int)lastX, (int)lastY);
            int i = 2;
            while (i < vertices.length) {
                int x = vertices[i];
                int y = vertices[i + 1];
                GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS(lastX, lastY, x, y)));
                GL11.glVertex2i((int)x, (int)y);
                lastX = x;
                lastY = y;
                i += 2;
            }
        }
    }

    private void glDrawTexturedRectangle(int i_x, int i_y, int i_width, int i_height) {
        int x1 = i_x;
        int y1 = i_y + i_height;
        int x2 = i_x + i_width;
        int y2 = i_y;
        float s = 0.0f;
        GL11.glTexCoord1d((double)s);
        GL11.glVertex2i((int)x1, (int)y1);
        GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS(x1, y1, x1, y2)));
        GL11.glVertex2i((int)x1, (int)y2);
        GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS(x1, y2, x2, y2)));
        GL11.glVertex2i((int)x2, (int)y2);
        GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS(x2, y2, x2, y1)));
        GL11.glVertex2i((int)x2, (int)y1);
    }

    private void glDrawTexturedRoundRectangle(Rectangle i_r, int i_arcWidth, int i_arcHeight) {
        int x1 = i_r.x;
        int y1 = i_r.y;
        int x2 = x1 + i_r.width;
        int y2 = y1 + i_r.height;
        int w = i_arcWidth;
        int h = i_arcHeight;
        float w2 = w / 2;
        float h2 = h / 2;
        float s = 0.0f;
        GL11.glTexCoord1d((double)s);
        GL11.glVertex2i((int)x1, (int)(y1 + h / 2));
        GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS((float)x1, (float)y1 + h2, (float)x1, (float)y2 - h2)));
        GL11.glVertex2i((int)x1, (int)(y2 - h / 2));
        s = this.glDrawTexturedArc(x1, y2 - h, w, h, 180, 90, s);
        GL11.glVertex2d((double)((float)x1 + w2), (double)y2);
        GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS((float)x1 + w2, (float)y2, (float)x2 - w2, (float)y2)));
        GL11.glVertex2d((double)((float)x2 - w2), (double)y2);
        s = this.glDrawTexturedArc(x2 - w, y2 - h, w, h, 270, 90, s);
        GL11.glVertex2d((double)x2, (double)((float)y2 - h2));
        GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS((float)x2, (float)y2 - h2, (float)x2, (float)y1 + h2)));
        GL11.glVertex2d((double)x2, (double)((float)y1 + h2));
        s = this.glDrawTexturedArc(x2 - w, y1, w, h, 0, 90, s);
        GL11.glVertex2d((double)((float)x2 - w2), (double)y1);
        GL11.glTexCoord1d((double)(s += this.m_currentLinePattern.getS((float)x2 - w2, (float)y1, (float)x1 + w2, (float)y1)));
        GL11.glVertex2d((double)((float)x1 + w2), (double)y1);
        this.glDrawTexturedArc(x1, y1, w, h, 90, 90, s);
    }

    private LwjglFont glGetFont() {
        int antialias = this.getAntialias();
        if (this.m_overrideTextAntialias != null) {
            antialias = this.m_overrideTextAntialias != false ? 1 : 0;
        }
        Font font = this.getState().getFont();
        return this.m_fontManager.getFont(font, ' ', '\u007f', antialias == 1);
    }

    private void glResetRasterOffset() {
        if (this.m_lastOffset == null) {
            throw new IllegalStateException("raster offset was reset");
        }
        if (this.m_lastOffset.getOffset() != 0.0f) {
            GL11.glTranslatef((float)(-this.m_lastOffset.getOffset()), (float)(-this.m_lastOffset.getOffset()), (float)0.0f);
        }
        this.m_lastOffset = null;
    }

    private void glRestoreState(GraphicsState i_previous) {
        Matrix3f transformation = i_previous.getTransformation();
        if (transformation != null && !IMatrix3f.IDENTITY.equals((IMatrix3f)transformation)) {
            FloatBuffer buffer = Draw3DCache.getFloatBuffer((int)9);
            Matrix3f inverse = Draw3DCache.getMatrix3f();
            try {
                Math3D.invert((IMatrix3f)transformation, (Matrix3f)inverse);
                buffer.rewind();
                inverse.toBufferRowMajor(buffer);
                buffer.rewind();
                GL11.glMatrixMode((int)5888);
                GL11.glMultMatrix((FloatBuffer)buffer);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnFloatBuffer((FloatBuffer[])new FloatBuffer[]{buffer});
                Draw3DCache.returnMatrix3f((Matrix3f[])new Matrix3f[]{inverse});
                throw throwable;
            }
            Draw3DCache.returnFloatBuffer((FloatBuffer[])new FloatBuffer[]{buffer});
            Draw3DCache.returnMatrix3f((Matrix3f[])new Matrix3f[]{inverse});
        }
        if (i_previous.getClip() == null) {
            if (this.getState().getClip() != null) {
                this.glSetClip();
            }
        } else if (!i_previous.getClip().equals((Object)this.getState().getClip())) {
            this.glSetClip();
        }
        if (i_previous.getLineWidth() != this.getState().getLineWidth()) {
            this.glSetLineWidth();
        }
        if (i_previous.getLineStyle() != this.getState().getLineStyle() || i_previous.getLineStyle() == 6 && this.getState().getLineStyle() == 6 && !Arrays.equals(i_previous.getLineDash(), this.getState().getLineDash())) {
            this.glSetLineStyle();
        }
        if (i_previous.getXORMode() != this.getState().getXORMode()) {
            this.glSetXORMode();
        }
        if (i_previous.getAntialias() != this.getState().getAntialias()) {
            this.glSetAntialias();
        }
        this.m_lastColor = LastColor.UNKNOWN;
    }

    private void glSetAntialias() {
        if (this.getState().getAntialias() == 1) {
            GL11.glEnable((int)2848);
            GL11.glEnable((int)2832);
            GL11.glEnable((int)2881);
        } else {
            GL11.glDisable((int)2848);
            GL11.glDisable((int)2832);
            GL11.glDisable((int)2881);
        }
    }

    private void glSetBackgroundColor() {
        if (this.m_lastColor == LastColor.BACKGROUND) {
            return;
        }
        Color backgroundColor = this.getState().getBackgroundColor();
        int alpha = this.getState().getAlpha();
        ColorConverter.toFloatArray((Color)backgroundColor, (int)alpha, (float[])TMP_F4);
        GL11.glColor4f((float)TMP_F4[0], (float)TMP_F4[1], (float)TMP_F4[2], (float)TMP_F4[3]);
        this.m_lastColor = LastColor.BACKGROUND;
    }

    private void glSetClip() {
        if (!this.m_clippingEnabled) {
            return;
        }
        PrecisionRectangle clip = this.getState().getClip();
        if (clip == null) {
            if (this.m_currentClip != null) {
                GL11.glDisable((int)12288);
                GL11.glDisable((int)12289);
                GL11.glDisable((int)12290);
                GL11.glDisable((int)12291);
                this.m_currentClip = null;
            }
            return;
        }
        if (clip.equals((Object)this.m_currentClip)) {
            return;
        }
        if (this.m_currentClip == null) {
            this.m_currentClip = new Rectangle();
        }
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        try {
            DoubleBuffer buffer = Draw3DCache.getDoubleBuffer((int)16);
            try {
                double b;
                double a;
                if (clip.x > 0) {
                    a = 1000000.0 / (double)clip.x;
                    buffer.put(0, a);
                    buffer.put(1, 0.0);
                    buffer.put(2, 0.0);
                    buffer.put(3, -1000000.0);
                    GL11.glEnable((int)12288);
                    GL11.glClipPlane((int)12288, (DoubleBuffer)buffer);
                } else {
                    GL11.glDisable((int)12288);
                }
                if (clip.y > 0) {
                    b = 1000000.0 / (double)clip.y;
                    buffer.put(0, 0.0);
                    buffer.put(1, b);
                    buffer.put(2, 0.0);
                    buffer.put(3, -1000000.0);
                    GL11.glEnable((int)12289);
                    GL11.glClipPlane((int)12289, (DoubleBuffer)buffer);
                } else {
                    GL11.glDisable((int)12289);
                }
                if (clip.x + clip.width < this.m_width - 1) {
                    a = -1000000.0 / (double)(clip.x + clip.width);
                    buffer.put(0, a);
                    buffer.put(1, 0.0);
                    buffer.put(2, 0.0);
                    buffer.put(3, 1000000.0);
                    GL11.glEnable((int)12290);
                    GL11.glClipPlane((int)12290, (DoubleBuffer)buffer);
                } else {
                    GL11.glDisable((int)12290);
                }
                if (clip.y + clip.height < this.m_height - 1) {
                    b = -1000000.0 / (double)(clip.y + clip.height);
                    buffer.put(0, 0.0);
                    buffer.put(1, b);
                    buffer.put(2, 0.0);
                    buffer.put(3, 1000000.0);
                    GL11.glEnable((int)12291);
                    GL11.glClipPlane((int)12291, (DoubleBuffer)buffer);
                } else {
                    GL11.glDisable((int)12291);
                }
                this.m_currentClip.setBounds((Rectangle)clip);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnDoubleBuffer((DoubleBuffer[])new DoubleBuffer[]{buffer});
                throw throwable;
            }
            Draw3DCache.returnDoubleBuffer((DoubleBuffer[])new DoubleBuffer[]{buffer});
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    private void glSetForegroundColor() {
        if (this.m_lastColor == LastColor.FOREGROUND) {
            return;
        }
        Color foregroundColor = this.getState().getForegroundColor();
        int alpha = this.getState().getAlpha();
        ColorConverter.toFloatArray((Color)foregroundColor, (int)alpha, (float[])TMP_F4);
        GL11.glColor4f((float)TMP_F4[0], (float)TMP_F4[1], (float)TMP_F4[2], (float)TMP_F4[3]);
        this.m_lastColor = LastColor.FOREGROUND;
    }

    private void glSetLineStyle() {
        int lineStyle = this.getState().getLineStyle();
        switch (lineStyle) {
            case 1: {
                this.m_currentLinePattern = null;
                GL11.glDisable((int)2852);
                break;
            }
            case 2: {
                this.m_currentLinePattern = null;
                GL11.glLineStipple((int)3, (short)16191);
                GL11.glEnable((int)2852);
                break;
            }
            case 3: {
                this.m_currentLinePattern = null;
                GL11.glLineStipple((int)3, (short)13107);
                GL11.glEnable((int)2852);
                break;
            }
            case 4: {
                this.m_currentLinePattern = null;
                GL11.glLineStipple((int)3, (short)28527);
                GL11.glEnable((int)2852);
                break;
            }
            case 5: {
                this.m_currentLinePattern = null;
                GL11.glLineStipple((int)3, (short)22359);
                GL11.glEnable((int)2852);
                break;
            }
            case 6: {
                GL11.glDisable((int)2852);
                int[] dashPattern = this.getState().getLineDash();
                Object key = LwjglLinePattern.getKey(dashPattern);
                this.m_currentLinePattern = this.m_linePatterns.get(key);
                if (this.m_currentLinePattern != null) break;
                this.m_currentLinePattern = new LwjglLinePattern(dashPattern, this.m_displayListManager);
                this.m_linePatterns.put(key, this.m_currentLinePattern);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown line style: " + lineStyle);
            }
        }
    }

    private void glSetLineWidth() {
        float lineWidth = this.getState().getLineWidth();
        GL11.glLineWidth((float)lineWidth);
    }

    private void glSetRasterOffset(RasterOffset i_offset) {
        if (this.m_lastOffset != null) {
            throw new IllegalStateException("raster offset was not reset");
        }
        if (i_offset.getOffset() != 0.0f) {
            GL11.glTranslatef((float)i_offset.getOffset(), (float)i_offset.getOffset(), (float)0.0f);
        }
        this.m_lastOffset = i_offset;
    }

    private void glSetXORMode() {
        if (this.getState().getXORMode()) {
            GL11.glEnable((int)3058);
            GL11.glLogicOp((int)5382);
        } else {
            GL11.glDisable((int)3058);
        }
    }

    public boolean isClippingEnabled() {
        return this.m_clippingEnabled;
    }

    public void popState() {
        GraphicsState currentState = this.getState();
        super.popState();
        this.glRestoreState(currentState);
    }

    public void restoreState() {
        GraphicsState currentState = this.getState();
        super.restoreState();
        this.glRestoreState(currentState);
    }

    public void rotate(float i_degrees) {
        super.rotate(i_degrees);
        if (i_degrees != 0.0f) {
            GL11.glRotatef((float)i_degrees, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public void scale(double i_amount) {
        this.scale((float)i_amount, (float)i_amount);
    }

    public void scale(float i_horizontal, float i_vertical) {
        super.scale(i_horizontal, i_vertical);
        if (i_horizontal != 0.0f || i_vertical != 0.0f) {
            GL11.glScalef((float)i_horizontal, (float)i_vertical, (float)0.0f);
        }
    }

    public void setClip(Rectangle i_clip) {
        PrecisionRectangle previous = this.getState().getClip();
        super.setClip(i_clip);
        if (!this.equals(previous, this.getState().getClip())) {
            this.glSetClip();
        }
    }

    public void setLineDash(float[] i_dash) {
        int[] previous = this.getState().getLineDash();
        super.setLineDash(i_dash);
        if (!Arrays.equals(previous, this.getState().getLineDash())) {
            this.glSetLineStyle();
        }
    }

    public void setLineDash(int[] i_dash) {
        int[] previous = this.getState().getLineDash();
        super.setLineDash(i_dash);
        if (!Arrays.equals(previous, this.getState().getLineDash())) {
            this.glSetLineStyle();
        }
    }

    public void setLineStyle(int i_lineStyle) {
        if ((i_lineStyle & 7) == 0) {
            throw new IllegalArgumentException("unknown line style: " + i_lineStyle);
        }
        int previous = this.getState().getLineStyle();
        super.setLineStyle(i_lineStyle);
        if (previous != this.getLineStyle()) {
            this.glSetLineStyle();
        }
    }

    public void setLineWidth(int i_lineWidth) {
        this.setLineWidthFloat(i_lineWidth);
    }

    public void setLineWidthFloat(float i_lineWidth) {
        float previous = this.getLineWidthFloat();
        super.setLineWidthFloat(i_lineWidth);
        if (previous != this.getLineWidthFloat()) {
            this.glSetLineWidth();
        }
    }

    public void setOverrideTextAntialias(Boolean i_overrideTextAntialias) {
        this.m_overrideTextAntialias = i_overrideTextAntialias;
    }

    public void setXORMode(boolean i_enabled) {
        boolean previous = this.getXORMode();
        super.setXORMode(i_enabled);
        if (previous != this.getXORMode()) {
            this.glSetXORMode();
        }
    }

    public void shear(float i_horz, float i_vert) {
        super.shear(i_horz, i_vert);
        if (i_horz != 0.0f || i_vert != 0.0f) {
            FloatBuffer buffer = Draw3DCache.getFloatBuffer((int)16);
            Matrix4f matrix = Draw3DCache.getMatrix4f();
            try {
                matrix.setIdentity();
                matrix.set(1, 0, i_horz);
                matrix.set(0, 1, i_vert);
                buffer.rewind();
                matrix.toBufferRowMajor(buffer);
                buffer.rewind();
                GL11.glMultMatrix((FloatBuffer)buffer);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnFloatBuffer((FloatBuffer[])new FloatBuffer[]{buffer});
                Draw3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{matrix});
                throw throwable;
            }
            Draw3DCache.returnFloatBuffer((FloatBuffer[])new FloatBuffer[]{buffer});
            Draw3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{matrix});
        }
    }

    public void translate(float i_dx, float i_dy) {
        super.translate(i_dx, i_dy);
        if (i_dx != 0.0f || i_dy != 0.0f) {
            GL11.glTranslatef((float)i_dx, (float)i_dy, (float)0.0f);
        }
    }

    public void translate(int i_dx, int i_dy) {
        this.translate((float)i_dx, (float)i_dy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LastColor {
        BACKGROUND,
        FOREGROUND,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RasterOffset {
        LINE,
        POINT,
        POLYGON;


        public float getOffset() {
            switch (this) {
                case POLYGON: {
                    return 0.0f;
                }
                case LINE: 
                case POINT: {
                    return 0.0f;
                }
            }
            throw new AssertionError((Object)("unknown raster offset enum: " + (Object)((Object)this)));
        }
    }
}

