/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import org.ascape.model.Agent;
import org.ascape.util.data.UnitIntervalDataPoint;
import org.ascape.util.data.ValueNotInRangeException;
import org.ascape.util.vis.ColorFeature;
import org.ascape.view.vis.AgentView;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;

public class Plot2DView
extends AgentView {
    private static final long serialVersionUID = 431317441800986544L;
    private UnitIntervalDataPoint xDataPoint;
    private UnitIntervalDataPoint yDataPoint;
    private ColorFeature colorFeature;
    private int plotSize;

    public Plot2DView() {
        super("Plot 2D View");
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    private void drawAgent(Graphics graphics, Agent a) {
        try {
            graphics.drawRectangle((int)(this.xDataPoint.getAssertedValue((Object)a) * (double)this.plotSize), (int)((1.0 - this.yDataPoint.getAssertedValue((Object)a)) * (double)this.plotSize) - 1, 1, 1);
        }
        catch (ValueNotInRangeException valueNotInRangeException) {}
    }

    public void updateScapeGraphics(Graphics graphics) {
        this.plotSize = this.getSize().height;
        for (Agent agent : this.getScape()) {
            graphics.setForegroundColor(this.colorFeature.getColor(agent));
            this.drawAgent(graphics, agent);
        }
        super.updateScapeGraphics(graphics);
    }

    public UnitIntervalDataPoint getXDataPoint() {
        return this.xDataPoint;
    }

    public void setXDataPoint(UnitIntervalDataPoint xDataPoint) {
        this.xDataPoint = xDataPoint;
    }

    public UnitIntervalDataPoint getYDataPoint() {
        return this.yDataPoint;
    }

    public void setYDataPoint(UnitIntervalDataPoint yDataPoint) {
        this.yDataPoint = yDataPoint;
    }

    public ColorFeature getColorFeature() {
        return this.colorFeature;
    }

    public void setColorFeature(ColorFeature colorFeature) {
        this.colorFeature = colorFeature;
    }
}

