/**
 * <copyright>
 * </copyright>
 *
 * $Id: RunValidator.java,v 1.3 2009/09/24 03:26:03 mparker Exp $
 */
package org.eclipse.amp.amf.testing.ares.validation;

import java.util.Date;

import org.eclipse.amp.amf.parameters.aPar.Parameter;

import org.eclipse.amp.amf.testing.aTest.Constraint;
import org.eclipse.amp.amf.testing.aTest.Model;

import org.eclipse.amp.amf.testing.ares.ConstraintTest;
import org.eclipse.amp.amf.testing.ares.ResultType;

import org.eclipse.emf.common.util.EList;

import org.metaabm.SContext;

/**
 * A sample validator interface for {@link org.eclipse.amp.amf.testing.ares.Run}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface RunValidator {
    boolean validate();

    boolean validateModel(SContext value);
    boolean validateTest(Model value);
    boolean validateParameterization(org.eclipse.amp.amf.parameters.aPar.Model value);
    boolean validateResult(ResultType value);
    boolean validateParameters(EList<Parameter> value);
    boolean validateConstraints(EList<Constraint> value);
    boolean validateStarted(Date value);
    boolean validateFinished(Date value);
    boolean validateResults(EList<ConstraintTest> value);
}
