/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.gef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.amp.agf.gef.NetworkConnection;
import org.eclipse.amp.agf.gef.ScapeEditPart;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.space.IGraphProvider;
import org.eclipse.amp.axf.space.ILocationProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScapeGraphEditPart
extends ScapeEditPart {
    List<NetworkConnection> connections;
    Map<Object, List<NetworkConnection>> targets;
    Map<Object, List<NetworkConnection>> sources;
    private IGraphProvider graphProvider;

    public ScapeGraphEditPart(ICompositionProvider memberProvider, ILocationProvider locationProvider, IGraphProvider graphProvider, IFilter filter) {
        super(memberProvider, locationProvider, filter);
    }

    @Override
    protected synchronized void refreshChildren() {
        HashMap adj = this.graphProvider.getAdjacencyMap(this.getModel());
        this.connections = new ArrayList<NetworkConnection>(adj.size());
        this.sources = new HashMap<Object, List<NetworkConnection>>();
        this.targets = new HashMap<Object, List<NetworkConnection>>();
        Iterator iterator = adj.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            Object source = entry.getKey();
            List<NetworkConnection> sourceTargets = this.getConnectList(source, this.sources);
            sourceTargets.clear();
            for (Object target : this.graphProvider.getNeighborsFor(this.getModel(), source)) {
                List<NetworkConnection> targetSources = this.getConnectList(target, this.targets);
                NetworkConnection connect = null;
                for (NetworkConnection networkConnection : sourceTargets) {
                    if (networkConnection.target != target) continue;
                    connect = networkConnection;
                    break;
                }
                if (connect == null) {
                    connect = new NetworkConnection(source, target);
                }
                this.connections.add(connect);
                targetSources.add(connect);
                sourceTargets.add(connect);
            }
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.graphProvider = (IGraphProvider)Platform.getAdapterManager().getAdapter(model, ICompositionProvider.class);
    }

    public synchronized List<NetworkConnection> getConnectList(Object source, Map<Object, List<NetworkConnection>> map) {
        List<NetworkConnection> connects = map.get(source);
        if (connects == null) {
            connects = new ArrayList<NetworkConnection>();
            map.put(source, connects);
        }
        return connects;
    }

    public synchronized List getModelChildren() {
        return this.connections;
    }

    public synchronized List getModelSourceConnections(Object modelObject) {
        List list = this.sources.get(modelObject);
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public synchronized List getModelTargetConnections(Object modelObject) {
        List list = this.targets.get(modelObject);
        return list != null ? list : Collections.EMPTY_LIST;
    }
}

