/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.gen.ide;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.amp.amf.gen.ide.GenIDEPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtend.XtendFacade;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.emf.EmfMetaModel;

public class ModelMarkerHelper {
    public static final String MARKER_ID = "org.eclipse.amp.amf.gen.ide.modelproblem";
    public static final String MARKER_ELEMENT = "modelElement";
    IResource resource;
    XtendFacade extendNames;

    public ModelMarkerHelper(IResource resource) {
        this.resource = resource;
        this.extendNames = XtendFacade.create((String[])new String[]{"metaabm::tmpl::names"});
        EmfMetaModel emfModel = new EmfMetaModel();
        emfModel.setMetaModelPackage("org.metaabm.MetaABMPackage");
        this.extendNames.registerMetaModel((MetaModel)emfModel);
    }

    public void deleteMarkers() {
        try {
            this.resource.deleteMarkers(MARKER_ID, false, 2);
        }
        catch (CoreException ce) {
            GenIDEPlugin.INSTANCE.log((Object)ce);
        }
    }

    public void addMarkers(Issues issues) {
        this.addMarkers(issues.getErrors(), 2);
        this.addMarkers(issues.getWarnings(), 1);
    }

    public void addMarkers(final MWEDiagnostic[] issues, final int severity) {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        MWEDiagnostic[] mWEDiagnosticArray = issues;
                        int n = issues.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MWEDiagnostic issue = mWEDiagnosticArray[n2];
                            ModelMarkerHelper.this.createMarker(severity, issue);
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        GenIDEPlugin.INSTANCE.log((Object)e);
                    }
                }
            }.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            GenIDEPlugin.INSTANCE.log(e);
        }
    }

    private void createMarker(int severity, MWEDiagnostic issue) throws CoreException {
        IMarker marker = this.resource.createMarker(MARKER_ID);
        marker.setAttribute("message", (Object)issue.getMessage());
        marker.setAttribute("severity", severity);
        if (issue.getElement() instanceof EObject) {
            EObject eObject = (EObject)issue.getElement();
            String location = (String)this.extendNames.call("usageLabel", new Object[]{eObject});
            marker.setAttribute("location", (Object)location);
            String objectPath = eObject.eResource().getURIFragment(eObject);
            String filePath = String.valueOf(this.resource.getProject().getName()) + "/" + this.resource.getProjectRelativePath().toString();
            String finalPath = URI.createPlatformResourceURI((String)filePath, (boolean)false) + "#" + objectPath;
            marker.setAttribute(MARKER_ELEMENT, (Object)finalPath);
        }
    }
}

