/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import org.ascape.model.Agent;
import org.ascape.model.Cell;
import org.ascape.model.CellOccupant;
import org.ascape.model.HostCell;
import org.ascape.util.vis.ColorFeature;
import org.ascape.util.vis.ColorFeatureConcrete;
import org.ascape.util.vis.DrawFeature;
import org.ascape.view.vis.CellView;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Color;

public abstract class HostedAgentView
extends CellView {
    private static final long serialVersionUID = -1356787381474111709L;
    private ColorFeature hostedAgentColorFeature;
    public final DrawFeature agents_oval_cells_draw_feature = new DrawFeature("Default Oval Agent"){
        private static final long serialVersionUID = -6272510346583316008L;

        @Override
        public final void draw(Graphics g, Object object, int width, int height) {
            if (object != null) {
                g.setBackgroundColor(HostedAgentView.this.agentColorFeature.getColor(object));
                g.fillRectangle(0, 0, width, height);
                CellOccupant occupant = (CellOccupant)((Cell)object).getOccupant();
                if (occupant != null) {
                    g.setBackgroundColor(HostedAgentView.this.hostedAgentColorFeature.getColor(occupant));
                    g.fillOval(1, 1, width - 2, height - 2);
                }
            }
        }
    };
    public final DrawFeature agents_oval_cells_boundary_draw_feature = new DrawFeature("Default Oval Agent"){
        private static final long serialVersionUID = 4911219526716031691L;

        @Override
        public final void draw(Graphics g, Object object, int width, int height) {
            g.setBackgroundColor(HostedAgentView.this.agentColorFeature.getColor(object));
            g.fillRectangle(0, 0, width, height);
            CellOccupant occupant = (CellOccupant)((Cell)object).getOccupant();
            if (occupant != null) {
                g.setForegroundColor(HostedAgentView.this.agentColorFeature.getColor(object));
                g.setBackgroundColor(HostedAgentView.this.hostedAgentColorFeature.getColor(occupant));
                g.drawOval(1, 1, width - 2, height - 2);
                g.fillOval(1, 1, width - 2, height - 2);
            }
        }
    };
    public final DrawFeature agents_oval_cells_desc_draw_feature = new DrawFeature("Default Oval Agent"){
        private static final long serialVersionUID = -4498969872571450812L;

        @Override
        public final void draw(Graphics g, Object object, int width, int height) {
            CellOccupant occupant = (CellOccupant)((Cell)object).getOccupant();
            if (occupant != null) {
                g.setForegroundColor(HostedAgentView.this.hostedAgentColorFeature.getColor(object));
                g.drawString(occupant.toString(), width, height);
            }
        }
    };
    public final DrawFeature agents_fill_cells_draw_feature = new DrawFeature("Default Fill Agent"){
        private static final long serialVersionUID = -2515862414367192654L;

        @Override
        public final void draw(Graphics g, Object object, int width, int height) {
            CellOccupant occupant = (CellOccupant)((Cell)object).getOccupant();
            if (occupant != null) {
                g.setBackgroundColor(HostedAgentView.this.hostedAgentColorFeature.getColor(occupant));
                g.fillRectangle(0, 0, width, height);
            } else {
                g.setBackgroundColor(HostedAgentView.this.agentColorFeature.getColor(object));
                g.fillRectangle(0, 0, width, height);
            }
        }
    };

    public HostedAgentView(String name) {
        super(name);
    }

    @Override
    public void createFeatures() {
        super.createFeatures();
        if (this.getScape().getPrototype() instanceof HostCell) {
            if (this.hostedAgentColorFeature == null) {
                this.hostedAgentColorFeature = new ColorFeatureConcrete("Default Agent Color"){
                    private static final long serialVersionUID = -197439982190788937L;

                    @Override
                    public Color getColor(Object object) {
                        return (Color)((Agent)object).getPlatformColor();
                    }
                };
            }
            this.addDrawFeature(this.agents_oval_cells_draw_feature);
            this.agents_oval_cells_draw_feature.setName(String.valueOf(this.getName()) + " Agents");
            this.addDrawFeature(this.agents_oval_cells_boundary_draw_feature);
            this.agents_oval_cells_boundary_draw_feature.setName(String.valueOf(this.getName()) + " Agents Boundary");
            this.addDrawFeature(this.agents_fill_cells_draw_feature);
            this.agents_fill_cells_draw_feature.setName(String.valueOf(this.getName()) + " Agents Fill");
            this.addDrawFeature(this.agents_oval_cells_desc_draw_feature);
            this.agents_oval_cells_desc_draw_feature.setName(String.valueOf(this.getName()) + " Agents Description");
            this.getDrawSelection().clearSelection();
            this.getDrawSelection().setSelected((Object)this.agents_oval_cells_draw_feature, true);
        }
    }

    @Override
    public ColorFeature getPrimaryAgentColorFeature() {
        return this.agentColorFeature;
    }

    @Override
    public void setPrimaryAgentColorFeature(ColorFeature cellColorFeature) {
        this.agentColorFeature = cellColorFeature;
    }

    public ColorFeature getHostedAgentColorFeature() {
        return this.hostedAgentColorFeature;
    }

    public void setHostedAgentColorFeature(ColorFeature agentColorFeature) {
        this.hostedAgentColorFeature = agentColorFeature;
    }
}

