/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.nonvis;

import java.util.List;
import org.ascape.model.event.ScapeEvent;
import org.ascape.util.PropertyAccessor;
import org.ascape.util.Utility;
import org.ascape.view.nonvis.DataView;
import org.ascape.view.nonvis.IMessageStream;

public class ConsoleOutView
extends DataView {
    private static final long serialVersionUID = 1L;
    private boolean printResultsEachPeriod;
    private int longestNameLength;
    private int longestNumLength;
    private long startTime;
    public static String EOL = System.getProperty("line.separator");
    private IMessageStream msg;

    public ConsoleOutView() {
        this.setSystemStream();
    }

    public String settingsDescription() {
        StringBuffer desc = new StringBuffer();
        List accessors = this.scape.retrieveModelAccessorsOrdered();
        this.longestNameLength = 0;
        this.longestNumLength = 0;
        for (PropertyAccessor accessor : accessors) {
            int nameLength = accessor.getLongName().length();
            if (nameLength > this.longestNameLength) {
                this.longestNameLength = nameLength;
            }
            if (accessor.getValue() instanceof Number) {
                int numLength;
                if (!(((Number)accessor.getValue()).doubleValue() < 1.0E8) || (numLength = Utility.formatToString(((Number)accessor.getValue()).doubleValue(), 4).length()) <= this.longestNumLength) continue;
                this.longestNumLength = numLength;
                continue;
            }
            if (accessor.getValue() instanceof Boolean) {
                if (4 <= this.longestNumLength) continue;
                this.longestNumLength = 4;
                continue;
            }
            if (accessor.getValue() == null) {
                this.longestNumLength = 10;
                continue;
            }
            int stringLength = ((String)accessor.getValue()).length();
            if (stringLength > 25) {
                stringLength = 25;
            }
            if (stringLength <= this.longestNumLength) continue;
            this.longestNumLength = stringLength;
        }
        if (this.longestNumLength > 32) {
            this.longestNumLength = 32;
        }
        desc.append("_Settings_" + EOL);
        for (PropertyAccessor accessor : accessors) {
            if (accessor.getValue() instanceof Number && ((Number)accessor.getValue()).doubleValue() > 1.0E8) {
                if (((Number)accessor.getValue()).intValue() != Integer.MAX_VALUE) {
                    desc.append(String.valueOf(accessor.getLongName()) + ": " + Utility.padStringLeft(accessor.getValue().toString(), this.longestNumLength + this.longestNameLength + 1 - accessor.getLongName().length()) + EOL);
                    continue;
                }
                desc.append(String.valueOf(accessor.getLongName()) + ": " + Utility.padStringLeft("inf/max", this.longestNumLength + this.longestNameLength + 1 - accessor.getLongName().length()) + EOL);
                continue;
            }
            if (accessor.getValue() instanceof Number) {
                desc.append(String.valueOf(Utility.padStringRight(String.valueOf(accessor.getLongName()) + ":", this.longestNameLength + 3)) + Utility.padStringLeft(Utility.formatToString(((Number)accessor.getValue()).doubleValue(), 4), this.longestNumLength) + EOL);
                continue;
            }
            if (accessor.getValue() instanceof Boolean) {
                if (!((Boolean)accessor.getValue()).booleanValue()) {
                    desc.append(String.valueOf(Utility.padStringRight(String.valueOf(accessor.getLongName()) + ":", this.longestNameLength + 3)) + Utility.padStringLeft("false", this.longestNumLength) + EOL);
                    continue;
                }
                desc.append(String.valueOf(Utility.padStringRight(String.valueOf(accessor.getLongName()) + ":", this.longestNameLength + 3)) + Utility.padStringLeft("true", this.longestNumLength) + EOL);
                continue;
            }
            desc.append(String.valueOf(Utility.padStringRight(String.valueOf(accessor.getLongName()) + ":", this.longestNameLength + 3)) + (String)accessor.getValue() + EOL);
        }
        return desc.toString();
    }

    public String resultsDescription() {
        StringBuffer desc = new StringBuffer();
        String[] resultsNames = new String[this.dataSelection.getSelectionSize()];
        String[] resultsNums = new String[this.dataSelection.getSelectionSize()];
        int i = 0;
        while (i < this.dataSelection.getSelectionSize()) {
            resultsNames[i] = this.dataSelection.getSelectedSeries(i).getName();
            if (resultsNames[i].length() > this.longestNameLength) {
                this.longestNameLength = resultsNames[i].length();
            }
            resultsNums[i] = Utility.formatToString(this.dataSelection.getSelectedSeries(i).getValue(), 4);
            if (resultsNums[i].length() > this.longestNumLength) {
                this.longestNumLength = resultsNums[i].length();
            }
            ++i;
        }
        i = 0;
        while (i < this.dataSelection.getSelectionSize()) {
            desc.append(String.valueOf(Utility.padStringRight(String.valueOf(resultsNames[i]) + ":", this.longestNameLength + 3)) + Utility.padStringLeft(resultsNums[i], this.longestNumLength) + EOL);
            ++i;
        }
        return desc.toString();
    }

    public boolean isPrintResultsEachPeriod() {
        return this.printResultsEachPeriod;
    }

    public void setPrintResultsEachPeriod(boolean printResultsEachPeriod) {
        this.printResultsEachPeriod = printResultsEachPeriod;
    }

    @Override
    public void scapeStarted(ScapeEvent scapeEvent) {
        this.startTime = System.currentTimeMillis();
        this.println();
        this.print(this.settingsDescription());
    }

    public void print(String string) {
        this.msg.print(string);
    }

    public void println() {
        this.msg.println();
    }

    public void println(String string) {
        this.msg.println(string);
    }

    @Override
    public void scapeIterated(ScapeEvent scapeEvent) {
        if (this.printResultsEachPeriod) {
            if (this.dataSelection.getSelectionSize() > 0) {
                this.println("_Results for " + this.scape.getPeriod() + "_");
            }
            this.println(this.resultsDescription());
        }
    }

    @Override
    public void scapeStopped(ScapeEvent scapeEvent) {
        this.println(this.stopDescription());
    }

    public String stopDescription() {
        StringBuffer desc = new StringBuffer();
        desc.append("Stop Period: " + this.scape.getPeriod() + EOL);
        desc.append("Finished in: " + Utility.formatElapsedMillis(System.currentTimeMillis() - this.startTime) + EOL);
        if (this.dataSelection.getSelectionSize() > 0) {
            desc.append("_Final Results_" + EOL);
        }
        desc.append(this.resultsDescription());
        return desc.toString();
    }

    public void setSystemStream() {
        this.msg = new IMessageStream(){

            @Override
            public void print(String message) {
                System.out.print(message);
            }

            @Override
            public void println() {
                System.out.println();
            }

            @Override
            public void println(String message) {
                System.out.println(message);
            }
        };
    }

    public void setIMessageStream(IMessageStream consoleStream) {
        this.msg = consoleStream;
    }
}

