/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry.intersection;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVLTree<T>
implements Iterable<T> {
    private Comparator<? super T> m_comparator;
    private AVLNode m_first;
    private AVLNode m_last;
    private Map<T, AVLNode> m_nodeMap = new HashMap<T, AVLNode>();
    private AVLNode m_root;

    public AVLTree() {
    }

    public AVLTree(Comparator<? super T> i_comparator) {
        if (i_comparator == null) {
            throw new NullPointerException("i_comparator must not be null");
        }
        this.m_comparator = i_comparator;
    }

    public void clear() {
        this.m_first = null;
        this.m_last = null;
        this.m_root = null;
        this.m_nodeMap.clear();
    }

    private int compare(T i_o1, T i_o2) {
        if (this.m_comparator != null) {
            return this.m_comparator.compare(i_o1, i_o2);
        }
        Comparable comparable = (Comparable)i_o1;
        return comparable.compareTo(i_o2);
    }

    public boolean contains(T i_data) {
        return this.m_nodeMap.containsKey(i_data);
    }

    public T get(T i_data) {
        if (i_data == null) {
            throw new NullPointerException("i_data must not be null");
        }
        return this.m_nodeMap.get(i_data).getData();
    }

    public T getFirst() {
        if (this.m_first == null) {
            return null;
        }
        return this.m_first.getData();
    }

    public T getLast() {
        if (this.m_last == null) {
            return null;
        }
        return this.m_last.getData();
    }

    public T getNext(T i_data) {
        AVLNode nextNode;
        AVLNode node = this.m_nodeMap.get(i_data);
        if (node != null && (nextNode = node.getNext()) != null) {
            return nextNode.getData();
        }
        return null;
    }

    public T getPrevious(T i_data) {
        AVLNode previousNode;
        AVLNode node = this.m_nodeMap.get(i_data);
        if (node != null && (previousNode = node.getPrevious()) != null) {
            return previousNode.getData();
        }
        return null;
    }

    public boolean insert(T i_data) {
        if (i_data == null) {
            throw new NullPointerException("i_data must not be null");
        }
        if (this.m_root != null) {
            return this.m_root.insert(i_data);
        }
        this.m_first = this.m_root = new AVLNode(null, i_data);
        this.m_last = this.m_root;
        return true;
    }

    public boolean isEmpty() {
        return this.m_root == null;
    }

    @Override
    public Iterator<T> iterator() {
        return new AVLTreeIterator(this.m_first);
    }

    public T query(Object i_query, Comparator<Object> i_comparator) {
        if (i_query == null) {
            throw new NullPointerException("i_query must not be null");
        }
        if (i_comparator == null) {
            throw new NullPointerException("i_comparator must not be null");
        }
        AVLNode node = this.m_root.query(i_query, i_comparator);
        if (node != null) {
            return node.getData();
        }
        return null;
    }

    public T queryNext(Object i_query, Comparator<Object> i_comparator) {
        if (i_query == null) {
            throw new NullPointerException("i_query must not be null");
        }
        if (i_comparator == null) {
            throw new NullPointerException("i_comparator must not be null");
        }
        AVLNode node = this.m_root.queryNext(i_query, i_comparator);
        if (node != null) {
            return node.getData();
        }
        return null;
    }

    public T queryPrevious(Object i_query, Comparator<Object> i_comparator) {
        if (i_query == null) {
            throw new NullPointerException("i_query must not be null");
        }
        if (i_comparator == null) {
            throw new NullPointerException("i_comparator must not be null");
        }
        AVLNode node = this.m_root.queryPrevious(i_query, i_comparator);
        if (node != null) {
            return node.getData();
        }
        return null;
    }

    public boolean remove(T i_data) {
        if (i_data == null) {
            throw new NullPointerException("i_data must not be null");
        }
        if (this.m_root != null) {
            return this.m_root.remove(i_data);
        }
        return false;
    }

    public int size() {
        return this.m_nodeMap.size();
    }

    public T[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (T data : this) {
            array[i++] = data;
        }
        return array;
    }

    public String toString() {
        if (this.m_root == null) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        this.toString(this.m_root, b);
        return b.toString();
    }

    private void toString(AVLNode i_node, StringBuilder i_builder) {
        i_builder.append("[");
        if (i_node.left != null) {
            this.toString(i_node.left, i_builder);
        } else if (i_node.right != null) {
            i_builder.append("[]");
        }
        i_builder.append(i_node.getData());
        if (i_node.right != null) {
            this.toString(i_node.right, i_builder);
        } else if (i_node.left != null) {
            i_builder.append("[]");
        }
        i_builder.append("]");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AVLNode {
        private T data;
        private int height;
        private AVLNode left;
        private AVLNode next;
        private AVLNode parent;
        private AVLNode previous;
        private AVLNode right;

        public AVLNode(AVLNode i_parent, T i_data) {
            this.parent = i_parent;
            this.data = i_data;
            this.height = 0;
            AVLTree.this.m_nodeMap.put(i_data, this);
        }

        private int getBalance() {
            int l = this.left != null ? this.left.height : -1;
            int r = this.right != null ? this.right.height : -1;
            return r - l;
        }

        public T getData() {
            return this.data;
        }

        public AVLNode getNext() {
            return this.next;
        }

        public AVLNode getPrevious() {
            return this.previous;
        }

        public boolean insert(T i_data) {
            int c = AVLTree.this.compare(i_data, this.data);
            if (c < 0) {
                if (this.left == null) {
                    this.left = new AVLNode(this, i_data);
                    this.height = 1;
                    if (this.previous != null) {
                        this.previous.next = this.left;
                        this.left.previous = this.previous;
                    } else {
                        AVLTree.this.m_first = this.left;
                    }
                    this.previous = this.left;
                    this.left.next = this;
                    return true;
                }
                boolean success = this.left.insert(i_data);
                if (success) {
                    this.updateHeight();
                    this.rebalanceAfterInsert();
                }
                return success;
            }
            if (c > 0) {
                if (this.right == null) {
                    this.right = new AVLNode(this, i_data);
                    this.height = 1;
                    if (this.next != null) {
                        this.next.previous = this.right;
                        this.right.next = this.next;
                    } else {
                        AVLTree.this.m_last = this.right;
                    }
                    this.next = this.right;
                    this.right.previous = this;
                    return true;
                }
                boolean success = this.right.insert(i_data);
                if (success) {
                    this.updateHeight();
                    this.rebalanceAfterInsert();
                }
                return success;
            }
            return false;
        }

        public boolean isLeft() {
            if (this.parent == null) {
                return false;
            }
            return this.parent.left == this;
        }

        public boolean isRight() {
            if (this.parent == null) {
                return false;
            }
            return this.parent.right == this;
        }

        public AVLNode query(Object i_query, Comparator<Object> i_comparator) {
            int c = i_comparator.compare(i_query, this.data);
            if (c < 0 && this.left != null) {
                return this.left.query(i_query, i_comparator);
            }
            if (c > 0 && this.right != null) {
                return this.right.query(i_query, i_comparator);
            }
            if (c == 0) {
                return this;
            }
            return null;
        }

        public AVLNode queryNext(Object i_query, Comparator<Object> i_comparator) {
            if (i_comparator.compare(i_query, this.data) < 0) {
                AVLNode result = null;
                if (this.left != null) {
                    result = this.left.queryNext(i_query, i_comparator);
                }
                if (result != null) {
                    return result;
                }
                return this;
            }
            if (this.right != null) {
                return this.right.queryNext(i_query, i_comparator);
            }
            return null;
        }

        public AVLNode queryPrevious(Object i_query, Comparator<Object> i_comparator) {
            if (i_comparator.compare(i_query, this.data) > 0) {
                AVLNode result = null;
                if (this.right != null) {
                    result = this.right.queryPrevious(i_query, i_comparator);
                }
                if (result != null) {
                    return result;
                }
                return this;
            }
            if (this.left != null) {
                return this.left.queryPrevious(i_query, i_comparator);
            }
            return null;
        }

        private void rebalanceAfterInsert() {
            int b = this.getBalance();
            if (b < -1) {
                if (this.left.getBalance() < 0) {
                    this.rotateCW();
                } else {
                    this.left.rotateCCW();
                    this.rotateCW();
                }
            } else if (b > 1) {
                if (this.right.getBalance() > 0) {
                    this.rotateCCW();
                } else {
                    this.right.rotateCW();
                    this.rotateCCW();
                }
            }
        }

        private void rebalanceAfterRemove() {
            int b = this.getBalance();
            if (b < -1) {
                if (this.left.getBalance() <= 0) {
                    this.rotateCW();
                } else {
                    this.left.rotateCCW();
                    this.rotateCW();
                }
            } else if (b > 1) {
                if (this.right.getBalance() >= 0) {
                    this.rotateCCW();
                } else {
                    this.right.rotateCW();
                    this.rotateCCW();
                }
            }
        }

        public boolean remove(T i_data) {
            int c = AVLTree.this.compare(i_data, this.data);
            if (c < 0) {
                if (this.left == null) {
                    return false;
                }
                boolean success = this.left.remove(i_data);
                if (success) {
                    this.updateHeight();
                    this.rebalanceAfterRemove();
                }
                return success;
            }
            if (c > 0) {
                if (this.right == null) {
                    return false;
                }
                boolean success = this.right.remove(i_data);
                if (success) {
                    this.updateHeight();
                    this.rebalanceAfterRemove();
                }
                return success;
            }
            AVLTree.this.m_nodeMap.remove(i_data);
            if (this.left == null || this.right == null) {
                AVLNode child = null;
                if (this.left != null) {
                    child = this.left;
                } else if (this.right != null) {
                    child = this.right;
                }
                if (this.isLeft()) {
                    this.parent.left = child;
                } else if (this.isRight()) {
                    this.parent.right = child;
                } else {
                    AVLTree.this.m_root = child;
                }
                if (child != null) {
                    child.parent = this.parent;
                }
                if (this.previous != null) {
                    this.previous.next = this.next;
                } else {
                    AVLTree.this.m_first = this.next;
                }
                if (this.next != null) {
                    this.next.previous = this.previous;
                } else {
                    AVLTree.this.m_last = this.previous;
                }
            } else {
                AVLNode node = this.getNext();
                this.next = node.next;
                if (this.next != null) {
                    this.next.previous = this;
                } else {
                    AVLTree.this.m_last = this;
                }
                if (node.isLeft()) {
                    node.parent.left = node.right;
                } else {
                    node.parent.right = node.right;
                }
                if (node.right != null) {
                    node.right.parent = node.parent;
                }
                this.data = node.data;
                AVLTree.this.m_nodeMap.put(this.data, this);
                do {
                    node = node.parent;
                    node.updateHeight();
                    node.rebalanceAfterRemove();
                } while (node != this);
            }
            return true;
        }

        private void rotateCCW() {
            AVLNode tmpRight = this.right;
            AVLNode tmpParent = this.parent;
            this.right = tmpRight.left;
            if (this.right != null) {
                this.right.parent = this;
            }
            tmpRight.left = this;
            this.parent = tmpRight;
            if (tmpParent == null) {
                AVLTree.this.m_root = tmpRight;
                tmpRight.parent = null;
            } else if (tmpParent.left == this) {
                tmpParent.left = tmpRight;
                tmpRight.parent = tmpParent;
            } else {
                tmpParent.right = tmpRight;
                tmpRight.parent = tmpParent;
            }
            this.updateHeight();
            tmpRight.updateHeight();
            if (tmpParent != null) {
                tmpParent.updateHeight();
            }
        }

        private void rotateCW() {
            AVLNode tmpLeft = this.left;
            AVLNode tmpParent = this.parent;
            this.left = tmpLeft.right;
            if (this.left != null) {
                this.left.parent = this;
            }
            tmpLeft.right = this;
            this.parent = tmpLeft;
            if (tmpParent == null) {
                AVLTree.this.m_root = tmpLeft;
            } else if (tmpParent.left == this) {
                tmpParent.left = tmpLeft;
                tmpLeft.parent = tmpParent;
            } else {
                tmpParent.right = tmpLeft;
                tmpLeft.parent = tmpParent;
            }
            this.updateHeight();
            tmpLeft.updateHeight();
            if (tmpParent != null) {
                tmpParent.updateHeight();
            }
        }

        public String toString() {
            return String.valueOf(this.data.toString()) + ":" + this.height;
        }

        private void updateHeight() {
            int l = this.left != null ? this.left.height : -1;
            int r = this.right != null ? this.right.height : -1;
            this.height = Math.max(l, r) + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AVLTreeIterator
    implements Iterator<T> {
        private AVLNode m_node;

        public AVLTreeIterator(AVLNode i_startNode) {
            this.m_node = i_startNode;
        }

        @Override
        public boolean hasNext() {
            return this.m_node != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AVLNode tmp = this.m_node;
            this.m_node = this.m_node.getNext();
            return tmp.getData();
        }

        @Override
        public void remove() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AVLNode tmp = this.m_node;
            this.m_node = this.m_node.getNext();
            AVLTree.this.remove(tmp.getData());
        }
    }
}

