/**
 * <copyright>
 *
 * Copyright (c) 2007-2009 Metascape, LLC
 * Copyright (c) 2006-2007 Argonne National Labs
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Argonne National Laboratory - Initial development (pre-contribution)
 *   Metascape - Subsequent development and maintenance
 *
 * </copyright>
 */
package org.metaabm.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.metaabm.MetaABMPackage;
import org.metaabm.act.provider.MetaABMActItemProviderAdapterFactory;
import org.metaabm.function.provider.MetaABMFunctionItemProviderAdapterFactory;
import org.metaabm.util.MetaABMAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The adapters generated by this
 * factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The adapters
 * also support Eclipse property sheets. Note that most of the adapters are shared among multiple instances. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class MetaABMItemProviderAdapterFactory extends MetaABMAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the item providers created, so that they can be {@link #dispose disposed}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Disposable disposable = new Disposable();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(MetaABMEditPlugin.INSTANCE, MetaABMPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public MetaABMItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(ITableItemLabelProvider.class);
		supportedTypes.add(ITableItemColorProvider.class);
		supportedTypes.add(IItemColorProvider.class);
	}

	/**
	 * This creates an adapter for a {@link org.metaabm.SContext}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSContextAdapter() {
		return new SContextItemProvider(this);
	}

	/**
	 * This creates an adapter for a {@link org.metaabm.SAgent}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSAgentAdapter() {
		return new SAgentItemProvider(this);
	}

	/**
	 * This creates an adapter for a {@link org.metaabm.SAttribute}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSAttributeAdapter() {
		return new SAttributeItemProvider(this);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SAttributeArray} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected SAttributeArrayItemProvider sAttributeArrayItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SValueLayer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SValueLayerItemProvider sValueLayerItemProvider;

	/**
	 * This creates an adapter for a {@link org.metaabm.SValueLayer}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSValueLayerAdapter() {
		if (sValueLayerItemProvider == null) {
			sValueLayerItemProvider = new SValueLayerItemProvider(this);
		}

		return sValueLayerItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.metaabm.SStyle3D}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSStyle3DAdapter() {
		return new SStyle3DItemProvider(this);
	}

	/**
	 * This creates an adapter for a {@link org.metaabm.SStyle2D}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSStyle2DAdapter() {
		return new SStyle2DItemProvider(this);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SStyleShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SStyleShapeItemProvider sStyleShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.metaabm.SStyleShape}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSStyleShapeAdapter() {
		if (sStyleShapeItemProvider == null) {
			sStyleShapeItemProvider = new SStyleShapeItemProvider(this);
		}

		return sStyleShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SImplementation} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected SImplementationItemProvider sImplementationItemProvider;

	/**
	 * This creates an adapter for a {@link org.metaabm.SImplementation}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSImplementationAdapter() {
		if (sImplementationItemProvider == null) {
			sImplementationItemProvider = new SImplementationItemProvider(this);
		}

		return sImplementationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SState} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected SStateItemProvider sStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.metaabm.SState}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSStateAdapter() {
		if (sStateItemProvider == null) {
			sStateItemProvider = new SStateItemProvider(this);
		}

		return sStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SStateValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SStateValueItemProvider sStateValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.metaabm.SStateValue}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSStateValueAdapter() {
		if (sStateValueItemProvider == null) {
			sStateValueItemProvider = new SStateValueItemProvider(this);
		}

		return sStateValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SNetwork} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SNetworkItemProvider sNetworkItemProvider;

	/**
	 * This creates an adapter for a {@link org.metaabm.SNetwork}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSNetworkAdapter() {
		if (sNetworkItemProvider == null) {
			sNetworkItemProvider = new SNetworkItemProvider(this);
		}

		return sNetworkItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.metaabm.SAttributeArray}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSAttributeArrayAdapter() {
		if (sAttributeArrayItemProvider == null) {
			sAttributeArrayItemProvider = new SAttributeArrayItemProvider(this);
		}

		return sAttributeArrayItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SGrid} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected SGridItemProvider sGridItemProvider;

	/**
	 * This creates an adapter for a {@link org.metaabm.SGrid}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSGridAdapter() {
		if (sGridItemProvider == null) {
			sGridItemProvider = new SGridItemProvider(this);
		}

		return sGridItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SGeography} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SGeographyItemProvider sGeographyItemProvider;

	/**
	 * This creates an adapter for a {@link org.metaabm.SGeography}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSGeographyAdapter() {
		if (sGeographyItemProvider == null) {
			sGeographyItemProvider = new SGeographyItemProvider(this);
		}

		return sGeographyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.metaabm.SContinuousSpace} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SContinuousSpaceItemProvider sContinuousSpaceItemProvider;

	/**
	 * This creates an adapter for a {@link org.metaabm.SContinuousSpace}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSContinuousSpaceAdapter() {
		if (sContinuousSpaceItemProvider == null) {
			sContinuousSpaceItemProvider = new SContinuousSpaceItemProvider(this);
		}

		return sContinuousSpaceItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * Associates an adapter with a notifier via the base implementation, then records it to ensure it will be disposed.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void associate(Adapter adapter, Notifier target) {
		super.associate(adapter, target);
		if (adapter != null) {
			disposable.add(adapter);
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		disposable.dispose();
	}

	private static AdapterFactory genericFactory;

	public static AdapterFactory getGenericAdapterFactory() {
		if (genericFactory == null) {
			List<AdapterFactory> factories = new ArrayList<AdapterFactory>();
			factories.add(new ResourceItemProviderAdapterFactory());
			factories.add(new MetaABMItemProviderAdapterFactory());
			factories.add(new MetaABMActItemProviderAdapterFactory());
			factories.add(new MetaABMFunctionItemProviderAdapterFactory());
			// factories.add(new ReflectiveItemProviderAdapterFactory());
			genericFactory = new ComposedAdapterFactory(factories);
		}
		return genericFactory;
	}
}
