/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model;

import java.awt.Color;
import java.awt.Image;
import org.ascape.model.AscapeObject;
import org.ascape.model.LocatedAgent;
import org.ascape.model.Scape;
import org.ascape.model.rule.ExecuteThenUpdate;
import org.ascape.model.rule.Propogate;
import org.ascape.model.rule.Rule;
import org.ascape.model.space.Mutable;

public class Agent
extends AscapeObject
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public static final Rule INITIALIZE_RULE = new Propogate("Initialize"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.initialize();
            super.execute(agent);
        }

        @Override
        public boolean isIterateAll() {
            return true;
        }
    };
    public static final Rule UPDATE_RULE = new Rule("Update"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.update();
        }

        @Override
        public boolean isRandomExecution() {
            return false;
        }

        @Override
        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule ITERATE_AND_UPDATE_RULE = new ExecuteThenUpdate("Iterate and Update"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.iterate();
        }

        @Override
        public void update(Agent agent) {
            agent.update();
        }
    };
    public static final Rule DEATH_RULE = new Rule("Death"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.death();
        }

        @Override
        public boolean isRandomExecution() {
            return false;
        }

        @Override
        public boolean isCauseRemoval() {
            return true;
        }
    };
    public static final Rule FORCE_DIE_RULE = new Rule("Force Death"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.die();
        }

        @Override
        public boolean isRandomExecution() {
            return false;
        }

        @Override
        public boolean isCauseRemoval() {
            return true;
        }
    };
    public static final Rule FISSIONING_RULE = new Rule("Fissioning"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.fissioning();
        }

        @Override
        public boolean isRandomExecution() {
            return true;
        }

        @Override
        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule FORCE_FISSION_RULE = new Rule("Force Fission"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.fission();
        }

        @Override
        public boolean isRandomExecution() {
            return true;
        }

        @Override
        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule METABOLISM_RULE = new Rule("Metabolism"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.metabolism();
        }

        @Override
        public boolean isRandomExecution() {
            return false;
        }

        @Override
        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule MOVEMENT_RULE = new Rule("Movement"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.movement();
        }

        @Override
        public boolean isRandomExecution() {
            return true;
        }

        @Override
        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule FORCE_MOVE_RULE = new Rule("Force Move"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.move();
        }

        @Override
        public boolean isRandomExecution() {
            return true;
        }

        @Override
        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule PLAY_OTHER = new Rule("Play Other"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            LocatedAgent other = agent.getScape().findRandom();
            while (agent == other) {
                if (agent.getScape().getSize() == 1) {
                    return;
                }
                other = agent.getScape().findRandom();
            }
            agent.play(other);
        }

        @Override
        public boolean isRandomExecution() {
            return true;
        }

        @Override
        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule ITERATE_RULE = new Rule("Iterate"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            agent.iterate();
        }

        @Override
        public boolean isRandomExecution() {
            return true;
        }

        @Override
        public boolean isCauseRemoval() {
            return true;
        }
    };
    private boolean deleteMarker = false;
    private boolean initialized = false;

    public void scapeCreated() {
    }

    public boolean deathCondition() {
        return false;
    }

    public void death() {
        if (this.deathCondition()) {
            this.die();
        }
    }

    public void die() {
        if (this.scape != null && this.scape.isMutable() && !this.scape.remove(this)) {
            throw new RuntimeException("Agent couldn't be deleted");
        }
    }

    public boolean fissionCondition() {
        return false;
    }

    public void fissioning() {
        if (this.fissionCondition()) {
            this.fission();
        }
    }

    public void fission() {
    }

    public boolean movementCondition() {
        return false;
    }

    public void movement() {
        if (this.movementCondition()) {
            this.move();
        }
    }

    public void move() {
    }

    public void metabolism() {
    }

    public void play(Agent agent) {
    }

    public void iterate() {
    }

    public void update() {
    }

    public void initialize() {
        this.initialized = true;
    }

    public void execute(Rule[] rules) {
        int i = 0;
        while (i < rules.length) {
            rules[i].execute(this);
            ++i;
        }
    }

    public void execute(Rule rule) {
        Rule[] rules = new Rule[]{rule};
        this.execute(rules);
    }

    public Scape getRoot() {
        if (this.getScape() != null) {
            return this.getScape().getRoot();
        }
        try {
            return (Scape)this;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Tried to get root of a non-member agent");
        }
    }

    public int getIteration() {
        return this.scape.getIteration();
    }

    public Object getPlatformColor() {
        return PLATFORM_DEFAULT_COLOR;
    }

    public Color getColor() {
        return Color.black;
    }

    public Color getColor(Object object) {
        return ((Agent)object).getColor();
    }

    public Image getImage() {
        return null;
    }

    public Image getImage(Object object) {
        return ((Agent)object).getImage();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setScape(Scape scape) {
        if (this.isDelete() && scape != null && this.scape != null && this.scape != scape) {
            try {
                ((Mutable)((Object)this.getScape().getSpace())).deleteSweep();
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Internal Ascape Exception in Agent.setScape().");
            }
        }
        this.clearDeleteMarker();
        super.setScape(scape);
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isDelete() {
        return this.deleteMarker;
    }

    public void markForDeletion() {
        this.deleteMarker = true;
    }

    public void clearDeleteMarker() {
        this.deleteMarker = false;
    }

    @Override
    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return "Agent";
    }

    @Override
    public Object clone() {
        Agent clone = (Agent)super.clone();
        return clone;
    }
}

