/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.gef;

import org.eclipse.amp.agf.IGraphicsAdapter;
import org.eclipse.amp.agf.tree.AgentTreePart;
import org.eclipse.amp.agf.tree.ScapeTreePart;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.space.IGraphProvider;
import org.eclipse.amp.axf.space.ILocationProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

public class ScapePartTreeFactory
implements EditPartFactory {
    IModel model;
    ILocationProvider locationProvider;
    ICompositionProvider compositionProvider;
    IGraphProvider graphProvider;
    IGraphicsAdapter graphicsAdapter;

    public ScapePartTreeFactory(IModel model, IGraphicsAdapter graphicsAdapter) {
        this.model = model;
        this.graphicsAdapter = graphicsAdapter;
        this.compositionProvider = (ICompositionProvider)Platform.getAdapterManager().getAdapter((Object)model, ICompositionProvider.class);
        this.locationProvider = (ILocationProvider)Platform.getAdapterManager().getAdapter((Object)model, ILocationProvider.class);
        this.graphProvider = (IGraphProvider)Platform.getAdapterManager().getAdapter((Object)model, IGraphProvider.class);
        Assert.isNotNull((Object)this.compositionProvider);
        Assert.isNotNull((Object)graphicsAdapter);
    }

    public EditPart createEditPart(EditPart context, Object model) {
        EditPart part = this.getPartForElement(model);
        part.setModel(model);
        return part;
    }

    protected EditPart getPartForElement(Object model) {
        if (this.compositionProvider.isComposition(model)) {
            return new ScapeTreePart(this.compositionProvider, this.locationProvider, this.graphProvider, this.graphicsAdapter);
        }
        return new AgentTreePart(this.graphicsAdapter);
    }
}

