/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.act.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.metaabm.IID;
import org.metaabm.IValue;
import org.metaabm.MetaABMPackage;
import org.metaabm.act.AInput;
import org.metaabm.act.ASelect;
import org.metaabm.act.ASink;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.act.MetaABMActPackage;
import org.metaabm.act.provider.AActItemProvider;
import org.metaabm.commands.SetSinkFunctionCommand;
import org.metaabm.commands.SetSinkLabelCommand;
import org.metaabm.commands.SuggestLabelCommand;
import org.metaabm.function.FFunction;
import org.metaabm.function.FGeneric;
import org.metaabm.function.FGenericLogical;
import org.metaabm.function.FLibrary;
import org.metaabm.function.FOperator;

public class ASinkItemProvider
extends AActItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
ITableItemLabelProvider,
ITableItemColorProvider,
IItemColorProvider {
    static Map<FFunction, Object> sinkImages = new HashMap<FFunction, Object>();

    public ASinkItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addAvailableTypesPropertyDescriptor(object);
            this.addInputsPropertyDescriptor(object);
            this.addFunctionPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(MetaABMActPackage.Literals.ASINK__INPUTS);
            this.childrenFeatures.add(MetaABMActPackage.Literals.AACT__TARGETS);
        }
        return this.childrenFeatures;
    }

    @Override
    public Collection<?> getChildren(Object object) {
        return ((ASink)object).getInputs();
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    protected void addAvailableTypesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IValue_availableTypes_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IValue_availableTypes_feature", "_UI_IValue_type"), (EStructuralFeature)MetaABMPackage.Literals.IVALUE__AVAILABLE_TYPES, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addInputsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ASink_inputs_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ASink_inputs_feature", "_UI_ASink_type"), (EStructuralFeature)MetaABMActPackage.Literals.ASINK__INPUTS, true, true, false, null, this.getString("_UI_RelationsPropertyCategory"), new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addFunctionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ASink_function_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ASink_function_feature", "_UI_ASink_type"), (EStructuralFeature)MetaABMActPackage.Literals.ASINK__FUNCTION, true, false, true, null, this.getString("_UI_ActPropertyCategory"), null));
    }

    @Override
    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        if (feature == MetaABMActPackage.Literals.ASINK__INPUTS) {
            CompoundCommand cmd = new CompoundCommand("Add Sink Inputs");
            SuggestLabelCommand suggestLabelCommand = new SuggestLabelCommand(this, domain, (IID)owner);
            cmd.append(super.createAddCommand(domain, owner, feature, collection, index));
            for (AInput input : collection) {
                ASelect selected = ((ASink)owner).getSelected();
                if (selected == null) continue;
                cmd.appendIfCanExecute(SetCommand.create((EditingDomain)domain, (Object)input, (Object)MetaABMActPackage.Literals.AINPUT__SELECTED, (Object)selected));
            }
            cmd.appendIfCanExecute((Command)suggestLabelCommand);
            return cmd;
        }
        return super.createAddCommand(domain, owner, feature, collection, index);
    }

    @Override
    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        if (feature == MetaABMActPackage.Literals.ASINK__INPUTS) {
            CompoundCommand cmd = new CompoundCommand();
            for (AInput input : collection) {
                cmd.append(SetCommand.create((EditingDomain)domain, (Object)input, (Object)MetaABMActPackage.Literals.AINPUT__VALUE, null));
            }
            cmd.append(super.createRemoveCommand(domain, owner, feature, collection));
            return cmd;
        }
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    @Override
    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        ASink sink = (ASink)owner;
        if (feature == MetaABMActPackage.Literals.ASINK__FUNCTION && value == null || value instanceof FFunction) {
            FFunction function = (FFunction)value;
            CompoundCommand cmd = new CompoundCommand("Set Sink Function");
            cmd.append(super.createSetCommand(domain, owner, feature, value, index));
            cmd.appendIfCanExecute((Command)new SetSinkFunctionCommand(domain, sink, function));
            if (value != null && !((FFunction)value).isMultiValue()) {
                cmd.appendIfCanExecute((Command)new SuggestLabelCommand(domain, (IID)owner));
            }
            return cmd;
        }
        if (feature == MetaABMPackage.Literals.IID__LABEL) {
            CompoundCommand cmd = new CompoundCommand("Sink Label Command");
            cmd.append(super.createSetCommand(domain, owner, feature, value, index));
            cmd.appendIfCanExecute((Command)new SetSinkLabelCommand(domain, sink, (String)value));
            return cmd;
        }
        return super.createSetCommand(domain, owner, feature, value, index);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ASink.class)) {
            case 6: 
            case 13: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
            case 12: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public static String getImageNameForFunction(FFunction function) {
        if (function != null) {
            if (function instanceof FOperator) {
                return StringUtils.capitalize((String)function.getID());
            }
            if (function.eContainer() instanceof FLibrary && ((FLibrary)function.eContainer()).getID().equals("spatial")) {
                return "Spatial";
            }
            if (function.eContainer() instanceof FLibrary && ((FLibrary)function.eContainer()).getID().equals("random")) {
                return "Random";
            }
            if (function instanceof FGenericLogical) {
                return "GenericLogical";
            }
        }
        return "GenericFunction";
    }

    public Map<FFunction, Object> getImageCache() {
        return sinkImages;
    }

    @Override
    public Object getImage(Object object) {
        Object img = this.getImageCache().get(((ASink)object).getFunction());
        if (img == null) {
            img = ASinkItemProvider.getImageForFunction(this.getResourceLocator(), object, this.getQualifier());
            img = this.overlayImage(object, img);
            this.getImageCache().put(((ASink)object).getFunction(), img);
        }
        return img;
    }

    public static Object getImageForFunction(ResourceLocator locator, Object object, String qualifier) {
        Object img = null;
        String path = "full/obj16/";
        ASink sink = (ASink)object;
        FFunction baseFunction = sink.getFunction();
        if (baseFunction != null) {
            String imageNameForFunction = ASinkItemProvider.getImageNameForFunction(baseFunction);
            String imagePath = String.valueOf(path) + qualifier + imageNameForFunction;
            try {
                return locator.getImage(imagePath);
            }
            catch (MissingResourceException e) {
                System.err.println("Couldn't find image at: " + imagePath);
            }
        }
        try {
            return locator.getImage(String.valueOf(path) + "AEvaluate");
        }
        catch (MissingResourceException e2) {
            System.err.println("Couldn't find image at: " + path);
            throw new RuntimeException("Couldn't find image at: " + path);
        }
    }

    public String getQualifier() {
        return "A";
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(MetaABMActPackage.Literals.ASINK__INPUTS, MetaABMActFactory.eINSTANCE.createAInput()));
    }

    private String getInputLabel(ASink sink, int index) {
        IValue value;
        EList inputs = sink.getInputs();
        if (inputs.size() > index && (value = ((AInput)inputs.get(index)).getValue()) != null) {
            return value.getLabel();
        }
        return "[?]";
    }

    public static List<String> getInputLabels(ASink sink) {
        ArrayList<String> inputs = new ArrayList<String>();
        for (AInput in : sink.getInputs()) {
            if (in.getValue() == null) continue;
            inputs.add(in.getValue().getLabel());
        }
        return inputs;
    }

    @Override
    public String getText(Object object) {
        return super.getText(object);
    }

    @Override
    public String suggestLabel(IID object) {
        ASink sink = (ASink)object;
        StringBuffer expression = new StringBuffer();
        this.appendFunctionLabel(sink, expression);
        return expression.toString();
    }

    private void appendFunctionLabel(ASink sink, StringBuffer expression) {
        FFunction baseFunction = sink.getFunction();
        if (baseFunction == null) {
            expression.append("[Unspecified](" + StringUtils.join(ASinkItemProvider.getInputLabels(sink).iterator(), (String)", ") + ")");
        } else if (baseFunction instanceof FGeneric) {
            expression.append(baseFunction.getLabel());
            expression.append("(");
            expression.append(StringUtils.join(ASinkItemProvider.getInputLabels(sink).iterator(), (String)", "));
            expression.append(")");
        } else if (baseFunction instanceof FOperator) {
            FOperator operator = (FOperator)baseFunction;
            int arity = operator.getArity();
            switch (arity) {
                case 0: {
                    break;
                }
                case 1: {
                    expression.append(operator.getLabel());
                    expression.append(" ");
                    expression.append(this.getInputLabel(sink, 0));
                    break;
                }
                case 2: {
                    expression.append(this.getInputLabel(sink, 0));
                    expression.append(" ");
                    expression.append(operator.getLabel());
                    expression.append(" ");
                    expression.append(this.getInputLabel(sink, 1));
                    break;
                }
                default: {
                    expression.append("[Unsupported Arity:" + arity + "]");
                    break;
                }
            }
        } else {
            expression.append("[Unsupported Function Type");
        }
    }

    @Override
    public boolean hasChildren(Object object) {
        return ((ASink)object).getInputs().size() > 0 || super.hasChildren(object);
    }
}

