/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.amp.escape.ide.LoaderCreationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ProjectLoader
extends URLClassLoader {
    private IProject project;
    private ClassLoader mainLoader;
    private List<Bundle> bundles;

    public ProjectLoader(IProject project) throws LoaderCreationException, MalformedURLException {
        super(new URL[]{new URL(String.valueOf(project.getLocationURI().toString()) + "/res/")});
        this.project = project;
        try {
            project.open(null);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            ArrayList<URL> outputURL = new ArrayList<URL>();
            outputURL.add(new File(project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
            for (URL url : outputURL) {
                this.addURL(url);
            }
            this.bundles = this.readDependencies();
            this.mainLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this);
        }
        catch (Exception e) {
            throw new LoaderCreationException("Problem creating classloaders.", e);
        }
    }

    private List<Bundle> readDependencies() throws BundleException, IOException {
        ManifestElement[] requiredBundles;
        ArrayList<Bundle> dependencies = new ArrayList<Bundle>();
        Map manifest = ManifestElement.parseBundleManifest((InputStream)this.openStream("META-INF/MANIFEST.MF"), null);
        ManifestElement[] manifestElementArray = requiredBundles = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)manifest.get("Require-Bundle")));
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            String optional;
            String version;
            ManifestElement requiredBundle = manifestElementArray[n2];
            String symbolicName = requiredBundle.getValue();
            Bundle[] availableBundles = Platform.getBundles((String)symbolicName, (String)(version = requiredBundle.getAttribute("bundle-version")));
            if (availableBundles != null && availableBundles.length > 0) {
                dependencies.add(availableBundles[0]);
            }
            if ((optional = requiredBundle.getDirective("resolution")) != null && !optional.equals("optional")) {
                String message = "Bundle cannot be found: ";
                message = String.valueOf(message) + symbolicName;
                if (version != null) {
                    message = String.valueOf(message) + " " + version;
                }
                throw new IllegalStateException(message);
            }
            ++n2;
        }
        return dependencies;
    }

    private InputStream openStream(String path) {
        try {
            IFile file = this.project.getFile(path);
            if (file == null) {
                throw new RuntimeException("No resource " + path + " found in " + this.project + ".");
            }
            return file.getContents();
        }
        catch (CoreException e) {
            throw new RuntimeException("Couldn open file " + path + " in " + this.project + ".", e);
        }
    }

    public void restore() {
        Thread.currentThread().setContextClassLoader(this.mainLoader);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            Class<?> loadClass = super.loadClass(name);
            return loadClass;
        }
        catch (NoClassDefFoundError classNotFoundException) {
            Class<?> loadClassI = this.loadClassInternal(name);
            return loadClassI;
        }
        catch (NoSuchMethodError classNotFoundException) {
            Class<?> loadClassI = this.loadClassInternal(name);
            return loadClassI;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> loadClassI = this.loadClassInternal(name);
            return loadClassI;
        }
        catch (UnsupportedClassVersionError classNotFoundException) {
            throw new RuntimeException("Bad class: " + name, classNotFoundException);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception for " + name, e);
        }
    }

    private Class<?> loadClassInternal(String name) throws ClassNotFoundException {
        ClassNotFoundException lastException = null;
        for (Bundle tmp : this.bundles) {
            try {
                return tmp.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return null;
    }
}

