/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.processing.handlers;

import java.io.IOException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.AbstractPackage;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.ConfirmationPackage;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.EventPackage;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.EventPackageWithFrames;
import org.eclipse.emf.mwe.internal.ui.debug.processing.DebugModelManager;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventPluginHandler
implements Runnable {
    private Connection connection;
    private DebugModelManager dmm;
    private final Class<? extends AbstractPackage> typeToListen = EventPackage.class;

    public void setDmm(DebugModelManager dmm) {
        this.dmm = dmm;
    }

    public Class<? extends AbstractPackage> getPackageType() {
        return this.typeToListen;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void startListener() {
        Thread thread = new Thread((Runnable)this, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.dispatch((EventPackage)this.connection.listenForPackage(this.typeToListen));
            }
        }
        catch (Exception e) {
            this.connection.close();
            return;
        }
    }

    private void dispatch(EventPackage packet) throws DebugException {
        this.dmm.getThread().setBreakpoint(null);
        switch (packet.event) {
            case 1: {
                this.dmm.debuggerStarted();
                break;
            }
            case 2: {
                this.adaptStackFrames(packet);
                this.dmm.debuggerSuspended();
                break;
            }
            case 3: {
                this.dmm.debuggerResumed();
                break;
            }
            case 4: {
                this.dmm.debuggerTerminated();
                break;
            }
            default: {
                Activator.logError("Internal error.\nInvalid event received: " + packet.event, null);
                return;
            }
        }
        ConfirmationPackage conf = new ConfirmationPackage(packet.getId());
        try {
            this.connection.sendPackage((AbstractPackage)conf);
        }
        catch (IOException e) {
            throw new DebugException(Activator.createErrorStatus("lost connection to debugger runtime process --> aborting", e));
        }
    }

    private void adaptStackFrames(EventPackage sp) {
        EventPackageWithFrames packet = (EventPackageWithFrames)sp;
        this.dmm.adaptStackFrames(packet.cleanStackLevel, packet.frames);
    }
}

