/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AppletLaunchConfigurationUtils {
    static /* synthetic */ Class class$0;

    public static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public static IType getMainType(String mainTypeName, IJavaProject javaProject) throws CoreException {
        if (mainTypeName == null || mainTypeName.trim().length() < 1) {
            AppletLaunchConfigurationUtils.abort(LauncherMessages.appletlauncher_utils_error_main_type_not_specified, null, 101);
        }
        IType mainType = null;
        try {
            mainType = AppletLaunchConfigurationUtils.findType(javaProject, mainTypeName);
        }
        catch (JavaModelException javaModelException) {}
        if (mainType == null) {
            AppletLaunchConfigurationUtils.abort(MessageFormat.format((String)LauncherMessages.appletlauncher_utils_error_main_type_does_not_exist, (Object[])new String[]{mainTypeName, javaProject.getElementName()}), null, 101);
        }
        return mainType;
    }

    public static IType findType(IJavaProject javaProject, String mainTypeName) throws CoreException {
        IJavaElement javaElement = JavaDebugUtils.findElement((String)mainTypeName, (IJavaProject)javaProject);
        if (javaElement == null) {
            return null;
        }
        if (javaElement instanceof IType) {
            return (IType)javaElement;
        }
        if (javaElement.getElementType() == 5) {
            String simpleName = Signature.getSimpleName((String)mainTypeName);
            return ((ICompilationUnit)javaElement).getType(simpleName);
        }
        if (javaElement.getElementType() == 6) {
            return ((IClassFile)javaElement).getType();
        }
        return null;
    }

    public static Set collectAppletTypesInProject(IProgressMonitor monitor, IJavaProject project) {
        HashSet<IType> result = new HashSet<IType>(5);
        try {
            IType javaLangApplet = AppletLaunchConfigurationUtils.getMainType("java.applet.Applet", project);
            ITypeHierarchy hierarchy = javaLangApplet.newTypeHierarchy(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getAllSubtypes(javaLangApplet);
            int length = types.length;
            if (length != 0) {
                int i = 0;
                while (i < length) {
                    if (!types[i].isBinary()) {
                        result.add(types[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        monitor.done();
        return result;
    }

    public static void collectTypes(Object element, IProgressMonitor monitor, Set result) throws JavaModelException {
        element = AppletLaunchConfigurationUtils.computeScope(element);
        while (element instanceof IMember) {
            if (element instanceof IType && AppletLaunchConfigurationUtils.isSubclassOfApplet(monitor, (IType)element)) {
                result.add(element);
                monitor.done();
                return;
            }
            element = ((IJavaElement)element).getParent();
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            IType[] types = cu.getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (AppletLaunchConfigurationUtils.isSubclassOfApplet(monitor, types[i])) {
                    result.add(types[i]);
                }
                ++i;
            }
        } else if (element instanceof IClassFile) {
            IType type = ((IClassFile)element).getType();
            if (AppletLaunchConfigurationUtils.isSubclassOfApplet(monitor, type)) {
                result.add(type);
            }
        } else if (element instanceof IJavaElement) {
            IJavaElement parent = (IJavaElement)element;
            List found = AppletLaunchConfigurationUtils.searchSubclassesOfApplet(monitor, (IJavaElement)element);
            Iterator iterator = found.iterator();
            block2: while (iterator.hasNext()) {
                IJavaElement target;
                IJavaElement child = target = (IJavaElement)iterator.next();
                while (child != null) {
                    if (child.equals(parent)) {
                        result.add(target);
                        continue block2;
                    }
                    child = child.getParent();
                }
            }
        }
        monitor.done();
    }

    private static List searchSubclassesOfApplet(IProgressMonitor pm, IJavaElement javaElement) {
        return new ArrayList(AppletLaunchConfigurationUtils.collectAppletTypesInProject(pm, javaElement.getJavaProject()));
    }

    private static boolean isSubclassOfApplet(IProgressMonitor pm, IType type) {
        return AppletLaunchConfigurationUtils.collectAppletTypesInProject(pm, type.getJavaProject()).contains(type);
    }

    private static Object computeScope(Object element) {
        if (element instanceof IJavaElement) {
            return element;
        }
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            element = iAdaptable.getAdapter((Class)clazz);
        }
        if (element instanceof IResource) {
            IJavaElement javaElement = JavaCore.create((IResource)((IResource)element));
            element = javaElement != null && !javaElement.exists() ? null : javaElement;
        }
        return element;
    }

    public static IType[] findApplets(IRunnableContext context, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    int nElements = elements.length;
                    pm.beginTask(LauncherMessages.appletlauncher_search_task_inprogress, nElements);
                    try {
                        int i = 0;
                        while (i < nElements) {
                            try {
                                AppletLaunchConfigurationUtils.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                            }
                            catch (JavaModelException jme) {
                                JDIDebugUIPlugin.log(jme.getStatus());
                            }
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ++i;
                        }
                    }
                    finally {
                        pm.done();
                    }
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IType[result.size()]);
    }
}

