/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ui.CodeGeneration;

public class GetterSetterUtil {
    private static final String[] EMPTY = new String[0];

    private GetterSetterUtil() {
    }

    public static String getGetterName(IField field, String[] excludedNames) throws JavaModelException {
        boolean useIs = StubUtility.useIsForBooleanGetters(field.getJavaProject());
        return GetterSetterUtil.getGetterName(field, excludedNames, useIs);
    }

    private static String getGetterName(IField field, String[] excludedNames, boolean useIsForBoolGetters) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return GetterSetterUtil.getGetterName(field.getJavaProject(), field.getElementName(), field.getFlags(), useIsForBoolGetters && JavaModelUtil.isBoolean(field), excludedNames);
    }

    public static String getGetterName(IVariableBinding variableType, IJavaProject project, String[] excludedNames, boolean isBoolean) {
        boolean useIs = StubUtility.useIsForBooleanGetters(project) && isBoolean;
        return GetterSetterUtil.getGetterName(project, variableType.getName(), variableType.getModifiers(), useIs, excludedNames);
    }

    public static String getGetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestGetterName((IJavaProject)project, (String)fieldName, (int)flags, (boolean)isBoolean, (String[])excludedNames);
    }

    public static String getSetterName(IVariableBinding variableType, IJavaProject project, String[] excludedNames, boolean isBoolean) {
        return GetterSetterUtil.getSetterName(project, variableType.getName(), variableType.getModifiers(), isBoolean, excludedNames);
    }

    public static String getSetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        boolean useIs = StubUtility.useIsForBooleanGetters(project);
        return NamingConventions.suggestSetterName((IJavaProject)project, (String)fieldName, (int)flags, (useIs && isBoolean ? 1 : 0) != 0, (String[])excludedNames);
    }

    public static String getSetterName(IField field, String[] excludedNames) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return GetterSetterUtil.getSetterName(field.getJavaProject(), field.getElementName(), field.getFlags(), JavaModelUtil.isBoolean(field), excludedNames);
    }

    public static IMethod getGetter(IField field) throws JavaModelException {
        String getterName = GetterSetterUtil.getGetterName(field, EMPTY, true);
        IMethod primaryCandidate = JavaModelUtil.findMethod(getterName, new String[0], false, field.getDeclaringType());
        if (!JavaModelUtil.isBoolean(field) || primaryCandidate != null && primaryCandidate.exists()) {
            return primaryCandidate;
        }
        String secondCandidateName = GetterSetterUtil.getGetterName(field, EMPTY, false);
        return JavaModelUtil.findMethod(secondCandidateName, new String[0], false, field.getDeclaringType());
    }

    public static IMethod getSetter(IField field) throws JavaModelException {
        String[] args = new String[]{field.getTypeSignature()};
        return JavaModelUtil.findMethod(GetterSetterUtil.getSetterName(field, EMPTY), args, false, field.getDeclaringType());
    }

    public static String getSetterStub(IField field, String setterName, boolean addComments, int flags) throws CoreException {
        String body;
        String comment;
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        String returnSig = field.getTypeSignature();
        String typeName = Signature.toString((String)returnSig);
        IJavaProject project = field.getJavaProject();
        String accessorName = StubUtility.getBaseName(field);
        String argname = StubUtility.suggestArgumentName(project, accessorName, EMPTY);
        boolean isStatic = Flags.isStatic((int)flags);
        boolean isSync = Flags.isSynchronized((int)flags);
        boolean isFinal = Flags.isFinal((int)flags);
        String lineDelim = "\n";
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getSetterComment(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), setterName, field.getElementName(), typeName, argname, accessorName, lineDelim)) != null) {
            buf.append(comment);
            buf.append(lineDelim);
        }
        buf.append(JdtFlags.getVisibilityString(flags));
        buf.append(' ');
        if (isStatic) {
            buf.append("static ");
        }
        if (isSync) {
            buf.append("synchronized ");
        }
        if (isFinal) {
            buf.append("final ");
        }
        buf.append("void ");
        buf.append(setterName);
        buf.append('(');
        buf.append(typeName);
        buf.append(' ');
        buf.append(argname);
        buf.append(") {");
        buf.append(lineDelim);
        boolean useThis = StubUtility.useThisForFieldAccess(project);
        if (argname.equals(fieldName) || useThis && !isStatic) {
            fieldName = isStatic ? String.valueOf(parentType.getElementName()) + '.' + fieldName : "this." + fieldName;
        }
        if ((body = CodeGeneration.getSetterMethodBodyContent(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), setterName, fieldName, argname, lineDelim)) != null) {
            buf.append(body);
        }
        buf.append("}");
        buf.append(lineDelim);
        return buf.toString();
    }

    public static String getGetterStub(IField field, String getterName, boolean addComments, int flags) throws CoreException {
        String body;
        String comment;
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        boolean isStatic = Flags.isStatic((int)flags);
        boolean isSync = Flags.isSynchronized((int)flags);
        boolean isFinal = Flags.isFinal((int)flags);
        String typeName = Signature.toString((String)field.getTypeSignature());
        String accessorName = StubUtility.getBaseName(field);
        String lineDelim = "\n";
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getGetterComment(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), getterName, field.getElementName(), typeName, accessorName, lineDelim)) != null) {
            buf.append(comment);
            buf.append(lineDelim);
        }
        buf.append(JdtFlags.getVisibilityString(flags));
        buf.append(' ');
        if (isStatic) {
            buf.append("static ");
        }
        if (isSync) {
            buf.append("synchronized ");
        }
        if (isFinal) {
            buf.append("final ");
        }
        buf.append(typeName);
        buf.append(' ');
        buf.append(getterName);
        buf.append("() {");
        buf.append(lineDelim);
        boolean useThis = StubUtility.useThisForFieldAccess(field.getJavaProject());
        if (useThis && !isStatic) {
            fieldName = "this." + fieldName;
        }
        if ((body = CodeGeneration.getGetterMethodBodyContent(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), getterName, fieldName, lineDelim)) != null) {
            buf.append(body);
        }
        buf.append("}");
        buf.append(lineDelim);
        return buf.toString();
    }

    public static Expression getAssignedValue(ASTNode node, ASTRewrite astRewrite, Expression getterExpression, ITypeBinding variableType, boolean is50OrHigher) {
        InfixExpression.Operator op = null;
        AST ast = astRewrite.getAST();
        if (GetterSetterUtil.isNotInBlock(node)) {
            return null;
        }
        if (node.getNodeType() == 7) {
            Assignment assignment = (Assignment)node;
            Expression rightHandSide = assignment.getRightHandSide();
            Expression copiedRightOp = (Expression)astRewrite.createCopyTarget((ASTNode)rightHandSide);
            if (assignment.getOperator() == Assignment.Operator.ASSIGN) {
                ITypeBinding rightHandSideType = rightHandSide.resolveTypeBinding();
                copiedRightOp = GetterSetterUtil.createNarrowCastIfNessecary(copiedRightOp, rightHandSideType, ast, variableType, is50OrHigher);
                return copiedRightOp;
            }
            if (getterExpression != null) {
                InfixExpression infix = ast.newInfixExpression();
                infix.setLeftOperand(getterExpression);
                infix.setOperator(ASTNodes.convertToInfixOperator(assignment.getOperator()));
                ITypeBinding infixType = infix.resolveTypeBinding();
                if (NecessaryParenthesesChecker.needsParentheses(copiedRightOp, (ASTNode)infix, (StructuralPropertyDescriptor)InfixExpression.RIGHT_OPERAND_PROPERTY)) {
                    ParenthesizedExpression p = ast.newParenthesizedExpression();
                    p.setExpression(copiedRightOp);
                    copiedRightOp = p;
                }
                infix.setRightOperand(copiedRightOp);
                return GetterSetterUtil.createNarrowCastIfNessecary((Expression)infix, infixType, ast, variableType, is50OrHigher);
            }
        } else if (node.getNodeType() == 37) {
            PostfixExpression po = (PostfixExpression)node;
            if (po.getOperator() == PostfixExpression.Operator.INCREMENT) {
                op = InfixExpression.Operator.PLUS;
            }
            if (po.getOperator() == PostfixExpression.Operator.DECREMENT) {
                op = InfixExpression.Operator.MINUS;
            }
        } else if (node.getNodeType() == 38) {
            PrefixExpression pe = (PrefixExpression)node;
            if (pe.getOperator() == PrefixExpression.Operator.INCREMENT) {
                op = InfixExpression.Operator.PLUS;
            }
            if (pe.getOperator() == PrefixExpression.Operator.DECREMENT) {
                op = InfixExpression.Operator.MINUS;
            }
        }
        if (op != null && getterExpression != null) {
            return GetterSetterUtil.createInfixInvocationFromPostPrefixExpression(op, getterExpression, ast, variableType, is50OrHigher);
        }
        return null;
    }

    private static boolean isNotInBlock(ASTNode parent) {
        ASTNode statement = parent.getParent();
        boolean isStatement = statement.getNodeType() != 21;
        ASTNode block = statement.getParent();
        boolean isBlock = block.getNodeType() == 8 || block.getNodeType() == 50;
        boolean isControlStatemenBody = ASTNodes.isControlStatementBody(statement.getLocationInParent());
        return isStatement || !isBlock && !isControlStatemenBody;
    }

    private static Expression createInfixInvocationFromPostPrefixExpression(InfixExpression.Operator operator, Expression getterExpression, AST ast, ITypeBinding variableType, boolean is50OrHigher) {
        InfixExpression infix = ast.newInfixExpression();
        infix.setLeftOperand(getterExpression);
        infix.setOperator(operator);
        NumberLiteral number = ast.newNumberLiteral();
        number.setToken("1");
        infix.setRightOperand((Expression)number);
        ITypeBinding infixType = infix.resolveTypeBinding();
        return GetterSetterUtil.createNarrowCastIfNessecary((Expression)infix, infixType, ast, variableType, is50OrHigher);
    }

    private static Expression createNarrowCastIfNessecary(Expression expression, ITypeBinding expressionType, AST ast, ITypeBinding variableType, boolean is50OrHigher) {
        PrimitiveType castTo = null;
        if (variableType.isEqualTo((IBinding)expressionType)) {
            return expression;
        }
        if (is50OrHigher) {
            if (ast.resolveWellKnownType("java.lang.Character").isEqualTo((IBinding)variableType)) {
                castTo = ast.newPrimitiveType(PrimitiveType.CHAR);
            }
            if (ast.resolveWellKnownType("java.lang.Byte").isEqualTo((IBinding)variableType)) {
                castTo = ast.newPrimitiveType(PrimitiveType.BYTE);
            }
            if (ast.resolveWellKnownType("java.lang.Short").isEqualTo((IBinding)variableType)) {
                castTo = ast.newPrimitiveType(PrimitiveType.SHORT);
            }
        }
        if (ast.resolveWellKnownType("char").isEqualTo((IBinding)variableType)) {
            castTo = ast.newPrimitiveType(PrimitiveType.CHAR);
        }
        if (ast.resolveWellKnownType("byte").isEqualTo((IBinding)variableType)) {
            castTo = ast.newPrimitiveType(PrimitiveType.BYTE);
        }
        if (ast.resolveWellKnownType("short").isEqualTo((IBinding)variableType)) {
            castTo = ast.newPrimitiveType(PrimitiveType.SHORT);
        }
        if (castTo != null) {
            CastExpression cast = ast.newCastExpression();
            if (NecessaryParenthesesChecker.needsParentheses(expression, (ASTNode)cast, (StructuralPropertyDescriptor)CastExpression.EXPRESSION_PROPERTY)) {
                ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
                parenthesized.setExpression(expression);
                cast.setExpression((Expression)parenthesized);
            } else {
                cast.setExpression(expression);
            }
            cast.setType((Type)castTo);
            return cast;
        }
        return expression;
    }
}

