/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.acceptor;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.tokens.ICrossReferenceSerializer;
import org.eclipse.xtext.serializer.tokens.IEnumLiteralSerializer;
import org.eclipse.xtext.serializer.tokens.IKeywordSerializer;
import org.eclipse.xtext.serializer.tokens.IValueSerializer;

public class SequenceFeeder {
    protected ISerializationDiagnostic.Acceptor errorAcceptor;
    protected ISemanticSequencer masterSequencer;
    protected ISemanticNodeProvider.INodesForEObjectProvider nodes;
    protected Provider provider;
    protected EObject semanticObject;
    protected ISemanticSequenceAcceptor sequenceAcceptor;

    protected SequenceFeeder(Provider provider, EObject semanitcObject, ISemanticNodeProvider.INodesForEObjectProvider nodes, ISemanticSequencer masterSequencer, ISemanticSequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
        if (semanitcObject == null || nodes == null || sequenceAcceptor == null) {
            throw new NullPointerException();
        }
        this.provider = provider;
        this.semanticObject = semanitcObject;
        this.nodes = nodes;
        this.masterSequencer = masterSequencer;
        this.sequenceAcceptor = sequenceAcceptor;
        this.errorAcceptor = errorAcceptor;
    }

    public void accept(Action action, EObject child) {
        this.assertAction(action);
        EStructuralFeature ref = this.getFeature(action.getFeature());
        ICompositeNode node = ref.isMany() ? this.getCompositeNode(ref, 0, 0, child) : this.getCompositeNode(ref, child);
        this.acceptAction(action, child, node);
    }

    public void accept(Action action, EObject semanticChild, ICompositeNode node) {
        this.assertAction(action);
        this.acceptAction(action, semanticChild, node);
    }

    public void accept(Action action, EObject child, int indexInNonTransient) {
        this.assertAction(action);
        EStructuralFeature ref = this.getFeature(action.getFeature());
        this.assertIndex(ref, indexInNonTransient);
        ICompositeNode node = this.getCompositeNode(ref, 0, indexInNonTransient, child);
        this.acceptAction(action, child, node);
    }

    public void accept(Keyword keyword) {
        Assignment ass = this.getAssignment(keyword);
        Object value = GrammarUtil.isBooleanAssignment(ass) ? Boolean.TRUE : keyword.getValue();
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        ILeafNode node = this.getLeafNode(feature, value);
        String token = this.getToken(keyword, value, node);
        this.assertIndex(feature);
        this.acceptKeyword(ass, keyword, value, token, -1, node);
    }

    public void accept(Keyword keyword, Object value) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature);
        this.assertValue(feature, value);
        ILeafNode node = this.getLeafNode(feature, value);
        String token = this.getToken(keyword, value, node);
        this.acceptKeyword(ass, keyword, value, token, -1, node);
    }

    public void accept(Keyword keyword, Object value, ILeafNode node) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature);
        this.assertValue(feature, value);
        String token = this.getToken(keyword, value, node);
        this.acceptKeyword(ass, keyword, value, token, -1, node);
    }

    public void accept(Keyword keyword, Object value, int index) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature, index);
        this.assertValue(feature, value);
        ILeafNode node = this.getLeafNode(feature, index, index, value);
        String token = this.getToken(keyword, value, node);
        this.acceptKeyword(ass, keyword, value, token, index, node);
    }

    public void accept(Keyword keyword, Object value, int index, ILeafNode node) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature, index);
        this.assertValue(feature, value);
        String token = this.getToken(keyword, value, node);
        this.acceptKeyword(ass, keyword, value, token, index, node);
    }

    public void accept(Keyword keyword, Object value, int indexInFeature, int indexInNonTransient) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature, indexInFeature);
        this.assertIndex(feature, indexInNonTransient);
        this.assertValue(feature, value);
        ILeafNode node = this.getLeafNode(feature, indexInFeature, indexInNonTransient, value);
        String token = this.getToken(keyword, value, node);
        this.acceptKeyword(ass, keyword, value, token, indexInFeature, node);
    }

    public void accept(Keyword keyword, Object value, String token) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature);
        this.assertValue(feature, value);
        ILeafNode node = this.getLeafNode(feature, value);
        this.acceptKeyword(ass, keyword, value, token, -1, node);
    }

    public void accept(Keyword keyword, Object value, String token, ILeafNode node) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature);
        this.assertValue(feature, value);
        this.acceptKeyword(ass, keyword, value, token, -1, node);
    }

    public void accept(Keyword keyword, Object value, String token, int index) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature, index);
        this.assertValue(feature, value);
        ILeafNode node = this.getLeafNode(feature, index, index, value);
        this.acceptKeyword(ass, keyword, value, token, index, node);
    }

    public void accept(Keyword keyword, Object value, String token, int index, ILeafNode node) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature, index);
        this.assertValue(feature, value);
        this.acceptKeyword(ass, keyword, value, token, index, node);
    }

    public void accept(Keyword keyword, Object value, String token, int indexInFeature, int indexInNonTransient) {
        Assignment ass = this.getAssignment(keyword);
        EStructuralFeature feature = this.getFeature(ass.getFeature());
        this.assertIndex(feature, indexInFeature);
        this.assertIndex(feature, indexInNonTransient);
        this.assertValue(feature, value);
        ILeafNode node = this.getLeafNode(feature, indexInFeature, indexInNonTransient, value);
        this.acceptKeyword(ass, keyword, value, token, indexInFeature, node);
    }

    public void accept(RuleCall rc, Object value) {
        EStructuralFeature feature = this.getFeature(rc);
        this.assertIndex(feature);
        this.assertValue(feature, value);
        INode node = this.getNode(feature, value);
        String token = this.getToken(rc, value, node);
        this.acceptRuleCall(rc, value, token, -1, node);
    }

    public void accept(RuleCall rc, Object value, INode node) {
        EStructuralFeature feature = this.getFeature(rc);
        String token = this.getToken(rc, value, node);
        this.assertIndex(feature);
        this.acceptRuleCall(rc, value, token, -1, node);
    }

    public void accept(RuleCall rc, Object value, int index) {
        EStructuralFeature feature = this.getFeature(rc);
        this.assertIndex(feature, index);
        this.assertValue(feature, value);
        INode node = this.getNode(feature, index, index, value);
        String token = this.getToken(rc, value, node);
        this.acceptRuleCall(rc, value, token, index, node);
    }

    public void accept(RuleCall rc, Object value, int index, INode node) {
        EStructuralFeature feature = this.getFeature(rc);
        this.assertIndex(feature, index);
        this.assertValue(feature, value);
        String token = this.getToken(rc, value, node);
        this.acceptRuleCall(rc, value, token, index, node);
    }

    public void accept(RuleCall rc, Object value, int indexInFeature, int indexInNonTransient) {
        EStructuralFeature feature = this.getFeature(rc);
        this.assertIndex(feature, indexInFeature);
        this.assertIndex(feature, indexInNonTransient);
        this.assertValue(feature, value);
        INode node = this.getNode(feature, indexInFeature, indexInNonTransient, value);
        String token = this.getToken(rc, value, node);
        this.acceptRuleCall(rc, value, token, indexInFeature, node);
    }

    public void accept(RuleCall rc, Object value, String token) {
        EStructuralFeature feature = this.getFeature(rc);
        this.assertIndex(feature);
        this.assertValue(feature, value);
        INode node = this.getNode(feature, value);
        this.acceptRuleCall(rc, value, token, -1, node);
    }

    public void accept(RuleCall rc, Object value, String token, INode node) {
        EStructuralFeature feature = this.getFeature(rc);
        this.assertIndex(feature);
        this.assertValue(feature, value);
        this.acceptRuleCall(rc, value, token, -1, node);
    }

    public void accept(RuleCall rc, Object value, String token, int index) {
        EStructuralFeature feature = this.getFeature(rc);
        this.assertIndex(feature, index);
        this.assertValue(feature, value);
        INode node = this.getNode(feature, index, index, value);
        this.acceptRuleCall(rc, value, token, index, node);
    }

    public void accept(RuleCall rc, Object value, String token, int index, INode node) {
        EStructuralFeature feature = this.getFeature(rc);
        this.assertIndex(feature, index);
        this.assertValue(feature, value);
        this.acceptRuleCall(rc, value, token, index, node);
    }

    public void accept(RuleCall rc, Object value, String token, int indexInFeature, int indexInNonTransient) {
        EStructuralFeature feature = this.getFeature(rc);
        this.assertIndex(feature, indexInFeature);
        this.assertValue(feature, value);
        INode node = this.getNode(feature, indexInFeature, indexInNonTransient, value);
        this.acceptRuleCall(rc, value, token, indexInFeature, node);
    }

    protected void acceptAction(Action action, EObject semanticChild, ICompositeNode node) {
        if (this.sequenceAcceptor.enterAssignedAction(action, semanticChild, node)) {
            this.masterSequencer.createSequence(action, semanticChild);
            this.sequenceAcceptor.leaveAssignedAction(action, semanticChild);
        }
    }

    protected void acceptEObjectRuleCall(RuleCall ruleCall, EObject semanticChild, ICompositeNode node) {
        if (this.sequenceAcceptor.enterAssignedParserRuleCall(ruleCall, semanticChild, node)) {
            this.masterSequencer.createSequence(ruleCall.getRule(), semanticChild);
            this.sequenceAcceptor.leaveAssignedParserRuleCall(ruleCall, semanticChild);
        }
    }

    protected void acceptKeyword(Assignment ass, Keyword keyword, Object value, String token, int index, ILeafNode node) {
        if (GrammarUtil.isBooleanAssignment(ass)) {
            this.sequenceAcceptor.acceptAssignedKeyword(keyword, token, Boolean.TRUE.equals(value), index, node);
        } else {
            this.sequenceAcceptor.acceptAssignedKeyword(keyword, token, value.toString(), index, node);
        }
    }

    protected void acceptRuleCall(RuleCall rc, Object value, String token, int index, INode node) {
        CrossReference crossRef = GrammarUtil.containingCrossReference(rc);
        if (crossRef != null) {
            if (rc.getRule() instanceof ParserRule) {
                this.sequenceAcceptor.acceptAssignedCrossRefDatatype(rc, token, (EObject)value, index, this.getCompositeNode(node));
            } else if (rc.getRule() instanceof TerminalRule) {
                this.sequenceAcceptor.acceptAssignedCrossRefTerminal(rc, token, (EObject)value, index, this.getLeafNode(node));
            } else if (rc.getRule() instanceof EnumRule) {
                this.sequenceAcceptor.acceptAssignedCrossRefEnum(rc, token, (EObject)value, index, this.getCompositeNode(node));
            }
        } else if (rc.getRule() instanceof ParserRule) {
            if (rc.getRule().getType().getClassifier() instanceof EClass) {
                this.acceptEObjectRuleCall(rc, (EObject)value, this.getCompositeNode(node));
            } else {
                this.sequenceAcceptor.acceptAssignedDatatype(rc, token, value, index, this.getCompositeNode(node));
            }
        } else if (rc.getRule() instanceof TerminalRule) {
            this.sequenceAcceptor.acceptAssignedTerminal(rc, token, value, index, this.getLeafNode(node));
        } else if (rc.getRule() instanceof EnumRule) {
            this.sequenceAcceptor.acceptAssignedEnum(rc, token, value, index, this.getCompositeNode(node));
        }
    }

    protected void assertAction(Action action) {
        if (action.getFeature() == null) {
            throw new RuntimeException("Only assigned actions are allowed.");
        }
    }

    protected void assertIndex(EStructuralFeature feature) {
        if (feature.isMany()) {
            throw new RuntimeException(String.valueOf(feature.eClass().getName()) + "." + feature.getName() + " is a multi-value-feature, therefore it needs an index.");
        }
    }

    protected void assertIndex(EStructuralFeature feature, int index) {
        if (feature.isMany()) {
            if (index < 0) {
                throw new RuntimeException(String.valueOf(feature.eClass().getName()) + "." + feature.getName() + " is a multi-value-feature, therefore the index should be larger than 0. index: " + index);
            }
        } else if (index > 0) {
            throw new RuntimeException(String.valueOf(feature.eClass().getName()) + "." + feature.getName() + " is a single-value-feature, therefore it can not have an index larger than 0. index: " + index);
        }
    }

    protected void assertValue(EStructuralFeature feature, Object value) {
        if (!feature.getEType().isInstance(value)) {
            String valueType = value == null ? "null" : value.getClass().getSimpleName();
            String featureName = String.valueOf(feature.eClass().getName()) + "." + feature.getName();
            throw new RuntimeException("The value of type '" + valueType + "' can not be assigned to feature " + featureName + " of type  '" + feature.getEType().getName() + "'.");
        }
    }

    public void finish() {
        this.sequenceAcceptor.finish();
    }

    protected Assignment getAssignment(AbstractElement ele) {
        Assignment ass = GrammarUtil.containingAssignment(ele);
        if (ass == null) {
            throw new RuntimeException("Only Assigned " + ele.eClass().getName() + "s are allowed");
        }
        return ass;
    }

    protected ICompositeNode getCompositeNode(EStructuralFeature feature, int indexInFeature, int indexInNonTransient, Object child) {
        INode node = this.nodes.getNodeForMultiValue(feature, indexInFeature, indexInNonTransient, child);
        if (node instanceof ICompositeNode) {
            return (ICompositeNode)node;
        }
        return null;
    }

    protected ICompositeNode getCompositeNode(EStructuralFeature feature, Object child) {
        INode node = this.nodes.getNodeForSingelValue(feature, child);
        if (node instanceof ICompositeNode) {
            return (ICompositeNode)node;
        }
        return null;
    }

    protected ICompositeNode getCompositeNode(INode node) {
        if (node instanceof ICompositeNode) {
            return (ICompositeNode)node;
        }
        return null;
    }

    protected EStructuralFeature getFeature(RuleCall rc) {
        return this.getFeature(this.getAssignment(rc).getFeature());
    }

    protected EStructuralFeature getFeature(String name) {
        EStructuralFeature feature = this.semanticObject.eClass().getEStructuralFeature(name);
        if (feature == null) {
            throw new RuntimeException("Feature '" + name + "' not found in EClass '" + this.semanticObject.eClass().getName() + "'");
        }
        return feature;
    }

    protected ILeafNode getLeafNode(EStructuralFeature feature, int indexInFeature, int indexInNonTransient, Object child) {
        INode node = this.nodes.getNodeForMultiValue(feature, indexInFeature, indexInNonTransient, child);
        if (node instanceof ILeafNode) {
            return (ILeafNode)node;
        }
        return null;
    }

    protected ILeafNode getLeafNode(EStructuralFeature feature, Object child) {
        INode node = this.nodes.getNodeForSingelValue(feature, child);
        if (node instanceof ILeafNode) {
            return (ILeafNode)node;
        }
        return null;
    }

    protected ILeafNode getLeafNode(INode node) {
        if (node instanceof ILeafNode) {
            return (ILeafNode)node;
        }
        return null;
    }

    protected INode getNode(EStructuralFeature feature, int indexInFeature, int indexInNonTransient, Object child) {
        return this.nodes.getNodeForMultiValue(feature, indexInFeature, indexInNonTransient, child);
    }

    protected INode getNode(EStructuralFeature feature, Object child) {
        return this.nodes.getNodeForSingelValue(feature, child);
    }

    protected String getToken(Keyword keyword, Object value, ILeafNode node) {
        return this.provider.keywordSerializer.serializeAssignedKeyword(this.semanticObject, keyword, value, node, this.errorAcceptor);
    }

    protected String getToken(RuleCall rc, Object value, INode node) {
        CrossReference crossRef = GrammarUtil.containingCrossReference(rc);
        if (crossRef != null) {
            return this.provider.crossRefSerializer.serializeCrossRef(this.semanticObject, crossRef, (EObject)value, node, this.errorAcceptor);
        }
        if (GrammarUtil.isEObjectRuleCall(rc)) {
            return null;
        }
        if (GrammarUtil.isEnumRuleCall(rc)) {
            return this.provider.enumLiteralSerializer.serializeAssignedEnumLiteral(this.semanticObject, rc, value, node, this.errorAcceptor);
        }
        return this.provider.valueSerializer.serializeAssignedValue(this.semanticObject, rc, value, node, this.errorAcceptor);
    }

    public static class Provider {
        @Inject
        protected ICrossReferenceSerializer crossRefSerializer;
        @Inject
        protected IEnumLiteralSerializer enumLiteralSerializer;
        @Inject
        protected IKeywordSerializer keywordSerializer;
        @Inject
        protected IValueSerializer valueSerializer;

        public SequenceFeeder create(EObject semanitcObject, ISemanticNodeProvider.INodesForEObjectProvider nodes, ISemanticSequencer masterSequencer, ISemanticSequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
            return new SequenceFeeder(this, semanitcObject, nodes, masterSequencer, sequenceAcceptor, errorAcceptor);
        }
    }
}

