/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide.view;

import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.ide.view.MonitorView;
import org.eclipse.core.runtime.IProgressMonitor;

public class RunMonitorView
extends MonitorView {
    public static final int TIME_BETWEEN_UPDATES = 500;
    long lastUpdateTime = 0L;
    long lastUpdatePeriod = 0L;

    public RunMonitorView(IProgressMonitor monitor) {
        super(monitor, "Run Monitor View");
    }

    @Override
    public void observing(IObservationProvider model) {
        super.observing(model);
        String mainDesc = "Running " + this.modelDesc;
        this.monitor.setTaskName(mainDesc);
    }

    public void stateChange(Object key, Object model) {
        super.stateChange(key, model);
        if (this.monitor.isCanceled() && ((IModel)model).getEngine().isRunning()) {
            ((IModel)model).getEngine().stop();
        }
    }

    public void observeUpdate(IObservationProvider observed) {
        if (System.currentTimeMillis() - this.lastUpdateTime > 500L) {
            this.lastUpdateTime = System.currentTimeMillis();
            IModel model = (IModel)observed;
            this.monitor.subTask("Period " + model.getPeriod() + (model.getStopPeriod() > 0 ? " of " + model.getStopPeriod() : ""));
            if (model.getStopPeriod() != Integer.MAX_VALUE) {
                this.monitor.worked((int)((long)model.getPeriod() - this.lastUpdatePeriod));
                this.lastUpdatePeriod = model.getPeriod();
            } else {
                this.monitor.worked(1);
            }
        }
    }

    public void observeStart(IObservationProvider observed) {
        IModel model = (IModel)observed;
        this.monitor.beginTask("Run " + model.getName(), model.getStopPeriod() > 0 && model.getStopPeriod() != Integer.MAX_VALUE ? model.getStopPeriod() : -1);
        this.monitor.subTask("Started");
    }

    public void observeStop(IObservationProvider model) {
        this.monitor.subTask("Stopped");
        this.monitor.done();
    }
}

