/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.geometry.IHost3D;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Position3DUtil;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.util.Draw3DCache;

public class LocatorHelper {
    private IFigure m_reference;

    public IFigure getReference() {
        return this.m_reference;
    }

    public LocatorHelper(IFigure i_reference) {
        if (i_reference == null) {
            throw new NullPointerException("i_reference must not be null");
        }
        this.m_reference = i_reference;
    }

    public Position3D getReferencePosition3D() {
        if (this.m_reference instanceof IFigure3D) {
            return this.getReferencePosition3D(this.m_reference.getParent());
        }
        return this.getReferencePosition3D(this.m_reference);
    }

    public Position3D getReferencePosition3D(IFigure host) {
        Position3D position3D;
        IFigure3D host3D = Figure3DHelper.getAncestor3D(host);
        Position3D result = Position3DUtil.createRelativePosition((IHost3D)host3D);
        if (this.m_reference instanceof IFigure3D) {
            IFigure3D ref3D = (IFigure3D)this.m_reference;
            result.setPosition((IPosition3D)ref3D.getPosition3D());
            return result;
        }
        Vector3f location = Draw3DCache.getVector3f();
        Vector3f size = Draw3DCache.getVector3f();
        try {
            Rectangle refBounds = this.m_reference instanceof Connection ? ((Connection)this.m_reference).getPoints().getBounds() : this.m_reference.getBounds();
            location.set((float)refBounds.x, (float)refBounds.y, 0.0f);
            size.set((float)refBounds.width, (float)refBounds.height, 1.0f);
            result.setLocation3D((IVector3f)location);
            result.setSize3D((IVector3f)size);
            result.setRotation3D(IVector3f.NULLVEC3f);
            position3D = result;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
        return position3D;
    }
}

