/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters097.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters097.utils.ComponentPortInterfaceCacheBuilder;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.6", "output_model_version=0.9.7"}, service={IConverter.class})
public class ComponentsModelConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentsModelConverter.class);
    ComponentPortInterfaceCacheBuilder cache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.6 to 0.9.7 : Executing ComponentsModel converter for model file : {}", (Object)targetFile.getName());
        this.cache = this.getComponentPortInterfaceCache(caches);
        if (this.cache == null) {
            throw new IllegalStateException("ComponentPortInterfaceCacheBuilder is not built and Object of it is not available in Converters");
        }
        this.basicConvert(targetFile, fileDocumentMapping);
    }

    private ComponentPortInterfaceCacheBuilder getComponentPortInterfaceCache(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                if (!(c instanceof ComponentPortInterfaceCacheBuilder)) continue;
                return (ComponentPortInterfaceCacheBuilder)c;
            }
        }
        return null;
    }

    private void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateComponentTaskRefs(rootElement);
        this.updateCallGraphs(rootElement);
        this.updatePortInterfaceNames(rootElement, file);
        this.updatePortReferences(rootElement);
        this.updatePortComponentInstanceReferences(rootElement);
    }

    private void updateComponentTaskRefs(Element rootElement) {
        String xpathStr = "./componentsModel/components[@tasks]";
        List components = HelperUtil.getXpathResult((Element)rootElement, (String)"./componentsModel/components[@tasks]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        if (components == null) {
            return;
        }
        for (Element component : components) {
            Attribute attribute = component.getAttribute("tasks");
            attribute.setName("processes");
        }
    }

    private void updateCallGraphs(Element rootElement) {
        StringBuilder xpathBuilder = new StringBuilder();
        xpathBuilder.append("./swModel/tasks/callGraph");
        xpathBuilder.append("|");
        xpathBuilder.append("./swModel/isrs/callGraph");
        xpathBuilder.append("|");
        xpathBuilder.append("./swModel/runnables/callGraph");
        List callGraphs = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuilder.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element element : callGraphs) {
            element.setName("activityGraph");
        }
    }

    private void updatePortInterfaceNames(Element rootElement, File file) {
        StringBuilder xpathStr = new StringBuilder();
        xpathStr.append("./componentsModel/components/ports[@xsi:type=\"am:InterfacePort\"]");
        List componentPorts = HelperUtil.getXpathResult((Element)rootElement, (String)xpathStr.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._097, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        boolean isLocal = this.cache.getCacheMap().containsKey(file);
        if (isLocal) {
            for (String interfaceName : this.cache.getCachedInterfaceNames()) {
                this.createInterface(rootElement, interfaceName, file);
            }
        }
        for (Element port : componentPorts) {
            Attribute typeAttr = port.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            String typeValue = typeAttr.getValue();
            typeValue = typeValue.replace("am:InterfacePort", "am:ComponentPort");
            typeAttr.setValue(typeValue);
            Attribute interfaceAttr = port.getAttribute("interfaceName");
            if (interfaceAttr == null) continue;
            String value = interfaceAttr.getValue();
            if (value == null || value.trim().isEmpty()) {
                interfaceAttr.detach();
                continue;
            }
            if (isLocal) {
                interfaceAttr.setName("interface");
                interfaceAttr.setValue(String.valueOf(HelperUtil.encodeName((String)value)) + "?type=MainInterface");
            } else {
                Element interfaceEle = new Element("interface");
                interfaceEle.setAttribute("type", "am:MainInterface", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                interfaceEle.setAttribute("href", "amlt:/#" + HelperUtil.encodeName((String)value) + "?type=MainInterface");
                port.addContent((Content)interfaceEle);
                interfaceAttr.detach();
            }
            typeAttr.detach();
        }
    }

    private void createInterface(Element rootElement, String interfaceName, File file) {
        String xpath = "./componentsModel";
        List componentsModel = HelperUtil.getXpathResult((Element)rootElement, (String)xpath, Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        Element interfaceEle = new Element("interfaces");
        interfaceEle.setAttribute("name", HelperUtil.encodeName((String)interfaceName));
        if (!componentsModel.isEmpty()) {
            ((Element)componentsModel.get(0)).addContent((Content)interfaceEle);
        } else {
            Element componentsModelElement = new Element("componentsModel");
            componentsModelElement.addContent((Content)interfaceEle);
            rootElement.addContent((Content)componentsModelElement);
        }
        LOGGER.info("Migration from 0.9.6 to 0.9.7 : Interface {} created in File : {}", (Object)interfaceName, (Object)file.getName());
    }

    private void updatePortReferences(Element rootElement) {
        StringBuilder xPathStr = new StringBuilder();
        xPathStr.append("./swModel/tasks/activityGraph/items[@port]");
        xPathStr.append("|");
        xPathStr.append("./swModel/isrs/activityGraph/items[@port]");
        xPathStr.append("|");
        xPathStr.append("./swModel/runnables/activityGraph/items[@port]");
        xPathStr.append("|");
        xPathStr.append("./swModel/tasks/activityGraph/items//items[@port]");
        xPathStr.append("|");
        xPathStr.append("./swModel/isrs/activityGraph/items//items[@port]");
        xPathStr.append("|");
        xPathStr.append("./swModel/runnables/activityGraph/items//items[@port]");
        xPathStr.append("|");
        xPathStr.append("./swModel/tasks/activityGraph/items//port[@xsi:type=\"am:InterfacePort\"]");
        xPathStr.append("|");
        xPathStr.append("./swModel/isrs/activityGraph/items//port[@xsi:type=\"am:InterfacePort\"]");
        xPathStr.append("|");
        xPathStr.append("./swModel/runnables/callGraph/items//port[@xsi:type=\"am:InterfacePort\"]");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/systems/connectors//*[@port]");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/systems/connectors//port[@xsi:type=\"am:InterfacePort\"]");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/systems/groundedPorts");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/components/connectors//*[@port]");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/components/connectors//port[@xsi:type=\"am:InterfacePort\"]");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/components/groundedPorts");
        List ports = HelperUtil.getXpathResult((Element)rootElement, (String)xPathStr.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._097, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element element : ports) {
            this.updatePortAttributes(element);
        }
    }

    private void updatePortAttributes(Element element) {
        Attribute port = element.getAttribute("port");
        if (port == null) {
            port = element.getAttribute("href");
        }
        String value = port.getValue();
        value = value.replace("?type=InterfacePort", "?type=ComponentPort");
        port.setValue(value);
        Attribute type = element.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        if (type != null && type.getValue().equals("am:InterfacePort")) {
            type.detach();
        }
    }

    private void updatePortComponentInstanceReferences(Element rootElement) {
        StringBuilder xPathStr = new StringBuilder();
        xPathStr.append("./componentsModel/systems/connectors/sourcePort");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/systems/connectors/targetPort");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/systems/groundedPorts");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/components/connectors/sourcePort");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/components/connectors/targetPort");
        xPathStr.append("|");
        xPathStr.append("./componentsModel/components/groundedPorts");
        Map<String, String> parentNames = this.cache.getCachedComponentInstanceParentNames();
        List qualifiedPorts = HelperUtil.getXpathResult((Element)rootElement, (String)xPathStr.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._097, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element element : qualifiedPorts) {
            String componentName;
            String encodedParentName;
            Attribute instanceAttr = element.getAttribute("instance");
            if (instanceAttr == null) {
                Element hrefInstance = element.getChild("instance");
                if (hrefInstance == null) continue;
                LOGGER.warn("Qualified Port is having a reference to component instance {} from another model", (Object)hrefInstance.getAttributeValue("href"));
                continue;
            }
            String value = instanceAttr.getValue();
            if (!value.matches("(.*)\\?type=ComponentInstance") || (encodedParentName = parentNames.get(componentName = value.substring(0, value.indexOf("?type=ComponentInstance")))) == null) continue;
            instanceAttr.setValue(String.valueOf(encodedParentName) + "/" + value);
        }
    }
}

