/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters083.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.2", "output_model_version=0.8.3"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final String AM = "am";
    private static final String XSI = "xsi";
    private static final String HREF = "href";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String VALUES = "values";
    private static final String VALUE_PROVIDER = "valueProvider";
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.8.2 to 0.8.3 : Executing Software model converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.migrateModeSwitchElements(rootElement);
        this.migrateVariableRateActivationElements(rootElement);
        this.update_CustomProps_InterfacePort_Refs(rootElement);
    }

    private void migrateVariableRateActivationElements(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/activations[@xsi:type=\"am:VariableRateActivation\"]");
        List variableRateActivationElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)AM)});
        for (Element element : variableRateActivationElements) {
            element.removeChildren("activationDeviation");
        }
    }

    private void migrateModeSwitchElements(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/isrs/callGraph/graphEntries[@xsi:type=\"am:ModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks/callGraph/graphEntries[@xsi:type=\"am:ModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph/graphEntries//items[@xsi:type=\"am:ModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks/callGraph/graphEntries//items[@xsi:type=\"am:ModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:RunnableModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//items[@xsi:type=\"am:RunnableModeSwitch\"]");
        List modeSwitchElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)AM)});
        this.updateModeSwitchElement(modeSwitchElements);
    }

    private void updateModeSwitchElement(List<Element> modeSwitchElements) {
        for (Element modeSwitchElement : modeSwitchElements) {
            boolean isLocalModeLabelUsed = false;
            String modeLabelValue = null;
            Attribute valueProviderAttribute = modeSwitchElement.getAttribute(VALUE_PROVIDER);
            Element valueProviderChild = modeSwitchElement.getChild(VALUE_PROVIDER);
            if (valueProviderAttribute != null) {
                isLocalModeLabelUsed = true;
                modeLabelValue = valueProviderAttribute.getValue();
                modeSwitchElement.removeAttribute(valueProviderAttribute);
            } else if (valueProviderChild != null) {
                modeLabelValue = valueProviderChild.getAttributeValue(HREF);
                modeSwitchElement.removeContent((Content)valueProviderChild);
            }
            List entriesElements = modeSwitchElement.getChildren("entries");
            for (Element entriesElement : entriesElements) {
                String[] split;
                boolean isLocalLiteralsUsed = false;
                Attribute valuesAttribute = entriesElement.getAttribute(VALUES);
                List valuesElements = entriesElement.getChildren(VALUES);
                ArrayList<String> literals = new ArrayList<String>();
                if (valuesAttribute != null) {
                    isLocalLiteralsUsed = true;
                    String value = valuesAttribute.getValue();
                    String[] stringArray = split = value.split("\\s+");
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        literals.add(string);
                        ++n2;
                    }
                    entriesElement.removeAttribute(valuesAttribute);
                } else if (valuesElements != null) {
                    split = valuesElements.iterator();
                    while (split.hasNext()) {
                        Element valueElement = (Element)split.next();
                        String attributeValue = valueElement.getAttributeValue(HREF);
                        if (attributeValue == null) continue;
                        literals.add(attributeValue);
                    }
                    entriesElement.removeChildren(VALUES);
                }
                Element conditionElement = new Element("condition");
                for (String literal : literals) {
                    Element entriesElementInsideConditionElement = new Element("entries");
                    entriesElementInsideConditionElement.setAttribute(TYPE, "am:ModeValue", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                    if (modeLabelValue != null) {
                        if (isLocalModeLabelUsed) {
                            entriesElementInsideConditionElement.setAttribute(VALUE_PROVIDER, modeLabelValue);
                        } else {
                            Element valueProviderElement = new Element(VALUE_PROVIDER);
                            entriesElementInsideConditionElement.addContent((Content)valueProviderElement);
                        }
                    }
                    if (isLocalLiteralsUsed) {
                        entriesElementInsideConditionElement.setAttribute(VALUE, literal);
                    } else {
                        Element valueElement = new Element(VALUE);
                        valueElement.setAttribute(HREF, literal);
                        entriesElementInsideConditionElement.addContent((Content)valueElement);
                    }
                    conditionElement.addContent((Content)entriesElementInsideConditionElement);
                }
                entriesElement.addContent((Content)conditionElement);
            }
        }
    }

    private void update_CustomProps_InterfacePort_Refs(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append(".//customProperties/value[@xsi:type=\"am:FInterfacePort\"]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//customProperties/value/value[@xsi:type=\"am:FInterfacePort\"]");
        List customPropsVals = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)AM)});
        for (Element element : customPropsVals) {
            Attribute val = element.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            val.setValue("am:InterfacePort");
            this.replaceFInterfacePortReference(element.getAttribute(HREF));
        }
    }

    private void replaceFInterfacePortReference(Attribute attr) {
        if (attr != null) {
            String value = attr.getValue();
            value = value.replace("=FInterfacePort", "=InterfacePort");
            attr.setValue(value);
        }
    }
}

