/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.utils;

import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public final class HelperUtils_092_093 {
    private static final String XSI = "xsi";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String AVERAGE = "average";
    private static final String ALPHA = "alpha";
    private static final String BETA = "beta";
    private static final String MEAN = "mean";
    private static final String SD = "sd";
    private static final String LOWER_BOUND = "lowerBound";
    private static final String UPPER_BOUND = "upperBound";
    private static final String UNIT = "unit";

    private HelperUtils_092_093() {
    }

    public static Element migrateDeviationElementContainingLongValue(Element oldDeviationElement, String newElementName, double ipcValue, SessionLogger logger) {
        Element oldDistributionElement;
        String value;
        Element upperBound;
        String value2;
        if (oldDeviationElement == null) {
            return null;
        }
        Element newDeviationElement = new Element(newElementName);
        Element lowerBound = oldDeviationElement.getChild(LOWER_BOUND);
        if (lowerBound != null && (value2 = lowerBound.getAttributeValue(VALUE)) != null) {
            newDeviationElement.setAttribute(new Attribute(LOWER_BOUND, HelperUtils_092_093.getValueAfterApplyingIPC(value2, ipcValue, logger)));
        }
        if ((upperBound = oldDeviationElement.getChild(UPPER_BOUND)) != null && (value = upperBound.getAttributeValue(VALUE)) != null) {
            newDeviationElement.setAttribute(new Attribute(UPPER_BOUND, HelperUtils_092_093.getValueAfterApplyingIPC(value, ipcValue, logger)));
        }
        if ((oldDistributionElement = oldDeviationElement.getChild("distribution")) == null) {
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueBoundaries");
            return newDeviationElement;
        }
        String oldDistributionType = oldDistributionElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
        if (oldDistributionType.equals("am:BetaDistribution")) {
            String beta;
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueBetaDistribution");
            String alpha = oldDistributionElement.getAttributeValue(ALPHA);
            if (alpha != null) {
                newDeviationElement.setAttribute(new Attribute(ALPHA, alpha));
            }
            if ((beta = oldDistributionElement.getAttributeValue(BETA)) != null) {
                newDeviationElement.setAttribute(new Attribute(BETA, beta));
            }
        } else if (oldDistributionType.equals("am:Boundaries")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueBoundaries");
            String samplingType = oldDistributionElement.getAttributeValue("samplingType");
            if (samplingType != null) {
                newDeviationElement.setAttribute(new Attribute("samplingType", samplingType));
            }
        } else if (oldDistributionType.equals("am:GaussDistribution")) {
            String sd;
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueGaussDistribution");
            String mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)MEAN, (String)VALUE);
            if (mean != null) {
                newDeviationElement.setAttribute(new Attribute(MEAN, HelperUtils_092_093.getValueAfterApplyingIPC(mean, ipcValue, logger)));
            }
            if ((sd = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)SD, (String)VALUE)) != null) {
                newDeviationElement.setAttribute(new Attribute(SD, sd));
            }
        } else if (oldDistributionType.equals("am:UniformDistribution")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueUniformDistribution");
        } else if (oldDistributionType.equals("am:WeibullEstimators")) {
            String mean;
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueWeibullEstimatorsDistribution");
            String pRemainPromille = oldDistributionElement.getAttributeValue("pRemainPromille");
            if (pRemainPromille != null) {
                newDeviationElement.setAttribute(new Attribute("pRemainPromille", pRemainPromille));
            }
            if ((mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)MEAN, (String)VALUE)) != null) {
                newDeviationElement.setAttribute(new Attribute(AVERAGE, HelperUtils_092_093.getValueAfterApplyingIPC(mean, ipcValue, logger)));
            }
        } else if (oldDistributionType.equals("am:WeibullParameters")) {
            logger.error("Deviation with \"WeibullParameters\" as distribution can not be migrated as the semantics of \"WeibullParameters\" were not clearly described", new Object[0]);
            return null;
        }
        return newDeviationElement;
    }

    public static Element migrateDeviationElementContainingDoubleValue(Element oldDeviationElement, String newElementName, SessionLogger logger) {
        Element oldDistributionElement;
        String value;
        Element upperBound;
        String value2;
        if (oldDeviationElement == null) {
            return null;
        }
        Element newDeviationElement = new Element(newElementName);
        Element lowerBound = oldDeviationElement.getChild(LOWER_BOUND);
        if (lowerBound != null && (value2 = lowerBound.getAttributeValue(VALUE)) != null) {
            newDeviationElement.setAttribute(new Attribute(LOWER_BOUND, value2));
        }
        if ((upperBound = oldDeviationElement.getChild(UPPER_BOUND)) != null && (value = upperBound.getAttributeValue(VALUE)) != null) {
            newDeviationElement.setAttribute(new Attribute(UPPER_BOUND, value));
        }
        if ((oldDistributionElement = oldDeviationElement.getChild("distribution")) == null) {
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueBoundaries");
            return newDeviationElement;
        }
        String oldDistributionType = oldDistributionElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
        if (oldDistributionType.equals("am:BetaDistribution")) {
            String beta;
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueBetaDistribution");
            String alpha = oldDistributionElement.getAttributeValue(ALPHA);
            if (alpha != null) {
                newDeviationElement.setAttribute(new Attribute(ALPHA, alpha));
            }
            if ((beta = oldDistributionElement.getAttributeValue(BETA)) != null) {
                newDeviationElement.setAttribute(new Attribute(BETA, beta));
            }
        } else if (oldDistributionType.equals("am:Boundaries")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueBoundaries");
            String samplingType = oldDistributionElement.getAttributeValue("samplingType");
            if (samplingType != null) {
                newDeviationElement.setAttribute(new Attribute("samplingType", samplingType));
            }
        } else if (oldDistributionType.equals("am:GaussDistribution")) {
            String sd;
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueGaussDistribution");
            String mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)MEAN, (String)VALUE);
            if (mean != null) {
                newDeviationElement.setAttribute(new Attribute(MEAN, mean));
            }
            if ((sd = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)SD, (String)VALUE)) != null) {
                newDeviationElement.setAttribute(new Attribute(SD, sd));
            }
        } else if (oldDistributionType.equals("am:UniformDistribution")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueUniformDistribution");
        } else if (oldDistributionType.equals("am:WeibullEstimators")) {
            String mean;
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueWeibullEstimatorsDistribution");
            String pRemainPromille = oldDistributionElement.getAttributeValue("pRemainPromille");
            if (pRemainPromille != null) {
                newDeviationElement.setAttribute(new Attribute("pRemainPromille", pRemainPromille));
            }
            if ((mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)MEAN, (String)VALUE)) != null) {
                newDeviationElement.setAttribute(new Attribute(AVERAGE, mean));
            }
        } else if (oldDistributionType.equals("am:WeibullParameters")) {
            logger.error("Deviation with \"WeibullParameters\" as distribution can not be migrated as the semantics of \"WeibullParameters\" were not clearly described", new Object[0]);
            return null;
        }
        return newDeviationElement;
    }

    public static Element migrateDeviationElementContainingTimeValue(Element oldDeviationElement, String newElementName, SessionLogger logger) {
        Element oldDistributionElement;
        Element upperBound;
        if (oldDeviationElement == null) {
            return null;
        }
        Element newDeviationElement = new Element(newElementName);
        Element lowerBound = oldDeviationElement.getChild(LOWER_BOUND);
        if (lowerBound != null) {
            String unitString;
            Element lowerBoundElement = new Element(LOWER_BOUND);
            newDeviationElement.addContent((Content)lowerBoundElement);
            String valueString = lowerBound.getAttributeValue(VALUE);
            if (valueString != null) {
                lowerBoundElement.setAttribute(VALUE, valueString);
            }
            if ((unitString = lowerBound.getAttributeValue(UNIT)) != null) {
                lowerBoundElement.setAttribute(UNIT, unitString);
            }
        }
        if ((upperBound = oldDeviationElement.getChild(UPPER_BOUND)) != null) {
            String unitString;
            Element upperBoundElement = new Element(UPPER_BOUND);
            newDeviationElement.addContent((Content)upperBoundElement);
            String valueString = upperBound.getAttributeValue(VALUE);
            if (valueString != null) {
                upperBoundElement.setAttribute(VALUE, valueString);
            }
            if ((unitString = upperBound.getAttributeValue(UNIT)) != null) {
                upperBoundElement.setAttribute(UNIT, unitString);
            }
        }
        if ((oldDistributionElement = oldDeviationElement.getChild("distribution")) == null) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeBoundaries");
            return newDeviationElement;
        }
        String oldDistributionType = oldDistributionElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
        if (oldDistributionType.equals("am:BetaDistribution")) {
            String beta;
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeBetaDistribution");
            String alpha = oldDistributionElement.getAttributeValue(ALPHA);
            if (alpha != null) {
                newDeviationElement.setAttribute(new Attribute(ALPHA, alpha));
            }
            if ((beta = oldDistributionElement.getAttributeValue(BETA)) != null) {
                newDeviationElement.setAttribute(new Attribute(BETA, beta));
            }
        } else if (oldDistributionType.equals("am:Boundaries")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeBoundaries");
            String samplingType = oldDistributionElement.getAttributeValue("samplingType");
            if (samplingType != null) {
                newDeviationElement.setAttribute(new Attribute("samplingType", samplingType));
            }
        } else if (oldDistributionType.equals("am:GaussDistribution")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeGaussDistribution");
            String mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)MEAN, (String)VALUE);
            String mean_unit = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)MEAN, (String)UNIT);
            String sd = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)SD, (String)VALUE);
            String sd_unit = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)SD, (String)UNIT);
            if (mean != null) {
                Element meanElement = new Element(MEAN);
                meanElement.setAttribute(VALUE, mean);
                if (mean_unit != null) {
                    meanElement.setAttribute(UNIT, mean_unit);
                }
                newDeviationElement.addContent((Content)meanElement);
            }
            if (sd != null) {
                Element sdElement = new Element(SD);
                sdElement.setAttribute(VALUE, sd);
                if (sd_unit != null) {
                    sdElement.setAttribute(UNIT, sd_unit);
                }
                newDeviationElement.addContent((Content)sdElement);
            }
        } else if (oldDistributionType.equals("am:UniformDistribution")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeUniformDistribution");
        } else if (oldDistributionType.equals("am:WeibullEstimators")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeWeibullEstimatorsDistribution");
            String pRemainPromille = oldDistributionElement.getAttributeValue("pRemainPromille");
            if (pRemainPromille != null) {
                newDeviationElement.setAttribute(new Attribute("pRemainPromille", pRemainPromille));
            }
            String mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)MEAN, (String)VALUE);
            String mean_unit = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)MEAN, (String)UNIT);
            if (mean != null) {
                Element averageElement = new Element(AVERAGE);
                averageElement.setAttribute(new Attribute(VALUE, mean));
                if (mean_unit != null) {
                    averageElement.setAttribute(new Attribute(UNIT, mean_unit));
                }
                newDeviationElement.addContent((Content)averageElement);
            }
        } else if (oldDistributionType.equals("am:WeibullParameters")) {
            logger.error("Deviation with \"WeibullParameters\" as distribution can not be migrated as the semantics of \"WeibullParameters\" were not clearly described", new Object[0]);
            return null;
        }
        return newDeviationElement;
    }

    public static String getValueAfterApplyingIPC(String value, double ipcValue, SessionLogger logger) {
        if (ipcValue != 0.0) {
            try {
                Double result = Double.parseDouble(value) / ipcValue;
                return String.valueOf(result.longValue());
            }
            catch (Exception e) {
                logger.error("error on IPC value conversion", new Object[]{e});
            }
        }
        return value;
    }

    private static void setType(Element deviation, String distributionType) {
        Attribute value_TypeAttribute = new Attribute(TYPE, distributionType, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
        deviation.getAttributes().add(value_TypeAttribute);
    }
}

