/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum ModelVersion {
    VERSION_070("0.7.0"),
    VERSION_071("0.7.1"),
    VERSION_072("0.7.2"),
    VERSION_080("0.8.0"),
    VERSION_081("0.8.1"),
    VERSION_082("0.8.2"),
    VERSION_083("0.8.3"),
    VERSION_090("0.9.0"),
    VERSION_091("0.9.1"),
    VERSION_092("0.9.2"),
    VERSION_093("0.9.3"),
    VERSION_094("0.9.4"),
    VERSION_095("0.9.5"),
    VERSION_096("0.9.6"),
    VERSION_097("0.9.7"),
    VERSION_098("0.9.8"),
    VERSION_099("0.9.9"),
    VERSION_100("1.0.0"),
    VERSION_110("1.1.0"),
    VERSION_120("1.2.0"),
    VERSION_200("2.0.0"),
    VERSION_210("2.1.0"),
    VERSION_220("2.2.0"),
    VERSION_300("3.0.0"),
    VERSION_310("3.1.0");

    private final String value;

    private ModelVersion(String v) {
        this.value = v;
    }

    public String getVersion() {
        return this.value;
    }

    public static ModelVersion getModelVersion(String version) {
        return Arrays.stream(ModelVersion.values()).filter(v -> v.value.equals(version)).findFirst().orElse(null);
    }

    public static ModelVersion[] getVersionsBefore(ModelVersion version, boolean include) {
        ArrayList<ModelVersion> versions = new ArrayList<ModelVersion>();
        ModelVersion[] allVersions = ModelVersion.values();
        int i = 0;
        while (i < (include ? version.ordinal() + 1 : version.ordinal())) {
            versions.add(allVersions[i]);
            ++i;
        }
        return versions.toArray(new ModelVersion[0]);
    }

    public static List<String> getAllSupportedVersions() {
        ModelVersion[] allVersions;
        ArrayList<String> allSupportedVersions = new ArrayList<String>();
        ModelVersion[] modelVersionArray = allVersions = ModelVersion.values();
        int n = allVersions.length;
        int n2 = 0;
        while (n2 < n) {
            ModelVersion version = modelVersionArray[n2];
            allSupportedVersions.add(version.value);
            ++n2;
        }
        return allSupportedVersions;
    }

    public static boolean isValidVersion(String version) {
        if (version != null) {
            return ModelVersion.getAllSupportedVersions().contains(version);
        }
        return false;
    }

    public static String getLatestVersion() {
        ModelVersion[] values = ModelVersion.values();
        return values[values.length - 1].value;
    }
}

