/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.7.1", "output_model_version=0.7.2"}, service={IConverter.class})
public class ConfigConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.7.1 to 0.7.2 : Executing Config Model converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = fileName2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateEventConfig(rootElement);
    }

    private void updateEventConfig(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./configModel/eventsToTrace");
        List eventsToTracelements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        if (!eventsToTracelements.isEmpty()) {
            Element eventModel = rootElement.getChild("eventModel");
            if (eventModel == null) {
                eventModel = new Element("eventModel");
                rootElement.addContent((Content)eventModel);
            }
            for (Element eventsToTracelement : eventsToTracelements) {
                Element eventElement;
                String tagType = eventsToTracelement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                eventsToTracelement.removeAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                if (!"am:EventConfigElement".equals(tagType) || (eventElement = eventsToTracelement.getChild("event")) == null) continue;
                eventElement.setName("events");
                eventsToTracelement.removeContent((Content)eventElement);
                eventModel.addContent((Content)eventElement);
                eventsToTracelement.getParent().removeContent((Content)eventsToTracelement);
            }
        }
    }
}

