/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters083.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.2", "output_model_version=0.8.3"}, service={IConverter.class})
public class ComponentModelConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.8.2 to 0.8.3 : Executing Component model converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = fileName2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateInterfacePort(rootElement);
    }

    private void updateInterfacePort(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./componentsModel/components/ports");
        List portElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element portElement : portElements) {
            String value;
            Attribute typeAttribute = portElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (typeAttribute == null || !"am:FInterfacePort".equals(value = typeAttribute.getValue())) continue;
            typeAttribute.setValue("am:InterfacePort");
        }
        StringBuilder xpathBufferForReferences = new StringBuilder();
        xpathBufferForReferences.append("./componentsModel/components/groundedPorts");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/components/connectors/sourcePort");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/components/connectors/targetPort");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/systems/groundedPorts");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/systems/connectors/sourcePort");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/systems/connectors/targetPort");
        List elementsReferringPorts = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForReferences.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element elementReferringPort : elementsReferringPorts) {
            Attribute portAttribute = elementReferringPort.getAttribute("port");
            if (portAttribute == null) {
                Attribute hrefAttribute;
                String value;
                Element portElement = elementReferringPort.getChild("port");
                if (portElement == null) continue;
                Attribute typeAttribute = portElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                if (typeAttribute != null && "am:FInterfacePort".equals(value = typeAttribute.getValue())) {
                    typeAttribute.setValue("am:InterfacePort");
                }
                if ((hrefAttribute = portElement.getAttribute("href")) == null) continue;
                String value2 = hrefAttribute.getValue();
                value2 = value2.replace("=FInterfacePort", "=InterfacePort");
                hrefAttribute.setValue(value2);
                continue;
            }
            String value = portAttribute.getValue();
            value = value.replace("=FInterfacePort", "=InterfacePort");
            portAttribute.setValue(value);
        }
    }
}

