/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AmaltheaFileHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmaltheaFileHelper.class);
    public static final String INVALID = "invalid";

    private AmaltheaFileHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isZipFile(File file) {
        boolean result = false;
        if (file != null) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (ZipFile f = new ZipFile(file);){
                    result = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static String getNamespaceFromModel(File inputFile) {
        String result = INVALID;
        if (inputFile != null && inputFile.exists() && inputFile.getName().endsWith(".amxmi")) {
            Path inputPath = Paths.get(inputFile.toURI());
            if (AmaltheaFileHelper.isZipFile(inputFile)) {
                return AmaltheaFileHelper.getNamespaceFromZip(inputPath);
            }
            return AmaltheaFileHelper.getNamespaceFromFile(inputPath);
        }
        return result;
    }

    public static String getNamespaceFromZip(Path inputPath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ZipInputStream input = new ZipInputStream(Files.newInputStream(inputPath, new OpenOption[0]));){
                ZipEntry zipEntry = input.getNextEntry();
                if (zipEntry != null) {
                    return AmaltheaFileHelper.getNamespace(input);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XMLStreamException e) {
            LOGGER.error("Error on parsing input model file for namespace", (Throwable)e);
        }
        return INVALID;
    }

    public static String getNamespaceFromFile(Path inputPath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream input = Files.newInputStream(inputPath, new OpenOption[0]);){
                return AmaltheaFileHelper.getNamespace(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XMLStreamException e) {
            LOGGER.error("Error on parsing input model file for namespace", (Throwable)e);
            return INVALID;
        }
    }

    private static String getNamespace(InputStream input) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        XMLEventReader reader = xmlInputFactory.createXMLEventReader(input);
        while (reader.hasNext()) {
            StartElement startElement;
            XMLEvent nextEvent = reader.nextEvent();
            if (!nextEvent.isStartElement() || !"am".equals((startElement = nextEvent.asStartElement()).getName().getPrefix())) continue;
            return startElement.getNamespaceURI("am");
        }
        return INVALID;
    }
}

