/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.handlers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.dialogs.IDialogSettings;

public class SearchDialogSettings {
    private static final String KEY_NAME_PATTERN = "Search_NamePattern";
    private static final String KEY_CLASS_NAME = "Search_ClassName";
    private static final String KEY_CASE_SENSITIVE = "Search_CaseSensitive";
    private static final String KEY_REGEX = "Search_RegularExpression";
    private static final String KEY_FILE_SCOPE = "Search_FileScope";
    private final EClass FILTER_CLASS_DEFAULT = AmaltheaPackage.eINSTANCE.getINamed();
    private final Map<String, EClass> FILTER_CLASS_MAP = this.computeSubclassMap();
    boolean m_success = false;
    String m_namePattern = "";
    String m_filterClassName = this.FILTER_CLASS_DEFAULT.getName();
    boolean m_caseSensitive = false;
    boolean m_regularExpression = false;
    boolean m_restrictToFile = false;

    String[] getFilterClassNames() {
        return (String[])this.FILTER_CLASS_MAP.keySet().stream().sorted().toArray(String[]::new);
    }

    public boolean isSearchRestrictedToFile() {
        return this.m_restrictToFile;
    }

    public Class<INamed> computeFilterClass() {
        EClass eClass = this.FILTER_CLASS_MAP.get(this.m_filterClassName);
        if (eClass == null) {
            return null;
        }
        return eClass.getInstanceClass();
    }

    public Pattern computeSearchPattern() {
        if (!this.m_success) {
            return null;
        }
        StringBuilder pattern = new StringBuilder();
        pattern.append(this.m_caseSensitive ? "" : "(?i)");
        if (this.m_regularExpression) {
            pattern.append(this.m_namePattern);
            try {
                return Pattern.compile(pattern.toString());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return null;
            }
        }
        boolean quoted = false;
        StringBuilder buffer = new StringBuilder();
        char[] cArray = this.m_namePattern.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character ch = Character.valueOf(cArray[n2]);
            if (quoted) {
                buffer.append(ch);
                quoted = false;
            } else if (ch.charValue() == '\\') {
                quoted = true;
            } else if (ch.charValue() == '*' || ch.charValue() == '?') {
                if (buffer.length() > 0) {
                    pattern.append(Pattern.quote(buffer.toString()));
                    buffer.setLength(0);
                }
                pattern.append(ch.charValue() == '*' ? ".*" : ".");
            } else {
                buffer.append(ch);
            }
            ++n2;
        }
        if (buffer.length() > 0) {
            pattern.append(Pattern.quote(buffer.toString()));
        }
        return Pattern.compile(pattern.toString());
    }

    public void saveTo(IDialogSettings store) {
        if (store == null) {
            return;
        }
        store.put(KEY_NAME_PATTERN, this.m_namePattern);
        store.put(KEY_CLASS_NAME, this.m_filterClassName);
        store.put(KEY_CASE_SENSITIVE, this.m_caseSensitive);
        store.put(KEY_REGEX, this.m_regularExpression);
        store.put(KEY_FILE_SCOPE, this.m_restrictToFile);
    }

    public void loadFrom(IDialogSettings store) {
        if (store == null) {
            return;
        }
        if (store.get(KEY_NAME_PATTERN) != null) {
            this.m_namePattern = store.get(KEY_NAME_PATTERN);
        }
        if (store.get(KEY_CLASS_NAME) != null) {
            this.m_filterClassName = store.get(KEY_CLASS_NAME);
        }
        if (store.get(KEY_CASE_SENSITIVE) != null) {
            this.m_caseSensitive = store.getBoolean(KEY_CASE_SENSITIVE);
        }
        if (store.get(KEY_REGEX) != null) {
            this.m_regularExpression = store.getBoolean(KEY_REGEX);
        }
        if (store.get(KEY_FILE_SCOPE) != null) {
            this.m_restrictToFile = store.getBoolean(KEY_FILE_SCOPE);
        }
    }

    private Map<String, EClass> computeSubclassMap() {
        return this.computeSubclassMap(this.FILTER_CLASS_DEFAULT);
    }

    private Map<String, EClass> computeSubclassMap(EClass superClass) {
        HashMap<String, EClass> classMap = new HashMap<String, EClass>();
        for (EClassifier classifier : AmaltheaPackage.eINSTANCE.getEClassifiers()) {
            EClass subClass;
            if (!(classifier instanceof EClass) || !superClass.isSuperTypeOf(subClass = (EClass)classifier)) continue;
            classMap.put(subClass.getName(), subClass);
        }
        return Collections.unmodifiableMap(classMap);
    }
}

