/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters081.utils.HelperUtils_080_081;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.0", "output_model_version=0.8.1"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final String XSI = "xsi";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.8.0 to 0.8.1 : Executing Software converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateRunnable(rootElement);
        this.updateActivations(rootElement);
        this.updateAllAbstractProcessElements(rootElement);
    }

    private void updateAllAbstractProcessElements(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/tasks");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/processPrototypes");
        List abstractProcessElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element abstractProcessElement : abstractProcessElements) {
            Attribute osekTaskGroupAttribute;
            Attribute priorityAttribute = abstractProcessElement.getAttribute("priority");
            if (priorityAttribute != null) {
                String value = priorityAttribute.getValue();
                abstractProcessElement.removeAttribute(priorityAttribute);
                if (!value.equals("0")) {
                    Element customPropertiesElement = new Element("customProperties");
                    customPropertiesElement.setAttribute("key", "priority");
                    Element valueElement = new Element(VALUE);
                    valueElement.setAttribute(TYPE, "am:StringObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                    valueElement.setAttribute(VALUE, value);
                    customPropertiesElement.addContent((Content)valueElement);
                    abstractProcessElement.addContent((Content)customPropertiesElement);
                    this.logger.info("Priority is removed from : {0} element ({1}) and added as a CustomProperty with key as Priority", new Object[]{abstractProcessElement.getName(), abstractProcessElement.getAttributeValue(NAME)});
                }
            }
            if (!abstractProcessElement.getName().equals("tasks") || (osekTaskGroupAttribute = abstractProcessElement.getAttribute("osekTaskGroup")) == null) continue;
            String osekTaskGroupValue = osekTaskGroupAttribute.getValue();
            abstractProcessElement.removeAttribute(osekTaskGroupAttribute);
            if (osekTaskGroupValue.equals("0")) continue;
            HelperUtils_080_081.addCustomProperty(abstractProcessElement, "osekTaskGroup", osekTaskGroupValue);
            this.logger.info("osekTaskGroup attribute is removed from Task ({0}) and added as a CustomProperty with key as osekTaskGroup", new Object[]{abstractProcessElement.getAttributeValue(NAME)});
        }
    }

    private void updateRunnable(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables");
        List runnableElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element runnableElement : runnableElements) {
            Attribute activationAttribute = runnableElement.getAttribute("activation");
            Element activationElement = runnableElement.getChild("activation");
            if (activationAttribute != null) {
                activationAttribute.setName("activations");
                continue;
            }
            if (activationElement == null) continue;
            activationElement.setName("activations");
        }
    }

    private void updateActivations(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/activations");
        List activationElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        boolean removedDeadLine = false;
        for (Element activationElement : activationElements) {
            Attribute triggerAttribute;
            if (activationElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)).contains("am:PeriodicActivation")) {
                Element deadlineElement = activationElement.getChild("deadline");
                if (deadlineElement == null) continue;
                deadlineElement.detach();
                Element customPropertiesElement = new Element("customProperties");
                customPropertiesElement.setAttribute("key", "deadline");
                deadlineElement.setName(VALUE);
                deadlineElement.setAttribute(TYPE, "am:TimeObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                customPropertiesElement.addContent((Content)deadlineElement);
                activationElement.addContent((Content)customPropertiesElement);
                removedDeadLine = true;
                continue;
            }
            if (!activationElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)).contains("am:EventActivation")) continue;
            List triggerElements = activationElement.getChildren("trigger");
            if (triggerElements != null) {
                for (Element element : triggerElements) {
                    element.setName("triggeringEvents");
                }
            }
            if ((triggerAttribute = activationElement.getAttribute("trigger")) == null) continue;
            triggerAttribute.setName("triggeringEvents");
        }
        if (removedDeadLine) {
            this.logger.warn("-- Deadline inside PeriodicActivation elements is removed, as there is no equivalent element for it in AMALTHEA 0.8.1", new Object[0]);
        }
    }
}

