/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb;

import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.app4mc.amalthea._import.atdb.AConverter;
import org.eclipse.app4mc.amalthea._import.atdb.AmaltheaModelUtil;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.FrequencyDomain;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.StructureType;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.emf.ecore.EObject;

public class HWConverter
extends AConverter {
    public HWConverter(Amalthea model, ATDBConnection con) {
        super(model, con, "hardware model");
    }

    @Override
    protected void execute() throws SQLException {
        HWModel hwModel = ModelUtil.getOrCreateHwModel((Amalthea)this.model);
        HwStructure system = AmaltheaModelUtil.getOrAddNew((EObject)hwModel, AmaltheaPackage.eINSTANCE.getHWModel_Structures(), "System", HwStructure.class);
        system.setStructureType(StructureType.SYSTEM);
        ArrayList ecus = new ArrayList();
        this.con.getAllECUs().forEach(ecuName -> {
            HwStructure ecu = AmaltheaModelUtil.getOrAddNew((EObject)system, AmaltheaPackage.eINSTANCE.getHwStructure_Structures(), ecuName, HwStructure.class);
            ecu.setStructureType(StructureType.ECU);
            ecus.add(ecu);
        });
        for (HwStructure ecu : ecus) {
            ArrayList processors = new ArrayList();
            this.con.getProcessorsOfECU(ecu.getName()).forEach(processorName -> {
                HwStructure processor = AmaltheaModelUtil.getOrAddNew((EObject)ecu, AmaltheaPackage.eINSTANCE.getHwStructure_Structures(), processorName, HwStructure.class);
                processor.setStructureType(StructureType.MICROCONTROLLER);
                processors.add(processor);
            });
            for (HwStructure processor : processors) {
                ArrayList cores = new ArrayList();
                this.con.getCoresOfProcessor(processor.getName()).forEach(coreName -> {
                    ProcessingUnit core = AmaltheaModelUtil.getOrAddNew((EObject)processor, AmaltheaPackage.eINSTANCE.getHwStructure_Modules(), coreName, ProcessingUnit.class, AmaltheaPackage.eINSTANCE.getProcessingUnit());
                    cores.add(core);
                });
                for (ProcessingUnit core : cores) {
                    long frequencyInHz = this.con.getCoreFrequencyInHz(core.getName());
                    if (frequencyInHz <= 0L) continue;
                    try {
                        FrequencyDomain fd = AmaltheaModelUtil.getOrAddNew((EObject)hwModel, AmaltheaPackage.eINSTANCE.getHWModel_Domains(), String.valueOf(core.getName()) + "_FD", FrequencyDomain.class, AmaltheaPackage.eINSTANCE.getFrequencyDomain());
                        fd.setDefaultValue(FactoryUtil.createFrequency((double)frequencyInHz, (FrequencyUnit)FrequencyUnit.HZ));
                        core.setFrequencyDomain(fd);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
    }
}

