/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.app4mc.amalthea._import.atdb.AConverter;
import org.eclipse.app4mc.amalthea._import.atdb.AmaltheaModelUtil;
import org.eclipse.app4mc.amalthea.model.ActivityGraph;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.DiscreteValueConstant;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.MetricAggregation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class RunnableConverter
extends AConverter {
    private static final String rt = "runningTime_";
    private final boolean extractRuntimes;
    private final boolean extractLabelAccesses;
    private final Frequency frequency;

    public RunnableConverter(Amalthea model, ATDBConnection con, boolean extractRuntimes, boolean extractLabelAccesses, double frequencyInHz) {
        super(model, con, "runnables");
        this.extractRuntimes = extractRuntimes;
        this.extractLabelAccesses = extractLabelAccesses;
        this.frequency = FactoryUtil.createFrequency((double)frequencyInHz, (FrequencyUnit)FrequencyUnit.HZ);
    }

    @Override
    protected void execute() throws SQLException {
        SWModel swModel = ModelUtil.getOrCreateSwModel((Amalthea)this.model);
        TimeUnit timeBase = TimeUnit.getByName((String)this.con.getTimeBase().toLowerCase());
        ArrayList runnables = new ArrayList();
        this.con.getAllRunnables().forEach(runnableName -> {
            Runnable runnable = AmaltheaModelUtil.getOrAddNew((EObject)swModel, AmaltheaPackage.eINSTANCE.getSWModel_Runnables(), runnableName, Runnable.class);
            runnables.add(runnable);
        });
        for (Runnable runnable : runnables) {
            ActivityGraph ag = ModelUtil.getOrCreateActivityGraph((Runnable)runnable);
            if (this.extractLabelAccesses) {
                this.con.getLabelsReadByRunnable(runnable.getName()).forEach(labelName -> {
                    LabelAccess la = AmaltheaModelUtil.getOrAddNewWithContainer((EObject)ag, AmaltheaPackage.eINSTANCE.getIActivityGraphItemContainer_Items(), LabelAccess.class, AmaltheaPackage.eINSTANCE.getLabelAccess(), AmaltheaPackage.eINSTANCE.getLabelAccess_Data(), Label.class, AmaltheaPackage.eINSTANCE.getLabel(), labelName).getKey();
                    la.setAccess(LabelAccessEnum.READ);
                });
            }
            if (this.extractRuntimes && timeBase != null && this.frequency.getValue() >= 1.0) {
                double runningTimeAvg = -1.0;
                double runningTimeStDev = -1.0;
                try {
                    runningTimeAvg = Double.parseDouble(this.con.getValueForMetricAndEntity(runnable.getName(), rt + MetricAggregation.Avg));
                    runningTimeStDev = Double.parseDouble(this.con.getValueForMetricAndEntity(runnable.getName(), rt + MetricAggregation.StDev));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    DiscreteValueConstant dvd;
                    long runningTimeMin = Long.parseLong(this.con.getValueForMetricAndEntity(runnable.getName(), rt + MetricAggregation.Min));
                    long runningTimeMax = Long.parseLong(this.con.getValueForMetricAndEntity(runnable.getName(), rt + MetricAggregation.Max));
                    Ticks ticks = AmaltheaFactory.eINSTANCE.createTicks();
                    if (runningTimeMin == runningTimeMax) {
                        long constTicks = (long)RuntimeUtil.getTicksForExecutionTimeInSeconds((BigDecimal)AmaltheaServices.convertToSeconds((double)runningTimeMin, (TimeUnit)timeBase), (Frequency)this.frequency);
                        dvd = FactoryUtil.createDiscreteValueConstant((long)constTicks);
                    } else {
                        long ticksMin = (long)RuntimeUtil.getTicksForExecutionTimeInSeconds((BigDecimal)AmaltheaServices.convertToSeconds((double)runningTimeMin, (TimeUnit)timeBase), (Frequency)this.frequency);
                        long ticksMax = (long)RuntimeUtil.getTicksForExecutionTimeInSeconds((BigDecimal)AmaltheaServices.convertToSeconds((double)runningTimeMax, (TimeUnit)timeBase), (Frequency)this.frequency);
                        if (runningTimeAvg >= 0.0 && runningTimeStDev >= 0.0) {
                            double ticksAvg = RuntimeUtil.getTicksForExecutionTimeInSeconds((BigDecimal)AmaltheaServices.convertToSeconds((double)runningTimeAvg, (TimeUnit)timeBase), (Frequency)this.frequency);
                            double ticksStDev = RuntimeUtil.getTicksForExecutionTimeInSeconds((BigDecimal)AmaltheaServices.convertToSeconds((double)runningTimeStDev, (TimeUnit)timeBase), (Frequency)this.frequency);
                            dvd = FactoryUtil.createDiscreteValueGaussDistribution((double)ticksAvg, (double)ticksStDev, (Long)ticksMin, (Long)ticksMax);
                        } else {
                            dvd = FactoryUtil.createDiscreteValueBoundaries((long)ticksMin, (long)ticksMax);
                        }
                    }
                    ticks.setDefault((IDiscreteValueDeviation)dvd);
                    RuntimeUtil.clearRuntimeOfRunnable((Runnable)runnable, null);
                    ag.getItems().add((Object)ticks);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (this.extractLabelAccesses) {
                this.con.getLabelsWrittenByRunnable(runnable.getName()).forEach(labelName -> {
                    LabelAccess la = AmaltheaModelUtil.getOrAddNewWithContainer((EObject)ag, AmaltheaPackage.eINSTANCE.getIActivityGraphItemContainer_Items(), LabelAccess.class, AmaltheaPackage.eINSTANCE.getLabelAccess(), AmaltheaPackage.eINSTANCE.getLabelAccess_Data(), Label.class, AmaltheaPackage.eINSTANCE.getLabel(), labelName).getKey();
                    la.setAccess(LabelAccessEnum.WRITE);
                });
            }
            if (!ag.getItems().isEmpty()) continue;
            EcoreUtil.delete((EObject)ag);
        }
    }
}

