/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters071.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters071.utils.SectionRunnableLabelCacheBuilder;
import org.eclipse.app4mc.amalthea.converters071.utils.SectionRunnableLabelCacheEnum;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.7.0", "output_model_version=0.7.1"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final String LABELS = "labels";
    private static final String AM = "am";
    private static final String XMI = "xmi";
    private static final String XSI = "xsi";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String AMLT_PREFIX = "amlt:/#";
    @Reference
    SessionLogger logger;
    protected SectionRunnableLabelCacheBuilder cache;
    private Map<File, Document> fileDocumentMapping;
    private File targetFile;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from 0.7.0 to 0.7.1 : Executing Sw converter for model file : {0}", new Object[]{targetFile.getName()});
        this.cache = this.getSectionRunnableLabelCacheBuilder(caches);
        if (this.cache == null) {
            throw new IllegalStateException("SectionRunnableLabelCache is not built and Object of it is not available in Converters");
        }
        this.fileDocumentMapping = fileDocumentMapping;
        this.targetFile = targetFile;
        Document root = fileDocumentMapping.get(this.targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateDataSize(rootElement);
        this.updateMemoryElementsWithSectionInfo(rootElement);
        this.updateSection(rootElement);
        this.removeSectionMappingAndSectionMappingConstraint(rootElement);
        this.updateModeSwitch(rootElement);
    }

    private void updateModeSwitch(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/tasks/callGraph//graphEntries");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph//graphEntries");
        List graphEntryBaseElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_071, (String)AM)});
        for (Element graphEntryBaseElement : graphEntryBaseElements) {
            String graphEntryBaseObjectType;
            if (!"callGraph".equals(graphEntryBaseElement.getParentElement().getName())) {
                graphEntryBaseElement.setName("items");
            }
            if ((graphEntryBaseObjectType = graphEntryBaseElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI))) == null || !"am:ModeSwitch".equals(graphEntryBaseObjectType)) continue;
            List entriesElements = graphEntryBaseElement.getChildren("entries");
            boolean isDefaultFound = false;
            for (Element entriesElement : entriesElements) {
                Attribute valueAttribute;
                Attribute defaultAttribute = entriesElement.getAttribute("default");
                if (defaultAttribute != null) {
                    if (!isDefaultFound) {
                        isDefaultFound = true;
                        entriesElement.setName("defaultEntry");
                        entriesElement.removeAttribute(VALUE);
                        entriesElement.removeChild(VALUE);
                    }
                    entriesElement.removeAttribute("default");
                }
                if ((valueAttribute = entriesElement.getAttribute(VALUE)) != null) {
                    valueAttribute.setName("values");
                    continue;
                }
                Element valueElement = entriesElement.getChild(VALUE);
                if (valueElement == null) continue;
                valueElement.setName("values");
            }
        }
    }

    private void removeSectionMappingAndSectionMappingConstraint(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./mappingModel/mapping[@xsi:type=\"am:SectionMapping\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel/mappingConstraints[@xsi:type=\"am:SectionMappingConstraint\"]");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_071, (String)AM)});
        for (Element sectionMappingElement : elements) {
            sectionMappingElement.getParent().removeContent((Content)sectionMappingElement);
        }
    }

    private void updateSection(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/sections");
        List sectionElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_071, (String)AM)});
        for (Element element : sectionElements) {
            element.removeChildren("size");
            element.removeChildren(LABELS);
            element.removeChildren("runEntities");
            element.removeAttribute(LABELS);
            element.removeAttribute("runEntities");
        }
    }

    private void updateMemoryElementsWithSectionInfo(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/labels");
        List memoryElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_071, (String)AM)});
        for (Element memoryElement : memoryElements) {
            String memoryElementName = memoryElement.getAttributeValue("name");
            String memoryElementID = memoryElement.getAttributeValue("id", AmaltheaNamespaceRegistry.getGenericNamespace((String)XMI));
            List<Object> sections = new ArrayList();
            if (LABELS.equals(memoryElement.getName())) {
                sections = this.getAssociatedSectionFromCache(SectionRunnableLabelCacheEnum.LABEL_SECTIONS, memoryElementName);
                sections.addAll(this.getAssociatedSectionFromCache(SectionRunnableLabelCacheEnum.LABEL_UUID_SECTIONS, memoryElementID));
            } else if ("runnables".equals(memoryElement.getName())) {
                sections = this.getAssociatedSectionFromCache(SectionRunnableLabelCacheEnum.RUNNABLE_SECTIONS, memoryElementName);
                sections.addAll(this.getAssociatedSectionFromCache(SectionRunnableLabelCacheEnum.RUNNABLE_UUID_SECTIONS, memoryElementID));
            }
            if (sections.isEmpty()) continue;
            String sectionName = (String)sections.get(0);
            if (this.isSectionDefinedInFile(sectionName, this.targetFile)) {
                memoryElement.setAttribute(new Attribute("section", String.valueOf(this.encodeSectionName(sectionName)) + "?type=Section"));
            } else {
                Element sectionRef = new Element("section");
                sectionRef.setAttribute("href", AMLT_PREFIX + this.encodeSectionName(sectionName) + "?type=Section");
                memoryElement.addContent((Content)sectionRef);
            }
            if (sections.size() <= 1) continue;
            this.logger.warn("MemoryElement : {0} is associated to multiple sections: {1}. \nAs per AMALTHEA 0.7.1 it is allowed to be part of one Section only.", new Object[]{memoryElementName, sections.toArray()});
        }
    }

    private List<String> getAssociatedSectionFromCache(SectionRunnableLabelCacheEnum type, String memoryElementNameOrUUID) {
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        Set<File> fileSet = this.fileDocumentMapping.keySet();
        for (File file : fileSet) {
            Map<String, Object> map = cacheMap.get(file);
            Object object = map.get(type.name());
            if (!(object instanceof Map) || !((Map)object).containsKey(memoryElementNameOrUUID)) continue;
            return (List)((Map)object).get(memoryElementNameOrUUID);
        }
        return new ArrayList<String>();
    }

    private boolean isSectionDefinedInFile(String sectionName, File inputFile) {
        Object object;
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        Map<String, Object> map = cacheMap.get(inputFile);
        return map != null && (object = map.get(SectionRunnableLabelCacheEnum.SECTION_NAMES.name())) instanceof List && ((List)object).contains(sectionName);
    }

    private SectionRunnableLabelCacheBuilder getSectionRunnableLabelCacheBuilder(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                if (!(c instanceof SectionRunnableLabelCacheBuilder)) continue;
                return (SectionRunnableLabelCacheBuilder)c;
            }
        }
        return null;
    }

    private void updateDataSize(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/typeDefinitions/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/processPrototypes/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/modeLabels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/labels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/customEntities/size");
        List dataSizes = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_071, (String)AM)});
        for (Element dataSizeElement : dataSizes) {
            Attribute numberBits = dataSizeElement.getAttribute("numberBits");
            if (numberBits == null) continue;
            numberBits.setName(VALUE);
            Attribute unit = new Attribute("unit", "bit");
            dataSizeElement.setAttribute(unit);
        }
    }

    private String encodeSectionName(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return "no-name";
        }
        try {
            result = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            result = name;
        }
        return result;
    }
}

