/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.DataModelAdapter;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.DataExtractionOption;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IExtractionOption;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IRunnable;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.ParameterValidationException;
import org.eclipse.birt.report.engine.api.impl.QueryUtil;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.extension.IDataExtractionExtension;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.script.internal.ReportScriptExecutor;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;

public class DatasetPreviewTask
extends EngineTask
implements IDatasetPreviewTask {
    protected IRunnable runnable;
    protected DataSetHandle dataset;
    protected QueryDefinition query;
    protected int maxRow = -1;
    protected int startRow = 0;
    protected IFilterDefinition[] filterExpressions = null;
    protected ISortDefinition[] sortExpressions = null;
    protected boolean overrideExistingSorts = false;
    protected String[] selectedColumns;
    private DataEngineContext.DataEngineFlowMode dataEngineFlowMode = DataEngineContext.DataEngineFlowMode.NORMAL;

    protected DatasetPreviewTask(ReportEngine engine) {
        super(engine, 5);
    }

    @Override
    public IExtractionResults execute() throws EngineException {
        if (this.dataset == null) {
            throw new IllegalArgumentException("dataset can not be null");
        }
        return this.runDataset();
    }

    @Override
    public IExtractionResults extract() throws EngineException {
        return this.execute();
    }

    @Override
    public void extract(IExtractionOption options) throws BirtException {
        DataExtractionOption option = null;
        option = options == null ? new DataExtractionOption() : new DataExtractionOption(options.getOptions());
        IDataExtractionOption extractOption = this.setupExtractOption(option);
        IDataExtractionExtension dataExtraction = this.getDataExtractionExtension(extractOption);
        try {
            dataExtraction.initialize(this.executionContext.getReportContext(), extractOption);
            IExtractionResults results = this.execute();
            if (!this.executionContext.isCanceled()) {
                dataExtraction.output(results);
            }
        }
        finally {
            dataExtraction.release();
        }
    }

    private IDataExtractionOption setupExtractOption(IExtractionOption options) {
        IRenderOption defaultHtmlOptions;
        HashMap allOptions = new HashMap();
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IRenderOption defaultOptions = (IRenderOption)configs.get("org.eclipse.birt.report.engine.api.EngineConfig.defaultRenderOption");
        if (defaultOptions != null) {
            allOptions.putAll(defaultOptions.getOptions());
        }
        if ((defaultHtmlOptions = (IRenderOption)configs.get("html")) != null) {
            allOptions.putAll(defaultHtmlOptions.getOptions());
        }
        allOptions.putAll(options.getOptions());
        Map appContext = this.executionContext.getAppContext();
        Object renderContext = appContext.get("HTML_RENDER_CONTEXT");
        if (renderContext == null) {
            HTMLRenderContext htmlContext = new HTMLRenderContext();
            HTMLRenderOption htmlOptions = new HTMLRenderOption(allOptions);
            htmlContext.setBaseImageURL(htmlOptions.getBaseImageURL());
            htmlContext.setBaseURL(htmlOptions.getBaseURL());
            htmlContext.setImageDirectory(htmlOptions.getImageDirectory());
            htmlContext.setSupportedImageFormats(htmlOptions.getSupportedImageFormats());
            htmlContext.setRenderOption(htmlOptions);
            appContext.put("HTML_RENDER_CONTEXT", htmlContext);
        }
        DataExtractionOption extractOption = new DataExtractionOption(allOptions);
        return extractOption;
    }

    private IDataExtractionExtension getDataExtractionExtension(IDataExtractionOption option) throws EngineException {
        IDataExtractionExtension dataExtraction = null;
        String extension = option.getExtension();
        ExtensionManager extensionManager = ExtensionManager.getInstance();
        if (extension != null) {
            dataExtraction = extensionManager.createDataExtractionExtensionById(extension);
        }
        String format = null;
        if (dataExtraction == null && (format = option.getOutputFormat()) != null) {
            dataExtraction = extensionManager.createDataExtractionExtensionByFormat(format);
        }
        if (dataExtraction == null) {
            throw new EngineException("Error.InvalidExtensionError", new Object[]{extension, format});
        }
        return dataExtraction;
    }

    @Override
    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
    }

    @Override
    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    protected void checkRequiredParamenter(String paramName, String value) throws ParameterValidationException {
    }

    @Override
    public void setDataSet(DataSetHandle dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("dataset can not be null!");
        }
        this.dataset = dataset;
        ModuleHandle mh = dataset.getModuleHandle();
        this.runnable = new ReportRunnable((IReportEngine)this.engine, mh);
        this.setReportRunnable((ReportRunnable)this.runnable);
    }

    public void setRunnable(IRunnable runnable) {
        this.runnable = runnable;
        this.setReportRunnable((ReportRunnable)runnable);
    }

    @Override
    public void selectColumns(String[] columnNames) {
        this.selectedColumns = columnNames;
    }

    @Override
    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.filterExpressions = simpleFilterExpression;
    }

    @Override
    public void setSorts(ISortDefinition[] simpleSortExpression) {
        this.setSorts(simpleSortExpression, false);
    }

    protected ModuleHandle getHandle() {
        return ((ReportRunnable)this.runnable).getModuleHandle();
    }

    protected IExtractionResults runDataset() throws EngineException {
        IExtractionResults resultset = null;
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            if (this.runnable == null) {
                throw new EngineException("Error.ReportRunnableNotSet");
            }
            resultset = this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
        return resultset;
    }

    protected IExtractionResults doRun() throws EngineException {
        IExtractionResults result = null;
        this.usingParameterValues();
        this.initReportVariable();
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        try {
            try {
                this.executionContext.openDataEngine();
                result = this.extractQuery(this.dataset);
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "An error happened while extracting data the report. Cause:", ex);
                throw new EngineException("Error.ReportRunError", ex);
            }
            catch (OutOfMemoryError err) {
                this.log.log(Level.SEVERE, "There is insufficient memory to extract data from this report.");
                throw err;
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Error happened while running the report.", t);
                throw new EngineException("Error.ReportRunError", t);
            }
        }
        finally {
            this.closeFactory();
        }
        return result;
    }

    protected IExtractionResults extractQuery(DataSetHandle dataset) throws BirtException {
        DataRequestSession session = this.executionContext.getDataEngine().getDTESession();
        session.getDataSessionContext().getDataEngineContext().setFlowMode(this.dataEngineFlowMode);
        QueryDefinition newQuery = this.constructQuery(dataset, session);
        ModelDteApiAdapter apiAdapter = new ModelDteApiAdapter(this.executionContext);
        apiAdapter.defineDataSet(dataset, session);
        session.registerQueries((IDataQueryDefinition[])new IQueryDefinition[]{newQuery});
        IPreparedQuery preparedQuery = session.prepare((IQueryDefinition)newQuery);
        IQueryResults result = (IQueryResults)session.execute((IBasePreparedQuery)preparedQuery, null, this.executionContext.getScriptContext());
        ResultMetaData metadata = new ResultMetaData(result.getResultMetaData());
        if (this.selectedColumns != null) {
            metadata = new ResultMetaData(metadata, this.selectedColumns);
        }
        return new ExtractionResults(result, metadata, null, 0, -1, null);
    }

    protected ModuleHandle getModuleHandle() {
        return this.dataset.getModuleHandle();
    }

    protected QueryDefinition constructQuery(DataSetHandle dataset, DataRequestSession session) throws BirtException {
        if (this.query != null) {
            return this.query;
        }
        if (dataset.getCachedMetaDataHandle() == null) {
            session.refreshMetaData(dataset);
        }
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataset.getQualifiedName());
        HashSet<String> existBindings = new HashSet<String>();
        Map<String, ResultSetColumn> columns = QueryUtil.getResultSetColumns(dataset);
        if (this.selectedColumns == null) {
            for (Object column : columns.values()) {
                if (existBindings.contains(column.getColumnName())) continue;
                QueryUtil.addBinding((IQueryDefinition)query, column);
                existBindings.add(column.getColumnName());
            }
        } else {
            String[] stringArray = this.selectedColumns;
            int n = this.selectedColumns.length;
            int n2 = 0;
            while (n2 < n) {
                ResultSetColumn col;
                Object column;
                column = stringArray[n2];
                if (!existBindings.contains(column) && (col = columns.get(column)) != null) {
                    QueryUtil.addBinding((IQueryDefinition)query, col);
                    existBindings.add((String)column);
                }
                ++n2;
            }
        }
        HashSet<String> referenced = new HashSet<String>();
        if (this.maxRow >= 0) {
            query.setMaxRows(this.maxRow);
        }
        if (this.startRow > 0) {
            query.setStartingRow(this.startRow);
        }
        if (this.filterExpressions != null) {
            int i = 0;
            while (i < this.filterExpressions.length) {
                query.getFilters().add(this.filterExpressions[i]);
                this.findReferencedColumns(referenced, this.filterExpressions[i].getExpression());
                ++i;
            }
            this.filterExpressions = null;
        }
        if (this.sortExpressions != null) {
            if (this.overrideExistingSorts) {
                query.getSorts().clear();
            }
            int i = 0;
            while (i < this.sortExpressions.length) {
                query.getSorts().add(this.sortExpressions[i]);
                this.findReferencedColumns(referenced, (IBaseExpression)this.sortExpressions[i].getExpression());
                ++i;
            }
            this.sortExpressions = null;
        }
        if (!referenced.isEmpty()) {
            for (String col : referenced) {
                if (existBindings.contains(col)) continue;
                QueryUtil.addBinding((IQueryDefinition)query, col);
                existBindings.add(col);
            }
        }
        return query;
    }

    private void findReferencedColumns(Set<String> referenced, IBaseExpression expr) {
        this.findReferencedColumns(referenced, null, expr);
    }

    protected void findReferencedColumns(Set<String> referencedRows, Set<String> referencedDSRows, IBaseExpression expr) {
        block12: {
            if (expr instanceof IScriptExpression) {
                IScriptExpression script = (IScriptExpression)expr;
                try {
                    IScriptExpression scriptExpr = script;
                    String scriptId = script.getScriptId();
                    if ("constant".equals(scriptId)) {
                        return;
                    }
                    if (!"javascript".equals(scriptId)) {
                        IModelAdapter adapter = this.getModelAdapter();
                        scriptExpr = adapter.adaptJSExpression(script.getText(), script.getScriptId());
                    }
                    if (scriptExpr == null) break block12;
                    List columns = ExpressionUtil.extractColumnExpressions((String)scriptExpr.getText());
                    for (IColumnBinding col : columns) {
                        referencedRows.add(col.getResultSetColumnName());
                    }
                    if (referencedDSRows == null) break block12;
                    columns = ExpressionUtil.extractColumnExpressions((String)scriptExpr.getText(), (String)"dataSetRow");
                    for (IColumnBinding col : columns) {
                        referencedDSRows.add(col.getResultSetColumnName());
                    }
                }
                catch (BirtException e) {
                    this.log.log(Level.WARNING, "Error processing script: " + script.getText(), e);
                }
            } else if (expr instanceof IConditionalExpression) {
                IConditionalExpression condition = (IConditionalExpression)expr;
                this.findReferencedColumns(referencedRows, referencedDSRows, (IBaseExpression)condition.getExpression());
                this.findReferencedColumns(referencedRows, referencedDSRows, condition.getOperand1());
                this.findReferencedColumns(referencedRows, referencedDSRows, condition.getOperand2());
            } else if (expr instanceof IExpressionCollection) {
                IExpressionCollection exprs = (IExpressionCollection)expr;
                Collection collection = exprs.getExpressions();
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    this.findReferencedColumns(referencedRows, referencedDSRows, (IBaseExpression)i.next());
                }
            }
        }
    }

    protected IModelAdapter getModelAdapter() throws BirtException {
        DataModelAdapter adapter = new DataModelAdapter(new DataSessionContext(3));
        return adapter;
    }

    @Override
    protected void validateStringParameter(String paramName, Object paramValue, AbstractScalarParameterHandle paramHandle) throws ParameterValidationException {
    }

    @Override
    protected void loadDesign() {
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable != null) {
            ReportDesignHandle reportDesign = this.executionContext.getReportDesign();
            if (reportDesign != null) {
                Iterator iter = reportDesign.includeLibraryScriptsIterator();
                this.loadScript(iter);
                iter = reportDesign.includeScriptsIterator();
                this.loadScript(iter);
                ReportScriptExecutor.handleInitialize((ModuleHandle)reportDesign, this.executionContext);
            } else if (this.dataset != null) {
                ModuleHandle moduleHandle = this.dataset.getModuleHandle();
                Iterator iter = moduleHandle.includeScriptsIterator();
                this.loadScript(iter);
                ReportScriptExecutor.handleInitialize(moduleHandle, this.executionContext);
            }
        }
    }

    @Override
    public void setQuery(QueryDefinition query) {
        this.query = query;
    }

    @Override
    public void setSorts(ISortDefinition[] simpleSortExpression, boolean overrideExistingSorts) {
        this.sortExpressions = simpleSortExpression;
        this.overrideExistingSorts = overrideExistingSorts;
    }

    @Override
    public void setDataEngineFlowMode(DataEngineContext.DataEngineFlowMode dataEngineFlowMode) {
        this.dataEngineFlowMode = dataEngineFlowMode;
    }
}

