/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.extension.IChoiceDefinition;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionChoice;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructureDefn;

public class ExtensionModelPropertyDefn
extends ElementPropertyDefn {
    private IPropertyDefinition extProperty = null;
    private IMessages messages = null;

    public ExtensionModelPropertyDefn(IPropertyDefinition extPropertyDefn, IMessages messages) {
        this.extProperty = extPropertyDefn;
        assert (this.extProperty != null);
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        this.type = dd.getPropertyType(this.extProperty.getType());
        this.name = this.extProperty.getName();
        this.defaultValue = this.extProperty.getDefaultValue();
        this.messages = messages;
        assert (this.type != null);
        this.buildTrimOption(this.type.getTypeCode());
    }

    @Override
    public int getValueType() {
        return 3;
    }

    @Override
    public boolean canInherit() {
        return false;
    }

    @Override
    public String getGroupName() {
        if (this.extProperty.getGroupNameID() != null && this.messages != null) {
            return this.messages.getMessage(this.extProperty.getGroupNameID(), ThreadResources.getLocale());
        }
        return null;
    }

    @Override
    public String getGroupNameKey() {
        return this.extProperty.getGroupNameID();
    }

    @Override
    public IMethodInfo getMethodInfo() {
        if (this.type.getTypeCode() == 18) {
            return this.extProperty.getMethodInfo();
        }
        return null;
    }

    @Override
    public boolean isStyleProperty() {
        return false;
    }

    @Override
    void setCanInherit(boolean flag) {
        assert (false);
    }

    @Override
    void setGroupNameKey(String id) {
        assert (false);
    }

    @Override
    public IChoiceSet getAllowedChoices() {
        return this.getChoices();
    }

    @Override
    public IChoiceSet getChoices() {
        List<IChoiceDefinition> choices = this.extProperty.getChoices();
        if (choices == null || choices.size() == 0) {
            return null;
        }
        IChoice[] choiceArray = new Choice[choices.size()];
        Iterator iter = choices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IChoiceDefinition choice = (IChoiceDefinition)iter.next();
            ExtensionChoice extChoice = new ExtensionChoice(choice, this.messages);
            choiceArray[i] = extChoice;
            ++i;
        }
        assert (i == choices.size());
        ChoiceSet set = new ChoiceSet();
        set.setChoices(choiceArray);
        this.details = set;
        return set;
    }

    @Override
    public Object getDefault() {
        return this.extProperty.getDefaultValue();
    }

    @Override
    public String getDisplayName() {
        String displayName;
        if (this.extProperty.getDisplayNameID() != null && this.messages != null && !StringUtil.isBlank(displayName = this.messages.getMessage(this.extProperty.getDisplayNameID(), ThreadResources.getLocale()))) {
            return displayName;
        }
        return this.extProperty.getName();
    }

    @Override
    public String getDisplayNameID() {
        return this.extProperty.getDisplayNameID();
    }

    @Override
    public String getName() {
        return this.extProperty.getName();
    }

    @Override
    public IStructureDefn getStructDefn() {
        if (this.details instanceof StructureDefn) {
            return (StructureDefn)this.details;
        }
        return null;
    }

    @Override
    public IElementDefn getTargetElementType() {
        return null;
    }

    @Override
    public PropertyType getType() {
        int typeCode = this.extProperty.getType();
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        return dd.getPropertyType(typeCode);
    }

    @Override
    public int getTypeCode() {
        PropertyType type = this.getType();
        assert (type != null);
        return type.getTypeCode();
    }

    @Override
    public boolean isIntrinsic() {
        return false;
    }

    @Override
    public boolean isList() {
        return this.extProperty.isList();
    }

    @Override
    void setAllowedChoices(ChoiceSet allowedChoices) {
        assert (false);
    }

    @Override
    protected void setDefault(Object value) {
        assert (false);
    }

    @Override
    public void setDisplayNameID(String id) {
        assert (false);
    }

    @Override
    void setIntrinsic(boolean flag) {
        assert (false);
    }

    @Override
    protected void setIsList(boolean isList) {
        assert (false);
    }

    @Override
    public void setName(String theName) {
        assert (false);
    }

    @Override
    public void setType(PropertyType typeDefn) {
        assert (false);
    }

    @Override
    public boolean isReadOnly() {
        return this.extProperty.isReadOnly();
    }

    @Override
    public boolean isVisible() {
        return this.extProperty.isVisible();
    }
}

