/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.javascript.jscomp.ModuleIdentifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class DependencyOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean sortDependencies = false;
    private boolean pruneDependencies = false;
    private boolean dropMoochers = false;
    private boolean es6ModuleOrder = false;
    private final Set<ModuleIdentifier> entryPoints = new HashSet<ModuleIdentifier>();

    public DependencyOptions setDependencySorting(boolean enabled) {
        this.sortDependencies = enabled;
        return this;
    }

    public DependencyOptions setDependencyPruning(boolean enabled) {
        this.pruneDependencies = enabled;
        return this;
    }

    public DependencyOptions setEs6ModuleOrder(boolean es6ModuleOrder) {
        this.es6ModuleOrder = es6ModuleOrder;
        return this;
    }

    public DependencyOptions setMoocherDropping(boolean enabled) {
        this.dropMoochers = enabled;
        return this;
    }

    public DependencyOptions setEntryPoints(Collection<ModuleIdentifier> symbols) {
        this.entryPoints.clear();
        this.entryPoints.addAll(symbols);
        return this;
    }

    public boolean isEs6ModuleOrder() {
        return this.es6ModuleOrder;
    }

    boolean needsManagement() {
        return this.sortDependencies || this.pruneDependencies || this.es6ModuleOrder;
    }

    boolean shouldSortDependencies() {
        return this.sortDependencies;
    }

    boolean shouldPruneDependencies() {
        return this.pruneDependencies;
    }

    boolean shouldDropMoochers() {
        return this.pruneDependencies && this.dropMoochers;
    }

    Collection<ModuleIdentifier> getEntryPoints() {
        return this.entryPoints;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortDependencies", this.sortDependencies).add("pruneDependencies", this.pruneDependencies).add("dropMoochers", this.dropMoochers).add("es6ModuleOrder", this.es6ModuleOrder).add("entryPoints", this.entryPoints).toString();
    }
}

