/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.dialog;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.PixelConverter;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class StringVariableSelectionDialog
extends ElementListSelectionDialog {
    private Text fDescriptionText;
    private static final String TITLE = Messages.getString((String)"StringVariableSelectionDialog.Dialog.Title");
    private static final String MESSAGE = Messages.getString((String)"StringVariableSelectionDialog.Dialog.Prompt");
    private static final String DESCRIPTION_LABEL = Messages.getString((String)"StringVariableSelectionDialog.Dialog.Label");

    public StringVariableSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new StringVariableLabelProvider());
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(TITLE);
        this.setMessage(MESSAGE);
        this.setMultipleSelection(false);
        this.setElements(VariablesPlugin.getDefault().getStringVariableManager().getVariables());
    }

    public String getVariableExpression() {
        Object[] selected = this.getResult();
        if (selected != null && selected.length == 1) {
            IStringVariable variable = (IStringVariable)selected[0];
            StringBuilder buffer = new StringBuilder();
            buffer.append("${");
            buffer.append(variable.getName());
            buffer.append("}");
            return buffer.toString();
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        return ctrl;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.createArgumentArea((Composite)control);
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.ResourceVariablesDialog_ID");
        return control;
    }

    private void createArgumentArea(Composite parent) {
        Composite container = StringVariableSelectionDialog.createComposite(parent, parent.getFont(), 2, 1, 768, 0, 0);
        StringVariableSelectionDialog.createHorizontalSpacer(container, 1);
        StringVariableSelectionDialog.createWrapLabel(container, DESCRIPTION_LABEL, 2);
        this.fDescriptionText = new Text(container, 2624);
        this.fDescriptionText.setFont(container.getFont());
        this.fDescriptionText.setEditable(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 50;
        this.fDescriptionText.setLayoutData((Object)gd);
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        Object[] objects = this.getSelectedElements();
        String text = null;
        if (objects.length == 1) {
            IStringVariable variable = (IStringVariable)objects[0];
            text = variable.getDescription();
        }
        if (text == null) {
            text = "";
        }
        this.fDescriptionText.setText(text);
    }

    public static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static void createHorizontalSpacer(Composite comp, int numlines) {
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numlines;
        lbl.setLayoutData((Object)gd);
    }

    public static Button createPushButton(Composite parent, String label, Image image, int fill) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData(fill);
        button.setLayoutData((Object)gd);
        StringVariableSelectionDialog.setButtonDimensionHint(button);
        return button;
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        StringVariableSelectionDialog.setButtonDimensionHint(button);
        return button;
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = StringVariableSelectionDialog.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Label createWrapLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 64);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        l.setLayoutData((Object)gd);
        return l;
    }

    static class StringVariableLabelProvider
    extends LabelProvider {
        StringVariableLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStringVariable) {
                IStringVariable variable = (IStringVariable)element;
                return variable.getName();
            }
            return super.getText(element);
        }
    }
}

