/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IResourceBundleProvider;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public class DefaultMessages
implements IMessages {
    private ThreadResources resources;
    private IResourceBundleProvider provider;

    public DefaultMessages(ThreadResources resources) {
        this.resources = resources;
    }

    public DefaultMessages(IResourceBundleProvider provider) {
        this.provider = provider;
    }

    @Override
    public String getMessage(String key, ULocale locale) {
        String message;
        UResourceBundle resourceBundle;
        if (this.provider != null && (resourceBundle = this.provider.getResourceBundle(locale)) != null) {
            try {
                String message2 = resourceBundle.getString(key);
                if (message2 != null) {
                    return message2;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (this.resources != null && (message = this.resources.getMessage(key)) != null) {
            return message;
        }
        return null;
    }

    @Override
    public String getMessage(String key, Locale locale) {
        return this.getMessage(key, ULocale.forLocale((Locale)locale));
    }
}

