/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSetBindingSelector;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ParameterBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.BindingGroupSection;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;

public class BindingGroupDescriptorProvider
extends AbstractDescriptorProvider {
    public static final String NONE = Messages.getString((String)"BindingPage.None");
    public static final BindingInfo NullDatasetChoice = new BindingInfo(0, NONE, true);
    private Map<String, ReportItemHandle> referMap = new HashMap<String, ReportItemHandle>();
    private String NullReportItemChoice = NONE;
    private Object input;
    private String[] references;
    private transient boolean enableAutoCommit = true;
    private DataSetColumnBindingsFormHandleProvider dataSetProvider;
    protected BindingGroupSection section;

    public ILabelProvider getDataSetLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                BindingInfo info = (BindingInfo)element;
                String datasetName = info.getBindingValue();
                if (!info.isDataSet() && !NONE.equals(datasetName)) {
                    datasetName = String.valueOf(datasetName) + Messages.getString((String)"BindingGroupDescriptorProvider.Flag.DataModel");
                }
                return datasetName;
            }
        };
    }

    public IContentProvider getDataSetContentProvider() {
        return new ContentProvider();
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    protected List getAvailableDataBindingReferenceList(ReportItemHandle element) {
        ArrayList bindingRef = new ArrayList(element.getAvailableDataSetBindingReferenceList());
        if (ExtendedDataModelUIAdapterHelper.getInstance().getAdapter() != null) {
            List temp = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter().getAvailableBindingReferenceList(element);
            bindingRef.removeAll(temp);
            bindingRef.addAll(temp);
        }
        return bindingRef;
    }

    @Override
    public Object load() {
        String value;
        this.referMap.clear();
        ReportItemHandle element = this.getReportItemHandle();
        boolean isDataSet = false;
        int type = element.getDataBindingType();
        if (type == 0) {
            type = DEUtil.getBindingHolder((DesignElementHandle)element).getDataBindingType();
        }
        List referenceList = this.getAvailableDataBindingReferenceList(element);
        this.references = new String[referenceList.size() + 1];
        this.references[0] = NONE;
        this.referMap.put(this.references[0], null);
        int j = 0;
        int i = 0;
        while (i < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i);
            if (item.getName() != null) {
                this.references[++j] = item.getQualifiedName();
                this.referMap.put(this.references[j], item);
            }
            ++i;
        }
        int tmp = j + 1;
        Arrays.sort(this.references, 1, tmp);
        int i2 = 0;
        while (i2 < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i2);
            if (item.getName() == null) {
                this.references[++j] = String.valueOf(item.getElement().getDefn().getDisplayName()) + " (ID " + item.getID() + ") - " + Messages.getString((String)"BindingPage.ReportItem.NoName");
                this.referMap.put(this.references[j], item);
            }
            ++i2;
        }
        Arrays.sort(this.references, tmp, referenceList.size() + 1);
        switch (type) {
            case 1: {
                DataSetHandle dataset = element.getDataSet();
                if (dataset == null) {
                    value = BindingGroupDescriptorProvider.NullDatasetChoice.bindingValue;
                    isDataSet = true;
                    break;
                }
                List datasets = element.getModuleHandle().getAllDataSets();
                if (datasets != null) {
                    int i3 = 0;
                    while (i3 < datasets.size()) {
                        if (datasets.get(i3) == dataset) {
                            isDataSet = true;
                            break;
                        }
                        ++i3;
                    }
                }
                value = dataset.getQualifiedName();
                break;
            }
            case 2: {
                ReportItemHandle reference = element.getDataBindingReference();
                if (reference == null) {
                    value = this.NullReportItemChoice;
                    break;
                }
                value = reference.getQualifiedName();
                break;
            }
            default: {
                value = BindingGroupDescriptorProvider.NullDatasetChoice.bindingValue;
                isDataSet = true;
            }
        }
        BindingInfo info = new BindingInfo(type, value, isDataSet);
        return info;
    }

    @Override
    public void save(Object saveValue) throws SemanticException {
        if (saveValue instanceof BindingInfo) {
            BindingInfo info = (BindingInfo)saveValue;
            int type = info.getBindingType();
            BindingInfo oldValue = (BindingInfo)this.load();
            block0 : switch (type) {
                case 0: 
                case 1: {
                    if (info.equals(NullDatasetChoice)) {
                        info = null;
                    }
                    int ret = 0;
                    if (!NullDatasetChoice.equals(info)) {
                        ret = 4;
                    }
                    if (!(NullDatasetChoice.equals(oldValue) && !this.getReportItemHandle().getColumnBindings().iterator().hasNext() || info != null && info.equals(oldValue))) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret = prefDialog.open();
                    }
                    switch (ret) {
                        case 0: {
                            this.resetDataSetReference(info, true);
                            break;
                        }
                        case 1: {
                            this.resetDataSetReference(info, false);
                            break;
                        }
                        case 2: {
                            this.section.load();
                            break;
                        }
                        case 4: {
                            this.updateDataSetReference(info);
                        }
                    }
                    break;
                }
                case 2: {
                    String value = info.getBindingValue().toString();
                    if (value.equals(NONE) || value == null) {
                        value = null;
                    } else if (this.referMap.get(value).getName() == null) {
                        MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.haveNoName"), null, Messages.getString((String)"dataBinding.message.haveNoName"), 3, new String[]{Messages.getString((String)"dataBinding.button.OK")}, 0);
                        dialog.open();
                        this.section.load();
                        return;
                    }
                    int ret1 = 0;
                    if (!this.NullReportItemChoice.equals(((BindingInfo)this.load()).getBindingValue().toString()) || this.getReportItemHandle().getColumnBindings().iterator().hasNext()) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeReference"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret1 = prefDialog.open();
                    }
                    switch (ret1) {
                        case 0: {
                            this.resetReference(value);
                            break block0;
                        }
                        case 1: {
                            this.section.load();
                        }
                    }
                }
            }
        }
    }

    public String[] getReferences() {
        return this.references;
    }

    public void setReferences(String[] references) {
        this.references = references;
    }

    public List<BindingInfo> getVisibleDataSetHandles(ModuleHandle handle) {
        ArrayList<BindingInfo> list = new ArrayList<BindingInfo>();
        for (DataSetHandle dataSetHandle : handle.getVisibleDataSets()) {
            BindingInfo info = new BindingInfo(1, dataSetHandle.getQualifiedName(), true);
            list.add(info);
        }
        LinkedDataSetAdapter adapter = new LinkedDataSetAdapter();
        for (DataSetHandle dataSetHandle : adapter.getVisibleLinkedDataSetsDataSetHandles(handle)) {
            BindingInfo info = new BindingInfo(1, dataSetHandle.getQualifiedName(), false);
            list.add(info);
        }
        return list;
    }

    public BindingInfo[] getAvailableDatasetItems() {
        BindingInfo[] dataSets = this.getVisibleDataSetHandles(SessionHandleAdapter.getInstance().getModule()).toArray(new BindingInfo[0]);
        BindingInfo[] newList = new BindingInfo[dataSets.length + 1];
        newList[0] = NullDatasetChoice;
        System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
        return newList;
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public boolean isEnable() {
        return DEUtil.getInputSize((Object)this.input) == 1;
    }

    private void resetDataSetReference(BindingInfo info, boolean clearHistory) {
        try {
            this.startTrans(Messages.getString((String)"DataColumBindingDialog.stackMsg.resetReference"));
            DataSetHandle dataSet = null;
            if (info != null && info.isDataSet()) {
                dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(info.getBindingValue());
            }
            if (this.getReportItemHandle().getDataBindingType() == 2) {
                this.getReportItemHandle().setDataBindingReference(null);
            }
            boolean isExtendedDataModel = false;
            if (dataSet == null && info != null) {
                this.getReportItemHandle().setDataSet(null);
                isExtendedDataModel = new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), (Object)info.getBindingValue());
            } else {
                new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), null);
                this.getReportItemHandle().setDataSet(dataSet);
            }
            if (clearHistory) {
                this.getReportItemHandle().getColumnBindings().clearValue();
                this.getReportItemHandle().getPropertyHandle("paramBindings").clearValue();
            }
            if (info != null) {
                DataSetBindingSelector selector = new DataSetBindingSelector(UIUtil.getDefaultShell(), isExtendedDataModel ? Messages.getString((String)"BindingGroupDescriptorProvider.DataSetBindingSelector.Title.LinkModel") : Messages.getString((String)"BindingGroupDescriptorProvider.DataSetBindingSelector.Title.DataSet"));
                selector.setDataSet(info.getBindingValue(), info.isDataSet());
                if (selector.open() == 0) {
                    Object[] columns = (Object[])((Object[])selector.getResult())[1];
                    this.dataSetProvider.generateBindingColumns(columns);
                }
            }
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionUtil.handle((Throwable)e);
        }
        this.section.load();
    }

    private void updateDataSetReference(BindingInfo info) {
        try {
            this.startTrans("Update Reference");
            DataSetHandle dataSet = null;
            if (info != null && info.isDataSet()) {
                dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(info.getBindingValue());
            }
            if (this.getReportItemHandle().getDataBindingType() == 2) {
                this.getReportItemHandle().setDataBindingReference(null);
            }
            boolean isExtendedDataModel = false;
            if (dataSet == null && info != null) {
                this.getReportItemHandle().setDataSet(null);
                isExtendedDataModel = new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), (Object)info.getBindingValue());
            } else {
                new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), null);
                this.getReportItemHandle().setDataSet(dataSet);
            }
            if (info != null) {
                DataSetBindingSelector selector = new DataSetBindingSelector(UIUtil.getDefaultShell(), isExtendedDataModel ? Messages.getString((String)"BindingGroupDescriptorProvider.DataSetBindingSelector.Title.LinkModel") : Messages.getString((String)"BindingGroupDescriptorProvider.DataSetBindingSelector.Title.DataSet"));
                selector.setDataSet(info.getBindingValue(), info.isDataSet());
                Iterator bindings = this.getReportItemHandle().getColumnBindings().iterator();
                ArrayList<String> columnNames = new ArrayList<String>();
                while (bindings.hasNext()) {
                    columnNames.add(((ComputedColumnHandle)bindings.next()).getName());
                }
                if (!columnNames.isEmpty()) {
                    selector.setColumns(columnNames.toArray(new String[0]));
                }
                if (selector.open() == 0) {
                    this.clearBinding(this.getReportItemHandle().getColumnBindings(), (Object[])((Object[])selector.getResult())[2]);
                    Object[] columns = (Object[])((Object[])selector.getResult())[1];
                    this.dataSetProvider.generateBindingColumns(columns);
                }
            }
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionUtil.handle((Throwable)e);
        }
        this.section.load();
    }

    private void clearBinding(PropertyHandle columnBindings, Object[] objects) {
        if (objects != null && columnBindings.getItems() != null) {
            List<Object> list = Arrays.asList(objects);
            int i = columnBindings.getItems().size() - 1;
            while (i >= 0) {
                ComputedColumnHandle handle = (ComputedColumnHandle)columnBindings.getAt(i);
                String name = handle.getName();
                if (list.contains(name)) {
                    try {
                        columnBindings.removeItem(i);
                    }
                    catch (PropertyValueException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                --i;
            }
        }
    }

    private void resetReference(Object value) {
        if (value == null && this.getReportItemHandle().getDataBindingType() == 1) {
            this.resetDataSetReference(null, true);
        } else {
            try {
                this.startTrans(Messages.getString((String)"DataColumBindingDialog.stackMsg.resetReference"));
                ReportItemHandle element = null;
                if (value != null) {
                    element = (ReportItemHandle)SessionHandleAdapter.getInstance().getReportDesignHandle().findElement(value.toString());
                }
                this.getReportItemHandle().setDataBindingReference(element);
                this.commit();
            }
            catch (SemanticException e) {
                this.rollback();
                ExceptionUtil.handle((Throwable)e);
            }
            this.section.load();
        }
    }

    public ReportItemHandle getReportItemHandle() {
        return (ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input);
    }

    public boolean isBindingReference() {
        return this.getReportItemHandle().getDataBindingType() == 2;
    }

    protected CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    protected void startTrans(String name) {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().startTrans(name);
        }
    }

    protected void commit() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().commit();
        }
    }

    protected void rollback() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().rollback();
        }
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    public void setDependedProvider(DataSetColumnBindingsFormHandleProvider provider) {
        this.dataSetProvider = provider;
    }

    public DataSetColumnBindingsFormHandleProvider getDependedProvider() {
        return this.dataSetProvider;
    }

    public void setRefrenceSection(BindingGroupSection section) {
        this.section = section;
    }

    public void bindingDialog() {
        ParameterBindingDialog dialog = new ParameterBindingDialog(UIUtil.getDefaultShell(), (DesignElementHandle)this.getReportItemHandle());
        this.startTrans("");
        if (dialog.open() == 0) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    public String getText(int key) {
        switch (key) {
            case 0: {
                return Messages.getString((String)"BindingPage.Dataset.Label");
            }
            case 1: {
                return Messages.getString((String)"parameterBinding.title");
            }
            case 2: {
                return Messages.getString((String)"BindingPage.ReportItem.Label");
            }
        }
        return "";
    }

    public boolean enableBindingButton() {
        return !BindingGroupDescriptorProvider.NullDatasetChoice.bindingValue.equals(((BindingInfo)this.load()).getBindingValue());
    }

    public static class BindingInfo {
        private int bindingType;
        private String bindingValue;
        private boolean isDataSet;
        private boolean isReadOnly = false;

        public BindingInfo(int type, String value) {
            this.bindingType = type;
            this.bindingValue = value;
        }

        public BindingInfo(int type, String value, boolean isDataSet) {
            this.bindingType = type;
            this.bindingValue = value;
            this.isDataSet = isDataSet;
        }

        public void setDataSet(boolean isDataSet) {
            this.isDataSet = isDataSet;
        }

        public boolean isDataSet() {
            return this.isDataSet;
        }

        public BindingInfo() {
        }

        public int getBindingType() {
            return this.bindingType;
        }

        public String getBindingValue() {
            return this.bindingValue;
        }

        public void setBindingType(int bindingType) {
            this.bindingType = bindingType;
        }

        public void setBindingValue(String bindingValue) {
            this.bindingValue = bindingValue;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public void setReadOnly(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BindingInfo)) {
                return false;
            }
            BindingInfo info = (BindingInfo)obj;
            if (this.bindingValue == null && info.bindingValue != null || this.bindingValue != null && !this.bindingValue.equals(info.bindingValue)) {
                return false;
            }
            return this.bindingType == info.bindingType && this.isDataSet == info.isDataSet && this.isReadOnly == info.isReadOnly;
        }

        public int hashCode() {
            int code = 13;
            if (this.bindingValue != null) {
                code += this.bindingValue.hashCode() * 7;
            }
            code += this.bindingType * 5;
            code += Boolean.valueOf(this.isDataSet()).hashCode() * 3;
            return code += Boolean.valueOf(this.isReadOnly()).hashCode() * 11;
        }
    }

    public static class ContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

