/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ExportElementDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.MessageBox;

public class ExportElementToLibraryAction
extends AbstractViewAction {
    private static final String DISPLAY_TEXT = Messages.getString((String)"ExportToLibraryAction.action.text");

    public ExportElementToLibraryAction(Object selectedObject) {
        super(selectedObject, DISPLAY_TEXT);
    }

    public boolean isEnabled() {
        Object selection = this.getSelection();
        if (selection instanceof StructuredSelection) {
            if (((StructuredSelection)selection).size() > 1) {
                return false;
            }
            selection = ((StructuredSelection)selection).getFirstElement();
        }
        if (selection instanceof ModuleHandle) {
            return false;
        }
        if (selection instanceof DesignElementHandle) {
            return ElementExportUtil.canExport((DesignElementHandle)((DesignElementHandle)selection), (boolean)true);
        }
        if (selection instanceof StructureHandle) {
            return ElementExportUtil.canExport((StructureHandle)((StructureHandle)selection), (boolean)true);
        }
        return false;
    }

    public void run() {
        boolean check = this.chcekSelectionName();
        if (check) {
            ExportElementDialog dialog = new ExportElementDialog(this.getSelection());
            dialog.open();
        }
    }

    private boolean chcekSelectionName() {
        Object selection = this.getSelection();
        if (selection instanceof StructuredSelection) {
            if (((StructuredSelection)selection).size() > 1) {
                return false;
            }
            selection = ((StructuredSelection)selection).getFirstElement();
        }
        boolean isNameNull = false;
        if (selection instanceof DesignElementHandle) {
            isNameNull = StringUtil.isBlank((String)((DesignElementHandle)selection).getName());
        } else if (selection instanceof StructureHandle) {
            boolean bl = isNameNull = !ElementExportUtil.canExport((StructureHandle)((StructureHandle)selection), (boolean)false) && ElementExportUtil.canExport((StructureHandle)((StructureHandle)selection), (boolean)true);
        }
        if (!isNameNull) {
            return true;
        }
        SetNameAction renameAction = new SetNameAction(selection);
        if (!renameAction.isEnabled()) {
            MessageBox box = new MessageBox(UIUtil.getDefaultShell());
            box.setText(Messages.getString((String)"ExportElementToLibraryAction.waring"));
            box.setMessage(Messages.getString((String)"ExportElementToLibraryAction.waringMsg"));
            return false;
        }
        renameAction.run();
        return renameAction.isOkClicked();
    }

    public static class SetNameAction
    extends Action {
        public static final String TEXT = Messages.getString((String)"ExportElementToLibraryAction.SetNameAction.text");
        private Object selectedObj;
        private String originalName;
        private static final String ERROR_TITLE = Messages.getString((String)"ExportElementToLibraryAction.DialogTitle.setNameFailed");
        private static final String TRANS_LABEL = Messages.getString((String)"ExportElementToLibraryAction.TransLabel.Setname");
        private boolean reNameSucceed = false;
        private boolean clickOK = false;

        public SetNameAction(Object obj) {
            this(obj, TEXT);
            this.selectedObj = obj;
        }

        public SetNameAction(Object obj, String text) {
            super(text);
            this.selectedObj = obj;
        }

        public boolean isEnabled() {
            if (this.selectedObj instanceof EmbeddedImageHandle) {
                return true;
            }
            if (this.selectedObj instanceof ReportElementHandle) {
                if (this.selectedObj instanceof GroupHandle) {
                    return !((GroupHandle)this.selectedObj).getPropertyHandle("groupName").isReadOnly();
                }
                return ((ReportElementHandle)this.selectedObj).getDefn().getNameOption() != 0 && ((ReportElementHandle)this.selectedObj).canEdit();
            }
            return false;
        }

        public void run() {
            this.doRename();
        }

        private void doRename() {
            if (this.selectedObj instanceof DesignElementHandle || this.selectedObj instanceof EmbeddedImageHandle) {
                this.initOriginalName();
                InputDialog inputDialog = new InputDialog(UIUtil.getDefaultShell(), Messages.getString((String)"ExportElementToLibraryAction.DialogTitle"), Messages.getString((String)"ExportElementToLibraryAction.DialogMessage"), this.originalName, null);
                inputDialog.create();
                this.clickOK = false;
                if (inputDialog.open() == 0) {
                    this.saveChanges(inputDialog.getValue().trim());
                    this.clickOK = true;
                }
            }
        }

        private void initOriginalName() {
            if (this.selectedObj instanceof DesignElementHandle) {
                this.originalName = ((DesignElementHandle)this.selectedObj).getName();
            }
            if (this.selectedObj instanceof EmbeddedImageHandle) {
                this.originalName = ((EmbeddedImageHandle)this.selectedObj).getName();
            }
            if (this.originalName == null) {
                this.originalName = "";
            }
        }

        private void saveChanges(String newName) {
            if (!newName.equals(this.originalName)) {
                this.reNameSucceed = this.rename(this.selectedObj, newName);
                if (!this.reNameSucceed) {
                    this.doRename();
                }
            }
        }

        public boolean reNameSucceed() {
            return this.reNameSucceed;
        }

        public boolean isOkClicked() {
            return this.clickOK;
        }

        private boolean rename(Object handle, String newName) {
            if (newName.length() == 0) {
                newName = null;
            }
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(String.valueOf(TRANS_LABEL) + " " + DEUtil.getDisplayLabel((Object)handle));
            try {
                if (handle instanceof DesignElementHandle) {
                    ((DesignElementHandle)handle).setName(newName);
                }
                if (handle instanceof EmbeddedImageHandle) {
                    ((EmbeddedImageHandle)handle).setName(newName);
                }
                stack.commit();
            }
            catch (NameException e) {
                ExceptionHandler.handle(e, ERROR_TITLE, e.getLocalizedMessage());
                stack.rollback();
                return false;
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e, ERROR_TITLE, e.getLocalizedMessage());
                stack.rollback();
                return true;
            }
            return true;
        }
    }
}

