/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.web;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.web.AbstractWebGroupProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupServletMappingItemProvider
extends AbstractWebGroupProvider {
    private static Image SERVLETMAPPING;

    public GroupServletMappingItemProvider(WebApp webApp) {
        super((JavaEEObject)webApp);
        this.text = Messages.SERVLET_MAPPING_ITEM_PROVIDER;
    }

    @Override
    public List getChildren() {
        if (this.javaee != null) {
            return this.flattenMapping(((WebApp)this.javaee).getServletMappings());
        }
        return null;
    }

    @Override
    public Image getImage() {
        return GroupServletMappingItemProvider.getServletMappingImage();
    }

    public static Image getServletMappingImage() {
        if (SERVLETMAPPING == null) {
            URL url = (URL)J2EEPlugin.getPlugin().getImage(JEEUIPluginIcons.SERVLET_MAPPING);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            SERVLETMAPPING = imageDescriptor.createImage();
        }
        return SERVLETMAPPING;
    }

    private List<?> flattenMapping(List<ServletMapping> servletMappings) {
        ArrayList<ServletMappingUIWrapper> result = new ArrayList<ServletMappingUIWrapper>();
        if (servletMappings != null && servletMappings.size() > 0) {
            for (ServletMapping filterMapping : servletMappings) {
                result.addAll(this.getServletMappingDisplay(filterMapping));
            }
        }
        return result;
    }

    private List<ServletMappingUIWrapper> getServletMappingDisplay(ServletMapping element) {
        ArrayList<ServletMappingUIWrapper> result = new ArrayList<ServletMappingUIWrapper>();
        String value = null;
        if (element.getUrlPatterns().size() > 0) {
            for (UrlPatternType pattern : element.getUrlPatterns()) {
                value = pattern.getValue();
                result.add(new ServletMappingUIWrapper(String.valueOf(value) + " -> " + element.getServletName()));
            }
        }
        return result;
    }

    public class ServletMappingUIWrapper {
        private String value;

        public String getValue() {
            return this.value;
        }

        public ServletMappingUIWrapper(String value) {
            this.value = value;
        }
    }
}

