/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.core.util.LRUCache;
import org.eclipse.pde.api.tools.internal.SynchronizedOverflowingLRUCache;
import org.eclipse.pde.api.tools.internal.model.ApiType;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;

public final class ApiModelCache {
    static final int DEFAULT_CACHE_SIZE = 1000;
    static final int DEFAULT_OVERFLOW = 100;
    static ApiModelCache fInstance = null;
    Cache<String, Cache<String, Cache<String, IApiElement>>> fRootCache;
    Cache<String, Cache<String, ApiType>> fMemberTypeCache;

    private ApiModelCache() {
    }

    public static synchronized ApiModelCache getCache() {
        if (fInstance == null) {
            fInstance = new ApiModelCache();
        }
        return fInstance;
    }

    private String getCacheKey(String baseline, String component, String typename) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(baseline).append('.').append(component).append('.').append(typename);
        return buffer.toString();
    }

    public void cacheElementInfo(IApiElement element) throws CoreException {
        switch (element.getType()) {
            case 2: {
                ApiType type;
                Cache<String, IApiElement> typecache;
                IApiComponent comp;
                if (this.fRootCache == null) {
                    this.fRootCache = new Cache(6, 0);
                }
                if ((comp = element.getApiComponent()) == null) break;
                IApiBaseline baseline = comp.getBaseline();
                String id = comp.getSymbolicName();
                if (id == null) {
                    return;
                }
                Cache compcache = (Cache)((Object)this.fRootCache.get(baseline.getName()));
                if (compcache == null) {
                    compcache = new Cache(500, 50);
                    this.fRootCache.put(baseline.getName(), compcache);
                }
                if ((typecache = (Cache<String, IApiElement>)((Object)compcache.get(id))) == null) {
                    typecache = new Cache<String, IApiElement>(2000, 100);
                    compcache.put(comp.getSymbolicName(), typecache);
                }
                if ((type = (ApiType)element).isMemberType() || this.isMemberType(type.getName())) {
                    String key;
                    Cache<String, ApiType> mcache;
                    if (this.fMemberTypeCache == null) {
                        this.fMemberTypeCache = new Cache(1000, 100);
                    }
                    if ((mcache = (Cache<String, ApiType>)((Object)this.fMemberTypeCache.get(key = this.getCacheKey(baseline.getName(), id, this.getRootName(type.getName()))))) == null) {
                        mcache = new Cache<String, ApiType>(1000, 100);
                        this.fMemberTypeCache.put(key, mcache);
                    }
                    mcache.put(type.getName(), type);
                    break;
                }
                typecache.put(element.getName(), element);
                break;
            }
        }
    }

    private String getRootName(String typename) {
        int idx = typename.indexOf(36);
        if (idx > -1) {
            return typename.substring(0, idx);
        }
        return typename;
    }

    private boolean isMemberType(String typename) {
        return typename.indexOf(36) > -1;
    }

    public IApiElement getElementInfo(String baselineid, String componentid, String identifier, int type) {
        IApiElement element;
        String updatedIdentifier;
        String string = updatedIdentifier = identifier != null && identifier.startsWith("classes.java.") ? identifier.substring(8) : identifier;
        if (baselineid == null || componentid == null) {
            return null;
        }
        switch (type) {
            case 2: {
                IApiElement ele;
                Cache typecache;
                Cache compcache;
                if (this.isMemberType(updatedIdentifier)) {
                    Cache mcache;
                    if (this.fMemberTypeCache == null || (mcache = (Cache)((Object)this.fMemberTypeCache.get(this.getCacheKey(baselineid, componentid, this.getRootName(updatedIdentifier))))) == null) break;
                    return (IApiElement)mcache.get(updatedIdentifier);
                }
                if (this.fRootCache == null || (compcache = (Cache)((Object)this.fRootCache.get(baselineid))) == null || (typecache = (Cache)((Object)compcache.get(componentid))) == null || updatedIdentifier == null || (ele = (IApiElement)typecache.get(updatedIdentifier)) == null) break;
                return ele;
            }
        }
        if (componentid.startsWith("JavaSE-") && this.fRootCache != null && (element = this.getElementInfoFromAnyBaseline(baselineid, componentid, updatedIdentifier)) != null) {
            return element;
        }
        return null;
    }

    private IApiElement getElementInfoFromAnyBaseline(String baselineid, String componentid, String updatedIdentifier) {
        List elements = this.fRootCache.keysSnapshot();
        for (String otherBaselines : elements) {
            IApiElement ele;
            Cache typecache;
            Cache compcache;
            if (otherBaselines.equals(baselineid) || (compcache = (Cache)((Object)this.fRootCache.get(otherBaselines))) == null || (typecache = (Cache)((Object)compcache.get(componentid))) == null || updatedIdentifier == null || (ele = (IApiElement)typecache.get(updatedIdentifier)) == null) continue;
            return ele;
        }
        return null;
    }

    public boolean removeElementInfo(String baselineid, String componentid, String identifier, int type) {
        if (baselineid == null) {
            return false;
        }
        switch (type) {
            case 2: {
                if (componentid == null || identifier == null) break;
                boolean removed = true;
                if (this.fMemberTypeCache != null) {
                    if (this.isMemberType(identifier)) {
                        Cache mcache = (Cache)((Object)this.fMemberTypeCache.get(this.getCacheKey(baselineid, componentid, this.getRootName(identifier))));
                        if (mcache != null) {
                            return mcache.remove(identifier) != null;
                        }
                    } else {
                        this.fMemberTypeCache.remove(this.getCacheKey(baselineid, componentid, this.getRootName(identifier)));
                    }
                }
                if (this.fRootCache != null) {
                    Cache typecache;
                    Cache compcache = (Cache)((Object)this.fRootCache.get(baselineid));
                    if (compcache == null || (typecache = (Cache)((Object)compcache.get(componentid))) == null) break;
                    removed &= typecache.remove(identifier) != null;
                    if (typecache.isEmpty()) {
                        removed &= compcache.remove(componentid) != null;
                    }
                    if (compcache.isEmpty()) {
                        removed &= this.fRootCache.remove(baselineid) != null;
                    }
                    return removed;
                }
                return false;
            }
            case 1: {
                boolean removed;
                Cache compcache;
                this.flushMemberCache();
                if (this.fRootCache == null || componentid == null || (compcache = (Cache)((Object)this.fRootCache.get(baselineid))) == null) break;
                boolean bl = removed = compcache.remove(componentid) != null;
                if (compcache.isEmpty()) {
                    removed &= this.fRootCache.remove(baselineid) != null;
                }
                return removed;
            }
            case 4: {
                this.flushMemberCache();
                if (this.fRootCache == null) break;
                return this.fRootCache.remove(baselineid) != null;
            }
        }
        return false;
    }

    public boolean removeElementInfo(IApiElement element) {
        if (element == null) {
            return false;
        }
        switch (element.getType()) {
            case 1: 
            case 2: {
                IApiComponent comp;
                if (this.fRootCache == null || (comp = element.getApiComponent()) == null) break;
                try {
                    IApiBaseline baseline = comp.getBaseline();
                    return this.removeElementInfo(baseline.getName(), comp.getSymbolicName(), element.getName(), element.getType());
                }
                catch (CoreException ce) {
                    ApiPlugin.log("Failed to remove element info for " + comp.getName(), ce);
                    break;
                }
            }
            case 4: {
                this.flushMemberCache();
                if (this.fRootCache == null) break;
                IApiBaseline baseline = (IApiBaseline)element;
                return this.fRootCache.remove(baseline.getName()) != null;
            }
        }
        return false;
    }

    public void flushCaches() {
        if (this.fRootCache != null) {
            this.fRootCache.flush();
        }
        this.flushMemberCache();
    }

    private void flushMemberCache() {
        if (this.fMemberTypeCache != null) {
            this.fMemberTypeCache.flush();
        }
    }

    public boolean isEmpty() {
        boolean empty = true;
        if (this.fRootCache != null) {
            empty &= this.fRootCache.isEmpty();
        }
        if (this.fMemberTypeCache != null) {
            empty &= this.fMemberTypeCache.isEmpty();
        }
        return empty;
    }

    static class Cache<K, V>
    extends SynchronizedOverflowingLRUCache<K, V> {
        public Cache(int size, int overflow) {
            super(size, overflow);
        }

        protected boolean close(LRUCache.LRUCacheEntry<K, V> entry) {
            return true;
        }

        protected LRUCache<K, V> newInstance(int size, int newOverflow) {
            return new Cache<K, V>(size, newOverflow);
        }
    }
}

