/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.event.internal.util;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.pde.spy.event.Constants;

@Creatable
public class LoggerWrapper
extends Logger {
    @Optional
    @Inject
    private Logger logger;

    public boolean isErrorEnabled() {
        if (this.logger != null) {
            return this.logger.isErrorEnabled();
        }
        return false;
    }

    public boolean isTraceEnabled() {
        if (this.logger != null) {
            return this.logger.isTraceEnabled();
        }
        return false;
    }

    public boolean isWarnEnabled() {
        if (this.logger != null) {
            return this.logger.isWarnEnabled();
        }
        return false;
    }

    public boolean isInfoEnabled() {
        if (this.logger != null) {
            return this.logger.isInfoEnabled();
        }
        return false;
    }

    public boolean isDebugEnabled() {
        if (this.logger != null) {
            return this.logger.isDebugEnabled();
        }
        return false;
    }

    public void error(Throwable t, String message) {
        if (this.logger != null && this.isErrorEnabled()) {
            this.logger.error(t, this.withPluginInfo(message));
        }
    }

    public void warn(Throwable t, String message) {
        if (this.logger != null && this.isWarnEnabled()) {
            this.logger.warn(t, this.withPluginInfo(message));
        }
    }

    public void info(Throwable t, String message) {
        if (this.logger != null && this.isInfoEnabled()) {
            this.logger.info(t, this.withPluginInfo(message));
        }
    }

    public void trace(Throwable t, String message) {
        if (this.logger != null && this.isTraceEnabled()) {
            this.logger.trace(t, this.withPluginInfo(message));
        }
    }

    public void debug(Throwable t) {
        if (this.logger != null && this.isDebugEnabled()) {
            this.logger.debug(t);
        }
    }

    public void debug(Throwable t, String message) {
        if (this.logger != null && this.isDebugEnabled()) {
            this.logger.debug(t, this.withPluginInfo(message));
        }
    }

    private String withPluginInfo(String message) {
        return String.format("Plugin '%s': %s", Constants.PLUGIN_ID, message);
    }
}

