/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TypeOccurrenceCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public final class CreateCopyOfCompilationUnitChange
extends CreateTextFileChange {
    private final INewNameQuery fNameQuery;
    private final IJavaScriptUnit fOldCu;

    private static TextChangeManager createChangeManager(IProgressMonitor monitor, IJavaScriptUnit copy, String newName) throws CoreException {
        TextChangeManager manager = new TextChangeManager();
        SearchResultGroup refs = CreateCopyOfCompilationUnitChange.getReferences(copy, monitor);
        if (refs == null) {
            return manager;
        }
        if (refs.getCompilationUnit() == null) {
            return manager;
        }
        String name = RefactoringCoreMessages.CopyRefactoring_update_ref;
        SearchMatch[] results = refs.getSearchResults();
        int j = 0;
        while (j < results.length) {
            SearchMatch searchResult = results[j];
            if (searchResult.getAccuracy() != 1) {
                int offset = searchResult.getOffset();
                int length = searchResult.getLength();
                TextChangeCompatibility.addTextEdit(manager.get(copy), name, (TextEdit)new ReplaceEdit(offset, length, newName));
            }
            ++j;
        }
        return manager;
    }

    private static SearchPattern createSearchPattern(IType type) throws JavaScriptModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)type, (int)3, (int)24);
        IFunction[] constructors = JavaElementUtil.getAllConstructors(type);
        if (constructors.length == 0) {
            return pattern;
        }
        SearchPattern constructorDeclarationPattern = RefactoringSearchEngine.createOrPattern((IJavaScriptElement[])constructors, 0);
        return SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)constructorDeclarationPattern);
    }

    private static String getCopiedFileSource(IProgressMonitor monitor, IJavaScriptUnit unit, String newTypeName) throws CoreException {
        IJavaScriptUnit copy = unit.getPrimary().getWorkingCopy(null);
        try {
            String result;
            TextChangeManager manager = CreateCopyOfCompilationUnitChange.createChangeManager(monitor, copy, newTypeName);
            String string = result = manager.get(copy).getPreviewContent((IProgressMonitor)new NullProgressMonitor());
            return string;
        }
        finally {
            copy.discardWorkingCopy();
        }
    }

    private static SearchResultGroup getReferences(final IJavaScriptUnit copy, IProgressMonitor monitor) throws JavaScriptModelException {
        IJavaScriptUnit[] copies = new IJavaScriptUnit[]{copy};
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])copies);
        IType type = copy.findPrimaryType();
        if (type == null) {
            return null;
        }
        SearchPattern pattern = CreateCopyOfCompilationUnitChange.createSearchPattern(type);
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(pattern);
        engine.setScope(scope);
        engine.setWorkingCopies(copies);
        engine.searchPattern(monitor);
        engine.setRequestor(new IRefactoringSearchRequestor(type){
            TypeOccurrenceCollector fTypeOccurrenceCollector;
            {
                this.fTypeOccurrenceCollector = new TypeOccurrenceCollector(iType);
            }

            @Override
            public SearchMatch acceptSearchMatch(SearchMatch match) {
                try {
                    return this.fTypeOccurrenceCollector.acceptSearchMatch2(copy, match);
                }
                catch (CoreException e) {
                    JavaScriptPlugin.log(e);
                    return null;
                }
            }
        });
        Object[] results = engine.getResults();
        int index = 0;
        while (index < results.length) {
            SearchResultGroup group = (SearchResultGroup)results[index];
            if (group.getCompilationUnit().equals(copy)) {
                return group;
            }
            ++index;
        }
        return null;
    }

    public CreateCopyOfCompilationUnitChange(IPath path, String source, IJavaScriptUnit oldCu, INewNameQuery nameQuery) {
        super(path, source, null, "java");
        this.fOldCu = oldCu;
        this.fNameQuery = nameQuery;
        this.setEncoding(oldCu);
    }

    @Override
    public String getName() {
        return Messages.format(RefactoringCoreMessages.CreateCopyOfCompilationUnitChange_create_copy, new String[]{this.fOldCu.getElementName(), this.getPathLabel(this.fOldCu.getResource())});
    }

    @Override
    protected IFile getOldFile(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            monitor.beginTask("", 12);
            String oldSource = super.getSource();
            IPath oldPath = super.getPath();
            String newTypeName = this.fNameQuery.getNewName();
            try {
                String newSource = CreateCopyOfCompilationUnitChange.getCopiedFileSource((IProgressMonitor)new SubProgressMonitor(monitor, 9), this.fOldCu, newTypeName);
                this.setSource(newSource);
                this.setPath(this.fOldCu.getResource().getParent().getFullPath().append(JavaModelUtil.getRenamedCUName(this.fOldCu, newTypeName)));
                IFile iFile = super.getOldFile((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return iFile;
            }
            catch (CoreException coreException) {
                this.setSource(oldSource);
                this.setPath(oldPath);
                IFile iFile = super.getOldFile((IProgressMonitor)new SubProgressMonitor(monitor, 2));
                monitor.done();
                return iFile;
            }
        }
        finally {
            monitor.done();
        }
    }

    private String getPathLabel(IResource resource) {
        StringBuffer buffer = new StringBuffer(resource.getProject().getName());
        String path = resource.getParent().getProjectRelativePath().toString();
        if (path.length() > 0) {
            buffer.append('/');
            buffer.append(path);
        }
        return buffer.toString();
    }

    private void markAsExecuted(IJavaScriptUnit unit, ResourceMapping mapping) {
        ReorgExecutionLog log = (ReorgExecutionLog)this.getAdapter(ReorgExecutionLog.class);
        if (log != null) {
            log.markAsProcessed((Object)unit);
            log.markAsProcessed((Object)mapping);
        }
    }

    @Override
    public Change perform(IProgressMonitor monitor) throws CoreException {
        ResourceMapping mapping = JavaElementResourceMapping.create(this.fOldCu);
        Change result = super.perform(monitor);
        this.markAsExecuted(this.fOldCu, mapping);
        return result;
    }

    private void setEncoding(IJavaScriptUnit unit) {
        IResource resource = unit.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        try {
            String encoding = file.getCharset(false);
            if (encoding != null) {
                this.setEncoding(encoding, true);
            } else {
                encoding = file.getCharset(true);
                if (encoding != null) {
                    this.setEncoding(encoding, false);
                }
            }
        }
        catch (CoreException coreException) {}
    }
}

