/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.specialized.W11AddressExtensibilityElementAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLAdapterFactoryHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilderImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class W11SetAddressCommand
extends W11TopLevelElementCommand {
    private Port port;
    private String newAddress;

    public W11SetAddressCommand(Port port, String newAddress) {
        super(Messages._UI_ACTION_EDIT_PORT_ADDRESS, port.getEnclosingDefinition());
        this.port = port;
        this.newAddress = newAddress;
    }

    @Override
    public void execute() {
        try {
            this.beginRecording(this.port.getElement());
            if (!this.setAddress()) {
                this.createNewExtensibilityElement();
                this.setAddress();
            }
        }
        finally {
            this.endRecording(this.port.getElement());
        }
    }

    private boolean setAddress() {
        boolean success = false;
        if (this.port.getEExtensibilityElements().size() > 0) {
            for (Notifier notifier : this.port.getEExtensibilityElements()) {
                Adapter adapter = WSDLAdapterFactoryHelper.getInstance().adapt(notifier);
                if (!(adapter instanceof W11AddressExtensibilityElementAdapter)) continue;
                ((W11AddressExtensibilityElementAdapter)adapter).setLocationURI(this.newAddress);
                success = true;
            }
        }
        return success;
    }

    private void createNewExtensibilityElement() {
        ArrayList modelQueryActionList = new ArrayList();
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.port.getElement().getOwnerDocument());
        CMElementDeclaration ed = modelQuery.getCMElementDeclaration(this.port.getElement());
        if (ed != null) {
            int ic = 2;
            int vc = 2;
            modelQuery.getInsertActions(this.port.getElement(), ed, -1, ic, vc, modelQueryActionList);
        }
        this.createNewExtensibilityElementHelper1(modelQueryActionList);
    }

    private void createNewExtensibilityElementHelper1(List modelQueryActionList) {
        for (ModelQueryAction action : modelQueryActionList) {
            CMNode cmnode = action.getCMNode();
            if (cmnode == null) continue;
            boolean isOtherNamespace = false;
            CMDocument cmDocument = (CMDocument)cmnode.getProperty("CMDocument");
            if (cmDocument != null) {
                String namespaceURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
                boolean bl = isOtherNamespace = namespaceURI != null && !namespaceURI.equals("http://schemas.xmlsoap.org/wsdl/");
            }
            if (!isOtherNamespace) continue;
            int cmNodeType = cmnode.getNodeType();
            if (action.getKind() != 1) continue;
            switch (cmNodeType) {
                case 5: {
                    this.createNewExtensibilityElementHelper2((CMNode)((CMElementDeclaration)cmnode), action.getParent(), action.getStartIndex());
                    return;
                }
            }
        }
    }

    public void createNewExtensibilityElementHelper2(CMNode cmnode, Node parent, int index) {
        if (cmnode != null && parent != null) {
            Document document = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
            DOMContentBuilderImpl builder = new DOMContentBuilderImpl(document);
            builder.setProperty("buildBlankTextNodes", (Object)Boolean.TRUE);
            builder.setBuildPolicy(12);
            builder.build(parent, cmnode);
            this.insertNodesAtIndex(parent, builder.getResult(), index, true);
        }
    }

    public void insertNodesAtIndex(Node parent, List list, int index, boolean format) {
        Node prevChild;
        NodeList nodeList = parent.getChildNodes();
        if (index == -1) {
            index = nodeList.getLength();
        }
        Node refChild = index < nodeList.getLength() ? nodeList.item(index) : null;
        int prevIndex = index - 1;
        Node node = prevChild = prevIndex < nodeList.getLength() ? nodeList.item(prevIndex) : null;
        if (this.isWhitespaceTextNode(prevChild)) {
            refChild = prevChild;
        }
        for (Node newNode : list) {
            if (newNode.getNodeType() == 2) {
                Element parentElement = (Element)parent;
                parentElement.setAttributeNode((Attr)newNode);
                continue;
            }
            parent.insertBefore(newNode, refChild);
        }
        for (Node newNode : list) {
            if (!format) continue;
            FormatProcessorXML formatProcessorXML = new FormatProcessorXML();
            formatProcessorXML.formatNode((Node)((IDOMNode)newNode));
        }
    }

    protected boolean isWhitespaceTextNode(Node node) {
        return node != null && node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }
}

