/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test;

import java.io.InputStream;
import java.util.Properties;
import org.eclipse.gemini.blueprint.test.AbstractOnTheFlyBundleCreatorTests;
import org.eclipse.gemini.blueprint.test.internal.util.IOUtils;
import org.osgi.framework.BundleContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public abstract class AbstractConfigurableBundleCreatorTests
extends AbstractOnTheFlyBundleCreatorTests {
    protected static final String ROOT_DIR = "root.dir";
    protected static final String INCLUDE_PATTERNS = "include.patterns";
    protected static final String LIBS = "libs";
    protected static final String MANIFEST = "manifest";
    private static final Properties DEFAULT_SETTINGS = new Properties();
    private static Properties jarSettings;

    protected String getRootPath() {
        return jarSettings.getProperty(ROOT_DIR);
    }

    protected String[] getBundleContentPattern() {
        return StringUtils.commaDelimitedListToStringArray((String)jarSettings.getProperty(INCLUDE_PATTERNS));
    }

    protected String getManifestLocation() {
        return jarSettings.getProperty(MANIFEST);
    }

    protected String getSettingsLocation() {
        return ((Object)((Object)this)).getClass().getName().replace('.', '/') + "-bundle.properties";
    }

    protected Properties getDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties getSettings() throws Exception {
        Properties settings = new Properties(this.getDefaultSettings());
        ClassPathResource resource = new ClassPathResource(this.getSettingsLocation());
        if (resource.exists()) {
            InputStream stream = resource.getInputStream();
            try {
                if (stream == null) return settings;
                settings.load(stream);
                this.logger.debug((Object)("Loaded jar settings from " + this.getSettingsLocation()));
                return settings;
            }
            finally {
                IOUtils.closeStream(stream);
            }
        } else {
            this.logger.info((Object)(this.getSettingsLocation() + " was not found; using defaults"));
        }
        return settings;
    }

    protected void postProcessBundleContext(BundleContext context) throws Exception {
        jarSettings = null;
        jarSettings = this.getSettings();
        this.jarCreator.setRootPath(this.getRootPath());
        super.postProcessBundleContext(context);
    }

    static {
        DEFAULT_SETTINGS.setProperty(ROOT_DIR, "file:./target/test-classes/");
        DEFAULT_SETTINGS.setProperty(INCLUDE_PATTERNS, "/**/*");
        DEFAULT_SETTINGS.setProperty(LIBS, "");
        DEFAULT_SETTINGS.setProperty(MANIFEST, "");
    }
}

