/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.MessageRefFeatureDescriptor;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.OperationRefFeatureDescriptor;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.TaskPropertiesAdapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class SendTaskPropertiesAdapter
extends TaskPropertiesAdapter<SendTask> {
    public SendTaskPropertiesAdapter(AdapterFactory adapterFactory, SendTask object) {
        super(adapterFactory, object);
        EReference feature = Bpmn2Package.eINSTANCE.getSendTask_MessageRef();
        this.setProperty((EStructuralFeature)feature, "ui.can.create.new", Boolean.TRUE);
        this.setProperty((EStructuralFeature)feature, "ui.can.edit", Boolean.TRUE);
        this.setProperty((EStructuralFeature)feature, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)feature, new MessageRefFeatureDescriptor<SendTask>((ExtendedPropertiesAdapter)this, object, (EStructuralFeature)feature){

            @Override
            protected void internalSet(SendTask sendTask, EStructuralFeature feature, Object value, int index) {
                if (value instanceof Message || value == null) {
                    SendTaskPropertiesAdapter.this.setMessageRef(sendTask, (Message)value);
                }
            }
        });
        feature = Bpmn2Package.eINSTANCE.getSendTask_OperationRef();
        this.setProperty((EStructuralFeature)feature, "ui.can.create.new", Boolean.TRUE);
        this.setProperty((EStructuralFeature)feature, "ui.can.edit", Boolean.TRUE);
        this.setProperty((EStructuralFeature)feature, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)feature, new OperationRefFeatureDescriptor<SendTask>((ExtendedPropertiesAdapter)this, object, (EStructuralFeature)feature){

            protected void internalSet(SendTask sendTask, EStructuralFeature feature, Object value, int index) {
                if (value instanceof Operation || value == null) {
                    SendTaskPropertiesAdapter.this.setOperationRef(sendTask, (Operation)value);
                }
            }
        });
    }

    private void setMessageRef(SendTask sendTask, Message message) {
        ResourceSet resourceSet = sendTask.eResource().getResourceSet();
        if (sendTask.getMessageRef() != message) {
            sendTask.setMessageRef(message);
            List shapes = DIUtils.getContainerShapes((ResourceSet)resourceSet, (BaseElement)sendTask);
            for (ContainerShape shape : shapes) {
                for (Anchor a : shape.getAnchors()) {
                    for (Connection c : a.getOutgoingConnections()) {
                        BaseElement o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)c);
                        if (o instanceof MessageFlow && ((MessageFlow)o).getMessageRef() != message) {
                            ((MessageFlow)o).setMessageRef(message);
                        }
                        if (!((o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)c.getEnd().getParent())) instanceof ReceiveTask) || ((ReceiveTask)o).getMessageRef() == message) continue;
                        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)o);
                        adapter.getFeatureDescriptor((EStructuralFeature)Bpmn2Package.eINSTANCE.getReceiveTask_MessageRef()).setValue((Object)message);
                    }
                }
            }
        }
    }

    private void setOperationRef(SendTask sendTask, Operation operation) {
        if (sendTask.getOperationRef() != operation) {
            sendTask.setOperationRef(operation);
            Message message = operation == null ? null : operation.getOutMessageRef();
            this.setMessageRef(sendTask, message);
        }
    }
}

