/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features;

import java.util.Hashtable;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public abstract class AbstractRotateContainerFeature
extends AbstractCustomFeature {
    public AbstractRotateContainerFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_ROTATE;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            Object parent;
            PictogramElement pe = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            if (pe instanceof ContainerShape && (bo instanceof Participant || bo instanceof Lane) && (parent = this.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)pe).getContainer())) instanceof BPMNDiagram) {
                return true;
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && pes[0] instanceof ContainerShape) {
            ContainerShape container = (ContainerShape)pes[0];
            boolean horz = FeatureSupport.isHorizontal((ContainerShape)container);
            Hashtable<Shape, Point> offsetMap = new Hashtable<Shape, Point>();
            this.changeOrientation(container, !horz, offsetMap);
            this.layoutPictogramElement((PictogramElement)container);
            for (Shape shape : offsetMap.keySet()) {
                FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), (AnchorContainer)shape);
            }
            UpdateContext updateContext = new UpdateContext((PictogramElement)container);
            updateContext.putProperty((Object)"force.update.all", (Object)Boolean.TRUE);
            updateContext.putProperty((Object)"label.offset.map", offsetMap);
            this.getFeatureProvider().updateIfPossible((IUpdateContext)updateContext);
        }
    }

    private void changeOrientation(ContainerShape container, boolean horz, Hashtable<Shape, Point> offsetMap) {
        if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)container)) {
            return;
        }
        IGaService gaService = Graphiti.getGaService();
        GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
        int x = ga.getX();
        int y = ga.getY();
        int width = ga.getWidth();
        int height = ga.getHeight();
        if (FeatureSupport.isParticipant((PictogramElement)container) || FeatureSupport.isLane((PictogramElement)container)) {
            gaService.setLocationAndSize(ga, x, y, height, width);
            FeatureSupport.setHorizontal((ContainerShape)container, (boolean)horz);
        } else {
            gaService.setLocationAndSize(ga, y - width / 2 + height / 2, x - height / 2 + width / 2, width, height);
            this.layoutPictogramElement((PictogramElement)container);
        }
        DIUtils.updateDIShape((PictogramElement)container);
        for (Shape shape : container.getChildren()) {
            if (!FeatureSupport.hasBPMNShape((PictogramElement)shape)) continue;
            ILocation preLoc = Graphiti.getPeService().getLocationRelativeToDiagram(shape);
            this.changeOrientation((ContainerShape)shape, horz, offsetMap);
            if (BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)shape) instanceof ChoreographyTask) {
                ChoreographyUtil.updateChoreographyMessageLinks((IFeatureProvider)this.getFeatureProvider(), (PictogramElement)shape);
            }
            ILocation postLoc = Graphiti.getPeService().getLocationRelativeToDiagram(shape);
            Point p = Graphiti.getCreateService().createPoint(postLoc.getX() - preLoc.getX(), postLoc.getY() - preLoc.getY());
            offsetMap.put(shape, p);
        }
    }
}

