/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import java.math.BigInteger;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextObjectEditor;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class IntObjectEditor
extends TextObjectEditor {
    public IntObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        this.createLabel(composite, label);
        this.text = this.getToolkit().createText(composite, "");
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        IntObjectEditor.this.showErrorMessage(NLS.bind((String)Messages.IntObjectEditor_Invalid_Character, (Object)e.text));
                        return;
                    }
                    ++i;
                }
            }
        });
        this.updateText();
        ISWTObservableValue textObserveTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.text);
        textObserveTextObserveWidget.addValueChangeListener((IValueChangeListener)new IValueChangeListener<String>(){

            public void handleValueChange(ValueChangeEvent<? extends String> event) {
                try {
                    Long i = Long.parseLong(IntObjectEditor.this.text.getText());
                    if (!IntObjectEditor.this.getValue().equals(i)) {
                        this.setFeatureValue(i);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setFeatureValue(0L);
                }
            }

            private void setFeatureValue(long i) {
                IntObjectEditor.this.getBusinessObjectDelegate().setValue(IntObjectEditor.this.object, IntObjectEditor.this.feature, Long.toString(i));
            }
        });
        return this.text;
    }

    @Override
    public Long getValue() {
        Object v = this.getBusinessObjectDelegate().getValue(this.object, this.feature);
        if (v instanceof Short) {
            return ((Short)v).longValue();
        }
        if (v instanceof Integer) {
            return ((Integer)v).longValue();
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).longValue();
        }
        if (v instanceof String) {
            try {
                return Long.parseLong((String)v);
            }
            catch (Exception exception) {}
        }
        return 0L;
    }
}

