/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class MultiInstanceLoopCharacteristicsPropertiesAdapter
extends ExtendedPropertiesAdapter<MultiInstanceLoopCharacteristics> {
    protected static final EStructuralFeature LOOP_DATA_INPUT_REF = Bpmn2Package.eINSTANCE.getMultiInstanceLoopCharacteristics_LoopDataInputRef();
    protected static final EStructuralFeature INPUT_DATA_ITEM = Bpmn2Package.eINSTANCE.getMultiInstanceLoopCharacteristics_InputDataItem();
    protected static final EStructuralFeature LOOP_DATA_OUTPUT_REF = Bpmn2Package.eINSTANCE.getMultiInstanceLoopCharacteristics_LoopDataOutputRef();
    protected static final EStructuralFeature OUTPUT_DATA_ITEM = Bpmn2Package.eINSTANCE.getMultiInstanceLoopCharacteristics_OutputDataItem();

    public MultiInstanceLoopCharacteristicsPropertiesAdapter(AdapterFactory adapterFactory, MultiInstanceLoopCharacteristics object) {
        super(adapterFactory, (EObject)object);
        this.setProperty(LOOP_DATA_INPUT_REF, "ui.is.multi.choice", Boolean.TRUE);
        this.setProperty(LOOP_DATA_INPUT_REF, "ui.can.edit", Boolean.TRUE);
        this.setProperty(LOOP_DATA_INPUT_REF, "ui.can.create.new", Boolean.TRUE);
        this.setProperty(LOOP_DATA_OUTPUT_REF, "ui.is.multi.choice", Boolean.TRUE);
        this.setProperty(LOOP_DATA_OUTPUT_REF, "ui.can.edit", Boolean.TRUE);
        this.setProperty(LOOP_DATA_OUTPUT_REF, "ui.can.create.new", Boolean.TRUE);
        this.setFeatureDescriptor(LOOP_DATA_INPUT_REF, new LoopDataInputCollectionFeatureDescriptor(this, object));
        this.setFeatureDescriptor(INPUT_DATA_ITEM, new LoopInputDataItemFeatureDescriptor(this, object));
        this.setFeatureDescriptor(LOOP_DATA_OUTPUT_REF, new LoopDataOutputCollectionFeatureDescriptor(this, object));
        this.setFeatureDescriptor(OUTPUT_DATA_ITEM, new LoopOutputDataItemFeatureDescriptor(this, object));
    }

    private ItemAwareElement setInputCollection(MultiInstanceLoopCharacteristics milc, Activity subprocess, ItemAwareElement element) {
        InputOutputSpecification ioSpec = subprocess.getIoSpecification();
        Resource resource = this.getResource();
        if (element != null) {
            DataInput input = null;
            InputSet inputSet = null;
            DataInputAssociation inputAssociation = null;
            if (ioSpec == null) {
                ioSpec = (InputOutputSpecification)Bpmn2ModelerFactory.create((Resource)resource, InputOutputSpecification.class);
                subprocess.setIoSpecification(ioSpec);
            } else {
                for (DataInput din : ioSpec.getDataInputs()) {
                    if (din != milc.getLoopDataInputRef()) continue;
                    input = din;
                    break;
                }
            }
            if (input == null) {
                input = (DataInput)Bpmn2ModelerFactory.create((Resource)resource, DataInput.class);
            }
            input.setName(element.getId());
            input.setItemSubjectRef(element.getItemSubjectRef());
            input.setIsCollection(true);
            if (!ioSpec.getDataInputs().contains(input)) {
                ioSpec.getDataInputs().add(input);
            }
            for (InputSet is : ioSpec.getInputSets()) {
                if (!is.getDataInputRefs().contains(input)) continue;
                inputSet = is;
                break;
            }
            if (inputSet == null) {
                if (ioSpec.getInputSets().size() == 0) {
                    inputSet = (InputSet)Bpmn2ModelerFactory.create((Resource)resource, InputSet.class);
                    ioSpec.getInputSets().add(inputSet);
                } else {
                    inputSet = (InputSet)ioSpec.getInputSets().get(0);
                }
            }
            if (!inputSet.getDataInputRefs().contains(input)) {
                inputSet.getDataInputRefs().add(input);
            }
            for (DataInputAssociation dia : subprocess.getDataInputAssociations()) {
                if (dia.getTargetRef() != input) continue;
                inputAssociation = dia;
                break;
            }
            if (inputAssociation == null) {
                inputAssociation = (DataInputAssociation)Bpmn2ModelerFactory.create((Resource)resource, DataInputAssociation.class);
                subprocess.getDataInputAssociations().add(inputAssociation);
            }
            inputAssociation.setTargetRef((ItemAwareElement)input);
            inputAssociation.getSourceRef().clear();
            inputAssociation.getSourceRef().add(element);
            element = input;
        } else {
            ItemAwareElement input = milc.getLoopDataInputRef();
            if (ioSpec != null) {
                if (input != null) {
                    for (DataInput din : ioSpec.getDataInputs()) {
                        if (din != input) continue;
                        ioSpec.getDataInputs().remove(din);
                        if (ioSpec.getInputSets().size() <= 0) break;
                        ((InputSet)ioSpec.getInputSets().get(0)).getDataInputRefs().remove(din);
                        if (((InputSet)ioSpec.getInputSets().get(0)).getDataInputRefs().size() != 0) break;
                        ioSpec.getInputSets().remove(0);
                        break;
                    }
                    int i = 0;
                    for (DataInputAssociation dia : subprocess.getDataInputAssociations()) {
                        if (dia.getTargetRef() == input) {
                            subprocess.getDataInputAssociations().remove(i);
                            break;
                        }
                        ++i;
                    }
                }
                if (ioSpec.getDataInputs().size() == 0 && ioSpec.getDataOutputs().size() == 0) {
                    subprocess.setIoSpecification(null);
                }
            }
        }
        return element;
    }

    private ItemAwareElement setOutputCollection(MultiInstanceLoopCharacteristics milc, Activity activity, ItemAwareElement element) {
        InputOutputSpecification ioSpec = activity.getIoSpecification();
        Resource resource = this.getResource();
        if (element != null) {
            DataOutput output = null;
            OutputSet outputSet = null;
            DataOutputAssociation outputAssociation = null;
            if (ioSpec == null) {
                ioSpec = (InputOutputSpecification)Bpmn2ModelerFactory.create((Resource)resource, InputOutputSpecification.class);
                activity.setIoSpecification(ioSpec);
            } else {
                for (DataOutput dout : ioSpec.getDataOutputs()) {
                    if (dout != milc.getLoopDataOutputRef()) continue;
                    output = dout;
                    break;
                }
            }
            if (output == null) {
                output = (DataOutput)Bpmn2ModelerFactory.create((Resource)resource, DataOutput.class);
            }
            output.setName(element.getId());
            output.setItemSubjectRef(element.getItemSubjectRef());
            output.setIsCollection(true);
            if (!ioSpec.getDataOutputs().contains(output)) {
                ioSpec.getDataOutputs().add(output);
            }
            for (OutputSet os : ioSpec.getOutputSets()) {
                if (!os.getDataOutputRefs().contains(output)) continue;
                outputSet = os;
                break;
            }
            if (outputSet == null) {
                if (ioSpec.getOutputSets().size() == 0) {
                    outputSet = (OutputSet)Bpmn2ModelerFactory.create((Resource)resource, OutputSet.class);
                    ioSpec.getOutputSets().add(outputSet);
                } else {
                    outputSet = (OutputSet)ioSpec.getOutputSets().get(0);
                }
            }
            if (!outputSet.getDataOutputRefs().contains(output)) {
                outputSet.getDataOutputRefs().add(output);
            }
            for (DataOutputAssociation doa : activity.getDataOutputAssociations()) {
                if (doa.getSourceRef().size() != 1 || doa.getSourceRef().get(0) != output) continue;
                outputAssociation = doa;
                break;
            }
            if (outputAssociation == null) {
                outputAssociation = (DataOutputAssociation)Bpmn2ModelerFactory.create((Resource)resource, DataOutputAssociation.class);
                activity.getDataOutputAssociations().add(outputAssociation);
            }
            outputAssociation.getSourceRef().clear();
            outputAssociation.getSourceRef().add(output);
            outputAssociation.setTargetRef(element);
            element = output;
        } else {
            ItemAwareElement output = milc.getLoopDataOutputRef();
            if (ioSpec != null) {
                if (output != null) {
                    for (DataOutput dout : ioSpec.getDataOutputs()) {
                        if (dout != output) continue;
                        ioSpec.getDataOutputs().remove(dout);
                        if (ioSpec.getOutputSets().size() <= 0) break;
                        ((OutputSet)ioSpec.getOutputSets().get(0)).getDataOutputRefs().remove(dout);
                        if (((OutputSet)ioSpec.getOutputSets().get(0)).getDataOutputRefs().size() != 0) break;
                        ioSpec.getOutputSets().remove(0);
                        break;
                    }
                    int i = 0;
                    for (DataOutputAssociation doa : activity.getDataOutputAssociations()) {
                        if (doa.getSourceRef().size() > 0 && doa.getSourceRef().get(0) == output) {
                            activity.getDataOutputAssociations().remove(i);
                            break;
                        }
                        ++i;
                    }
                }
                if (ioSpec.getDataInputs().size() == 0 && ioSpec.getDataOutputs().size() == 0) {
                    activity.setIoSpecification(null);
                }
            }
        }
        return element;
    }

    private ItemAwareElement setSubProcessInputItem(MultiInstanceLoopCharacteristics milc, SubProcess subprocess, ItemAwareElement element) {
        return element;
    }

    private ItemAwareElement setSubProcessOutputItem(MultiInstanceLoopCharacteristics milc, SubProcess subprocess, ItemAwareElement element) {
        return element;
    }

    private ItemAwareElement setTaskInputItem(MultiInstanceLoopCharacteristics milc, Task task, ItemAwareElement element) {
        Resource resource = task.eResource();
        DataInput oldDin = milc.getInputDataItem();
        if (oldDin != null) {
            for (DataInputAssociation dia : task.getDataInputAssociations()) {
                if (!dia.getSourceRef().contains(oldDin)) continue;
                task.getDataInputAssociations().remove(dia);
                break;
            }
        }
        DataInputAssociation dataInputAssociation = null;
        for (DataInputAssociation dia : task.getDataInputAssociations()) {
            if (dia.getTargetRef() != element) continue;
            dataInputAssociation = dia;
            break;
        }
        if (dataInputAssociation == null) {
            dataInputAssociation = (DataInputAssociation)Bpmn2ModelerFactory.create((Resource)resource, DataInputAssociation.class);
            task.getDataInputAssociations().add(dataInputAssociation);
            dataInputAssociation.setTargetRef(element);
        }
        DataInput din = (DataInput)Bpmn2ModelerFactory.create((Resource)resource, DataInput.class);
        din.setName(((DataInput)element).getName());
        din.setItemSubjectRef(element.getItemSubjectRef());
        dataInputAssociation.getSourceRef().clear();
        dataInputAssociation.getSourceRef().add(din);
        return din;
    }

    private ItemAwareElement setTaskOutputItem(MultiInstanceLoopCharacteristics milc, Task task, ItemAwareElement element) {
        Resource resource = task.eResource();
        DataOutput oldDout = milc.getOutputDataItem();
        if (oldDout != null) {
            for (DataOutputAssociation doa : task.getDataOutputAssociations()) {
                if (doa.getTargetRef() != oldDout) continue;
                task.getDataOutputAssociations().remove(doa);
                break;
            }
        }
        DataOutputAssociation dataOutputAssociation = null;
        for (DataOutputAssociation doa : task.getDataOutputAssociations()) {
            if (!doa.getSourceRef().contains(element)) continue;
            dataOutputAssociation = doa;
            break;
        }
        if (dataOutputAssociation == null) {
            dataOutputAssociation = (DataOutputAssociation)Bpmn2ModelerFactory.create((Resource)resource, DataOutputAssociation.class);
            task.getDataOutputAssociations().add(dataOutputAssociation);
            dataOutputAssociation.getSourceRef().clear();
            dataOutputAssociation.getSourceRef().add(element);
        }
        DataOutput dout = (DataOutput)Bpmn2ModelerFactory.create((Resource)resource, DataOutput.class);
        dout.setName(((DataOutput)element).getName());
        dout.setItemSubjectRef(element.getItemSubjectRef());
        dataOutputAssociation.setTargetRef((ItemAwareElement)dout);
        return dout;
    }

    protected class LoopDataCollectionFeatureDescriptor
    extends FeatureDescriptor<MultiInstanceLoopCharacteristics> {
        public LoopDataCollectionFeatureDescriptor(ExtendedPropertiesAdapter<MultiInstanceLoopCharacteristics> owner, MultiInstanceLoopCharacteristics object, EStructuralFeature feature) {
            super(owner, (EObject)object, feature);
            Assert.isTrue((feature == LOOP_DATA_INPUT_REF || feature == LOOP_DATA_OUTPUT_REF ? 1 : 0) != 0);
        }

        public EObject createFeature(Resource resource, EClass eclass) {
            EObject value = super.createFeature(resource, eclass);
            Activity container = (Activity)ModelUtil.getContainer((EObject)this.object);
            EStructuralFeature f = container.eClass().getEStructuralFeature("ioSpecification");
            if (f != null) {
                InputOutputSpecification ioSpecification = (InputOutputSpecification)container.eGet(f);
                if (ioSpecification == null) {
                    ioSpecification = (InputOutputSpecification)Bpmn2ModelerFactory.createFeature((Resource)((MultiInstanceLoopCharacteristics)this.object).eResource(), (EObject)container, (EStructuralFeature)f, InputOutputSpecification.class);
                }
                if (value instanceof DataInput) {
                    ioSpecification.getDataInputs().add((DataInput)value);
                } else {
                    ioSpecification.getDataOutputs().add((DataOutput)value);
                }
            }
            return value;
        }

        public Hashtable<String, Object> getChoiceOfValues() {
            Hashtable choices = new Hashtable();
            Activity container = (Activity)ModelUtil.getContainer((EObject)this.object);
            ArrayList<EObject> values = new ArrayList<EObject>();
            EStructuralFeature f = container.eClass().getEStructuralFeature("ioSpecification");
            if (f != null) {
                InputOutputSpecification inputOutputSpecification = (InputOutputSpecification)container.eGet(f);
                if (inputOutputSpecification != null) {
                    if (this.feature == LOOP_DATA_INPUT_REF) {
                        values.addAll(inputOutputSpecification.getDataInputs());
                    } else {
                        values.addAll(inputOutputSpecification.getDataOutputs());
                    }
                }
                values.remove(((MultiInstanceLoopCharacteristics)this.object).getLoopDataInputRef());
                values.remove(((MultiInstanceLoopCharacteristics)this.object).getLoopDataOutputRef());
            }
            List list = ModelUtil.collectAncestorObjects((EObject)this.object, (String)"flowElements", (Class[])new Class[]{Process.class, SubProcess.class});
            for (EObject fe : list) {
                if (fe instanceof DataObjectReference) {
                    fe = ((DataObjectReference)fe).getDataObjectRef();
                }
                if (!(fe instanceof DataObject)) {
                    fe = null;
                }
                if (fe == null || values.contains(fe)) continue;
                values.add(fe);
            }
            EObject parent = container.eContainer();
            while (parent != null) {
                if (parent instanceof Process) {
                    values.addAll(((Process)parent).getProperties());
                }
                if (parent instanceof SubProcess) {
                    values.addAll(((SubProcess)parent).getProperties());
                }
                parent = parent.eContainer();
            }
            if (values != null) {
                for (Object e : values) {
                    choices.put(this.getChoiceString(e), e);
                }
            }
            super.setChoiceOfValues(choices);
            return super.getChoiceOfValues();
        }

        public String getTextValue() {
            Object value = this.getValue();
            if (value != null) {
                return super.getChoiceString(value);
            }
            return "";
        }
    }

    protected class LoopDataInputCollectionFeatureDescriptor
    extends LoopDataCollectionFeatureDescriptor {
        public LoopDataInputCollectionFeatureDescriptor(ExtendedPropertiesAdapter<MultiInstanceLoopCharacteristics> owner, MultiInstanceLoopCharacteristics object) {
            super(owner, object, LOOP_DATA_INPUT_REF);
        }

        protected void internalSet(MultiInstanceLoopCharacteristics object, EStructuralFeature feature, Object value, int index) {
            ItemAwareElement element = null;
            if (value instanceof ItemAwareElement) {
                element = (ItemAwareElement)value;
            }
            if (object.eContainer() instanceof Activity) {
                value = MultiInstanceLoopCharacteristicsPropertiesAdapter.this.setInputCollection(object, (Activity)object.eContainer(), element);
            }
            super.internalSet((EObject)object, feature, value, index);
        }

        public Object getValue() {
            ItemAwareElement din = ((MultiInstanceLoopCharacteristics)this.object).getLoopDataInputRef();
            if (din == null) {
                return null;
            }
            if (((MultiInstanceLoopCharacteristics)this.object).eContainer() instanceof SubProcess) {
                return super.getValue();
            }
            if (((MultiInstanceLoopCharacteristics)this.object).eContainer() instanceof Task) {
                Task task = (Task)((MultiInstanceLoopCharacteristics)this.object).eContainer();
                for (DataInputAssociation dia : task.getDataInputAssociations()) {
                    if (din != dia.getTargetRef() || dia.getSourceRef().size() <= 0 || !(dia.getSourceRef().get(0) instanceof ItemAwareElement)) continue;
                    return dia.getSourceRef().get(0);
                }
            }
            return null;
        }
    }

    protected class LoopDataItemFeatureDescriptor
    extends FeatureDescriptor<MultiInstanceLoopCharacteristics> {
        public LoopDataItemFeatureDescriptor(ExtendedPropertiesAdapter<MultiInstanceLoopCharacteristics> owner, MultiInstanceLoopCharacteristics object, EStructuralFeature feature) {
            super(owner, (EObject)object, feature);
            Assert.isTrue((feature == INPUT_DATA_ITEM || feature == OUTPUT_DATA_ITEM ? 1 : 0) != 0);
        }

        public Hashtable<String, Object> getChoiceOfValues() {
            Hashtable<String, Object> choices;
            block4: {
                Activity activity;
                InputOutputSpecification iospec;
                choices = new Hashtable<String, Object>();
                EObject container = ModelUtil.getContainer((EObject)this.object);
                if (!(container instanceof Activity) || (iospec = (activity = (Activity)container).getIoSpecification()) == null) break block4;
                if (this.feature == INPUT_DATA_ITEM) {
                    for (ItemAwareElement e : iospec.getDataInputs()) {
                        if (((MultiInstanceLoopCharacteristics)this.object).getLoopDataInputRef() == e) continue;
                        choices.put(this.getChoiceString(e), e);
                    }
                } else {
                    for (ItemAwareElement e : iospec.getDataOutputs()) {
                        if (((MultiInstanceLoopCharacteristics)this.object).getLoopDataOutputRef() == e) continue;
                        choices.put(this.getChoiceString(e), e);
                    }
                }
            }
            return choices;
        }

        public String getTextValue() {
            Object value = this.getValue();
            if (value != null) {
                return super.getChoiceString(value);
            }
            return "";
        }
    }

    protected class LoopDataOutputCollectionFeatureDescriptor
    extends LoopDataCollectionFeatureDescriptor {
        public LoopDataOutputCollectionFeatureDescriptor(ExtendedPropertiesAdapter<MultiInstanceLoopCharacteristics> owner, MultiInstanceLoopCharacteristics object) {
            super(owner, object, LOOP_DATA_OUTPUT_REF);
        }

        protected void internalSet(MultiInstanceLoopCharacteristics object, EStructuralFeature feature, Object value, int index) {
            ItemAwareElement element = null;
            if (value instanceof ItemAwareElement) {
                element = (ItemAwareElement)value;
            }
            if (object.eContainer() instanceof Activity) {
                value = MultiInstanceLoopCharacteristicsPropertiesAdapter.this.setOutputCollection(object, (Activity)object.eContainer(), element);
            }
            super.internalSet((EObject)object, feature, value, index);
        }

        public Object getValue() {
            ItemAwareElement dout = ((MultiInstanceLoopCharacteristics)this.object).getLoopDataOutputRef();
            if (dout == null) {
                return null;
            }
            if (((MultiInstanceLoopCharacteristics)this.object).eContainer() instanceof SubProcess) {
                return super.getValue();
            }
            if (((MultiInstanceLoopCharacteristics)this.object).eContainer() instanceof Task) {
                Task task = (Task)((MultiInstanceLoopCharacteristics)this.object).eContainer();
                for (DataOutputAssociation doa : task.getDataOutputAssociations()) {
                    if (!doa.getSourceRef().contains(dout) || !(doa.getTargetRef() instanceof ItemAwareElement)) continue;
                    return doa.getTargetRef();
                }
            }
            return null;
        }
    }

    protected class LoopInputDataItemFeatureDescriptor
    extends LoopDataItemFeatureDescriptor {
        public LoopInputDataItemFeatureDescriptor(ExtendedPropertiesAdapter<MultiInstanceLoopCharacteristics> owner, MultiInstanceLoopCharacteristics object) {
            super(owner, object, INPUT_DATA_ITEM);
        }

        protected void internalSet(MultiInstanceLoopCharacteristics object, EStructuralFeature feature, Object value, int index) {
            ItemAwareElement element = null;
            if (value instanceof ItemAwareElement) {
                element = (ItemAwareElement)value;
            }
            if (object.eContainer() instanceof SubProcess) {
                value = MultiInstanceLoopCharacteristicsPropertiesAdapter.this.setSubProcessInputItem(object, (SubProcess)object.eContainer(), element);
            } else if (object.eContainer() instanceof Task) {
                value = MultiInstanceLoopCharacteristicsPropertiesAdapter.this.setTaskInputItem(object, (Task)object.eContainer(), element);
            }
            super.internalSet((EObject)object, feature, value, index);
        }

        public Object getValue() {
            DataInput din = ((MultiInstanceLoopCharacteristics)this.object).getInputDataItem();
            if (din == null) {
                return null;
            }
            if (((MultiInstanceLoopCharacteristics)this.object).eContainer() instanceof SubProcess) {
                return din;
            }
            if (((MultiInstanceLoopCharacteristics)this.object).eContainer() instanceof Task) {
                Task task = (Task)((MultiInstanceLoopCharacteristics)this.object).eContainer();
                for (DataInputAssociation dia : task.getDataInputAssociations()) {
                    if (!dia.getSourceRef().contains(din) || !(dia.getTargetRef() instanceof DataInput)) continue;
                    return dia.getTargetRef();
                }
            }
            return null;
        }
    }

    protected class LoopOutputDataItemFeatureDescriptor
    extends LoopDataItemFeatureDescriptor {
        public LoopOutputDataItemFeatureDescriptor(ExtendedPropertiesAdapter<MultiInstanceLoopCharacteristics> owner, MultiInstanceLoopCharacteristics object) {
            super(owner, object, OUTPUT_DATA_ITEM);
        }

        protected void internalSet(MultiInstanceLoopCharacteristics object, EStructuralFeature feature, Object value, int index) {
            ItemAwareElement element = null;
            if (value instanceof ItemAwareElement) {
                element = (ItemAwareElement)value;
            }
            if (object.eContainer() instanceof SubProcess) {
                value = MultiInstanceLoopCharacteristicsPropertiesAdapter.this.setSubProcessOutputItem(object, (SubProcess)object.eContainer(), element);
            } else if (object.eContainer() instanceof Task) {
                value = MultiInstanceLoopCharacteristicsPropertiesAdapter.this.setTaskOutputItem(object, (Task)object.eContainer(), element);
            }
            super.internalSet((EObject)object, feature, value, index);
        }

        public Object getValue() {
            DataOutput dout = ((MultiInstanceLoopCharacteristics)this.object).getOutputDataItem();
            if (dout == null) {
                return null;
            }
            if (((MultiInstanceLoopCharacteristics)this.object).eContainer() instanceof SubProcess) {
                return dout;
            }
            if (((MultiInstanceLoopCharacteristics)this.object).eContainer() instanceof Task) {
                Task task = (Task)((MultiInstanceLoopCharacteristics)this.object).eContainer();
                for (DataOutputAssociation dia : task.getDataOutputAssociations()) {
                    if (dia.getTargetRef() != dout || dia.getSourceRef().size() <= 0 || !(dia.getSourceRef().get(0) instanceof DataOutput)) continue;
                    return dia.getSourceRef().get(0);
                }
            }
            return null;
        }
    }
}

