/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import java.util.List;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class TaskViewActionStateRules {
    private TaskViewActionStateRules() {
    }

    public static boolean taskScopedTaskExecutionActionsVisibleFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return nodeSelection.hasAllNodesOfType(TaskNode.class);
    }

    public static TaskScopedActionEnablement taskScopedTaskExecutionActionsEnablement(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return TaskScopedActionEnablement.DISABLED_DEFAULT;
        }
        List<?> elements = nodeSelection.toList();
        ImmutableList taskNodes = FluentIterable.from(elements).filter(TaskNode.class).toList();
        if (elements.size() != taskNodes.size()) {
            return TaskScopedActionEnablement.DISABLED_DEFAULT;
        }
        if (TaskViewActionStateRules.hasMultipleOrIncludedParentProject((List<TaskNode>)taskNodes)) {
            return TaskScopedActionEnablement.DISABLED_INCLUDED_BUILD;
        }
        ImmutableList projectNodes = FluentIterable.from(elements).filter(ProjectTaskNode.class).toList();
        if (projectNodes.size() == taskNodes.size()) {
            return TaskScopedActionEnablement.ENABLED;
        }
        ImmutableList taskSelectorNodes = FluentIterable.from(elements).filter(TaskSelectorNode.class).toList();
        if (taskSelectorNodes.size() == taskNodes.size()) {
            boolean hasRootProjects = TaskViewActionStateRules.canFindRootProjects((List<TaskSelectorNode>)taskSelectorNodes);
            return hasRootProjects ? TaskScopedActionEnablement.ENABLED : TaskScopedActionEnablement.DISABLED_NO_ROOT_PROJECT;
        }
        return TaskScopedActionEnablement.DISABLED_DEFAULT;
    }

    private static boolean hasMultipleOrIncludedParentProject(List<TaskNode> nodes) {
        Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0);
        final ProjectNode firstParent = nodes.get(0).getParentProjectNode();
        if (firstParent.isIncludedProject()) {
            return true;
        }
        return Iterables.any(nodes, (Predicate)new Predicate<TaskNode>(){

            public boolean apply(TaskNode node) {
                return !node.getParentProjectNode().equals(firstParent);
            }
        });
    }

    private static boolean canFindRootProjects(List<TaskSelectorNode> nodes) {
        return Iterables.all(nodes, (Predicate)new Predicate<TaskNode>(){

            public boolean apply(TaskNode node) {
                OmniEclipseProject project = node.getParentProjectNode().getEclipseProject();
                Path projectPath = new Path(project.getProjectDirectory().getPath());
                IPath masterPath = projectPath.removeLastSegments(1).append("master");
                Path rootPath = new Path(project.getRoot().getProjectDirectory().getPath());
                return rootPath.isPrefixOf((IPath)projectPath) || rootPath.equals((Object)masterPath);
            }
        });
    }

    public static boolean projectScopedTaskExecutionActionsVisibleFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return nodeSelection.hasAllNodesOfType(ProjectNode.class);
    }

    public static boolean projectScopedTaskExecutionActionsEnabledFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return nodeSelection.hasAllNodesOfType(ProjectNode.class) && nodeSelection.isSingleSelection() && !nodeSelection.getFirstElement(ProjectNode.class).isIncludedProject();
    }

    public static enum TaskScopedActionEnablement {
        ENABLED,
        DISABLED_DEFAULT,
        DISABLED_INCLUDED_BUILD,
        DISABLED_NO_ROOT_PROJECT;


        public boolean asBoolean() {
            return this == ENABLED;
        }
    }
}

